/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.data;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.hostilenetworks.Hostile;
import shadows.hostilenetworks.item.MobPredictionItem;
import shadows.placebo.json.PlaceboJsonReloadListener;

public class DataModel
extends PlaceboJsonReloadListener.TypeKeyedBase<DataModel> {
    protected final EntityType<?> type;
    protected final TranslatableComponent name;
    protected final float guiScale;
    protected final float guiXOff;
    protected final float guiYOff;
    protected final float guiZOff;
    protected final int simCost;
    protected final ItemStack input;
    protected final ItemStack baseDrop;
    protected final String triviaKey;
    protected final List<ItemStack> fabDrops;

    public DataModel(EntityType<?> type, TranslatableComponent name, float guiScale, float guiXOff, float guiYOff, float guiZOff, int simCost, ItemStack input, ItemStack baseDrop, String triviaKey, List<ItemStack> fabDrops) {
        this.type = type;
        this.name = name;
        this.guiScale = guiScale;
        this.guiYOff = guiYOff;
        this.guiXOff = guiXOff;
        this.guiZOff = guiZOff;
        this.simCost = simCost;
        this.input = input;
        this.baseDrop = baseDrop;
        this.triviaKey = triviaKey;
        this.fabDrops = fabDrops;
    }

    public TranslatableComponent getName() {
        return this.name;
    }

    public String getTriviaKey() {
        return this.triviaKey;
    }

    public float getScale() {
        return this.guiScale;
    }

    public float getYOffset() {
        return this.guiYOff;
    }

    public float getXOffset() {
        return this.guiXOff;
    }

    public float getZOffset() {
        return this.guiZOff;
    }

    public int getSimCost() {
        return this.simCost;
    }

    public EntityType<?> getType() {
        return this.type;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getBaseDrop() {
        return this.baseDrop;
    }

    public List<ItemStack> getFabDrops() {
        return this.fabDrops;
    }

    public ItemStack getPredictionDrop() {
        ItemStack stk = new ItemStack((ItemLike)Hostile.Items.PREDICTION);
        MobPredictionItem.setStoredModel(stk, this);
        return stk;
    }

    public int getNameColor() {
        return this.name.m_7383_().m_131135_().m_131265_();
    }

    public boolean equals(Object obj) {
        return obj instanceof DataModel && ((DataModel)((Object)obj)).id.equals((Object)this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return String.format("DataModel[%s]", this.id);
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130070_(this.type.getRegistryName().toString());
        buf.m_130070_(this.name.m_131328_());
        buf.m_130070_(this.name.m_7383_().m_131135_().m_131274_());
        buf.writeFloat(this.guiScale);
        buf.writeFloat(this.guiXOff);
        buf.writeFloat(this.guiYOff);
        buf.writeFloat(this.guiZOff);
        buf.writeInt(this.simCost);
        buf.m_130055_(this.input);
        buf.m_130055_(this.baseDrop);
        buf.m_130070_(this.triviaKey);
        buf.m_130130_(this.fabDrops.size());
        for (ItemStack i : this.fabDrops) {
            buf.m_130055_(i);
        }
    }

    public static DataModel read(FriendlyByteBuf buf) {
        EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(buf.m_130277_()));
        TranslatableComponent name = new TranslatableComponent(buf.m_130277_());
        name.m_130948_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)buf.m_130277_())));
        float guiScale = buf.readFloat();
        float guiXOff = buf.readFloat();
        float guiYOff = buf.readFloat();
        float guiZOff = buf.readFloat();
        int simCost = buf.readInt();
        ItemStack input = buf.m_130267_();
        ItemStack baseDrop = buf.m_130267_();
        String triviaKey = buf.m_130277_();
        int dropSize = buf.m_130242_();
        ArrayList<ItemStack> fabDrops = new ArrayList<ItemStack>(dropSize);
        for (int i = 0; i < dropSize; ++i) {
            fabDrops.add(buf.m_130267_());
        }
        DataModel model = new DataModel(type, name, guiScale, guiXOff, guiYOff, guiZOff, simCost, input, baseDrop, triviaKey, fabDrops);
        return model;
    }
}

