/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.gui;

import java.util.function.Consumer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import shadows.hostilenetworks.Hostile;
import shadows.hostilenetworks.data.CachedModel;
import shadows.hostilenetworks.item.DataModelItem;
import shadows.hostilenetworks.item.DeepLearnerItem;
import shadows.placebo.container.PlaceboContainerMenu;

public class DeepLearnerContainer
extends PlaceboContainerMenu {
    protected final InteractionHand hand;
    protected final Player player;
    protected final ItemStack deepLearner;
    protected final ItemStackHandler learnerInv;
    protected Consumer<Integer> notifyCallback;

    public DeepLearnerContainer(int id, Inventory pInv, InteractionHand hand) {
        super(Hostile.Containers.DEEP_LEARNER, id, pInv);
        int row;
        this.hand = hand;
        this.player = pInv.f_35978_;
        this.deepLearner = this.player.m_21120_(hand);
        this.learnerInv = DeepLearnerItem.getItemHandler(this.deepLearner);
        this.m_38897_((Slot)new DataModelSlot((IItemHandler)this.learnerInv, 0, 256, 99));
        this.m_38897_((Slot)new DataModelSlot((IItemHandler)this.learnerInv, 1, 274, 99));
        this.m_38897_((Slot)new DataModelSlot((IItemHandler)this.learnerInv, 2, 256, 117));
        this.m_38897_((Slot)new DataModelSlot((IItemHandler)this.learnerInv, 3, 274, 117));
        this.playerInvStart = this.f_38839_.size();
        for (row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int x = 89 + column * 18;
                int y = 153 + row * 18;
                int index = column + row * 9 + 9;
                Slot slot2 = new Slot((Container)this.player.m_150109_(), index, x, y);
                this.m_38897_(slot2);
            }
        }
        this.hotbarStart = this.f_38839_.size();
        for (row = 0; row < 9; ++row) {
            int index = row;
            Slot slot3 = new Slot((Container)this.player.m_150109_(), index, 89 + row * 18, 211);
            if (hand == InteractionHand.MAIN_HAND && index == this.player.m_150109_().f_35977_) {
                slot3 = new LockedSlot((Container)this.player.m_150109_(), index, 89 + row * 18, 211);
            }
            this.m_38897_(slot3);
        }
        this.mover.registerRule((stack, slot) -> slot < 4, 4, this.f_38839_.size());
        this.mover.registerRule((stack, slot) -> stack.m_41720_() instanceof DataModelItem, 0, 4);
        this.registerInvShuffleRules();
    }

    public void setNotifyCallback(Consumer<Integer> r) {
        this.notifyCallback = r;
    }

    public boolean m_6875_(Player pPlayer) {
        return this.deepLearner.m_41720_() == Hostile.Items.DEEP_LEARNER && this.player.m_21120_(this.hand) == this.deepLearner;
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        DeepLearnerItem.saveItems(this.deepLearner, this.learnerInv);
        pPlayer.m_150109_().m_6596_();
    }

    public boolean hasModels() {
        boolean hasModels = false;
        for (int i = 0; i < 4; ++i) {
            if (this.learnerInv.getStackInSlot(i).m_41619_()) continue;
            hasModels = true;
        }
        return hasModels;
    }

    public void fillWithModels(CachedModel[] models) {
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = this.learnerInv.getStackInSlot(i);
            models[i] = stack.m_41619_() ? null : new CachedModel(stack, i);
        }
    }

    public class DataModelSlot
    extends SlotItemHandler {
        public DataModelSlot(IItemHandler handler, int index, int x, int y) {
            super(handler, index, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.m_41720_() instanceof DataModelItem;
        }

        public int m_6641_() {
            return 1;
        }

        public void m_6654_() {
            super.m_6654_();
            if (DeepLearnerContainer.this.notifyCallback != null) {
                DeepLearnerContainer.this.notifyCallback.accept(((Slot)this).f_40219_);
            }
        }
    }

    public class LockedSlot
    extends Slot {
        public LockedSlot(Container inv, int index, int x, int y) {
            super(inv, index, x, y);
        }

        public boolean m_8010_(Player player) {
            return false;
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }
    }
}

