/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import shadows.hostilenetworks.HostileConfig;
import shadows.hostilenetworks.data.CachedModel;
import shadows.hostilenetworks.data.ModelTier;
import shadows.hostilenetworks.gui.SimChamberContainer;
import shadows.hostilenetworks.item.DataModelItem;
import shadows.hostilenetworks.tile.SimChamberTileEntity;
import shadows.placebo.screen.PlaceboContainerScreen;
import shadows.placebo.screen.TickableText;

public class SimChamberScreen
extends PlaceboContainerScreen<SimChamberContainer> {
    public static final int WIDTH = 232;
    public static final int HEIGHT = 230;
    private static final ResourceLocation BASE = new ResourceLocation("hostilenetworks", "textures/gui/sim_chamber.png");
    private static final ResourceLocation PLAYER = new ResourceLocation("hostilenetworks", "textures/gui/default_gui.png");
    private List<TickableText> body = new ArrayList<TickableText>(7);
    private SimChamberTileEntity.FailureState lastFailState = SimChamberTileEntity.FailureState.NONE;
    private boolean runtimeTextLoaded = false;
    private static final Component ERROR = new TextComponent("ERROR").m_130940_(ChatFormatting.OBFUSCATED);

    public SimChamberScreen(SimChamberContainer pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 232;
        this.f_97727_ = 230;
    }

    protected void m_7025_(PoseStack pPoseStack, int pX, int pY) {
        if (this.m_6774_(211, 48, 7, 87, pX, pY)) {
            ArrayList<TranslatableComponent> txt = new ArrayList<TranslatableComponent>(2);
            txt.add(new TranslatableComponent("hostilenetworks.gui.energy", new Object[]{((SimChamberContainer)this.f_97732_).getEnergyStored(), HostileConfig.simPowerCap}));
            CachedModel cModel = new CachedModel(((SimChamberContainer)this.f_97732_).m_38853_(0).m_7993_(), 0);
            if (cModel.getModel() != null) {
                txt.add(new TranslatableComponent("hostilenetworks.gui.cost", new Object[]{cModel.getModel().getSimCost()}));
            }
            this.renderComponentTooltip(pPoseStack, txt, pX, pY, this.f_96547_);
        } else if (this.m_6774_(14, 48, 7, 87, pX, pY)) {
            CachedModel cModel = new CachedModel(((SimChamberContainer)this.f_97732_).m_38853_(0).m_7993_(), 0);
            if (cModel.getModel() != null) {
                ArrayList<Object> txt = new ArrayList<Object>(1);
                if (cModel.getTier() != cModel.getTier().next()) {
                    txt.add(new TranslatableComponent("hostilenetworks.gui.data", new Object[]{cModel.getData() - cModel.getTier().data, cModel.getTier().next().data - cModel.getTier().data}));
                } else {
                    txt.add(new TranslatableComponent("hostilenetworks.gui.max_data").m_130940_(ChatFormatting.RED));
                }
                this.renderComponentTooltip(pPoseStack, txt, pX, pY, this.f_96547_);
            }
        } else {
            super.m_7025_(pPoseStack, pX, pY);
        }
    }

    protected void m_7027_(PoseStack stack, int pX, int pY) {
        CachedModel cModel;
        int runtime = ((SimChamberContainer)this.f_97732_).getRuntime();
        if (runtime > 0) {
            int rTime = Math.min(99, Mth.m_14167_((float)(100.0f * (float)(300 - runtime) / 300.0f)));
            this.f_96547_.m_92750_(stack, rTime + "%", 184.0f, 123.0f, 6478079);
        }
        if ((cModel = new CachedModel(((SimChamberContainer)this.f_97732_).m_38853_(0).m_7993_(), 0)).getModel() != null) {
            int xOff = 18;
            String msg = I18n.m_118938_((String)"hostilenetworks.gui.target", (Object[])new Object[0]);
            this.f_96547_.m_92883_(stack, msg, (float)xOff, 9.0f, 0xFFFFFF);
            this.f_96547_.m_92889_(stack, (Component)cModel.getModel().getName(), (float)(xOff += this.f_96547_.m_92895_(msg)), 9.0f, 65472);
            xOff = 18;
            msg = I18n.m_118938_((String)"hostilenetworks.gui.tier", (Object[])new Object[0]);
            float f = xOff;
            Objects.requireNonNull(this.f_96547_);
            this.f_96547_.m_92883_(stack, msg, f, (float)(9 + 9 + 3), 0xFFFFFF);
            xOff += this.f_96547_.m_92895_(msg);
            msg = I18n.m_118938_((String)("hostilenetworks.tier." + cModel.getTier().name), (Object[])new Object[0]);
            float f2 = xOff;
            Objects.requireNonNull(this.f_96547_);
            this.f_96547_.m_92883_(stack, msg, f2, (float)(9 + 9 + 3), cModel.getTier().color.m_126665_().intValue());
            xOff = 18;
            msg = I18n.m_118938_((String)"hostilenetworks.gui.accuracy", (Object[])new Object[0]);
            float f3 = xOff;
            Objects.requireNonNull(this.f_96547_);
            this.f_96547_.m_92883_(stack, msg, f3, (float)(9 + (9 + 3) * 2), 0xFFFFFF);
            xOff += this.f_96547_.m_92895_(msg);
            DecimalFormat fmt = new DecimalFormat("##.##%");
            msg = fmt.format(cModel.getAccuracy());
            float f4 = xOff;
            Objects.requireNonNull(this.f_96547_);
            this.f_96547_.m_92883_(stack, msg, f4, (float)(9 + (9 + 3) * 2), cModel.getTier().color.m_126665_().intValue());
        }
        int left = 29;
        int top = 51;
        Objects.requireNonNull(this.f_96547_);
        int spacing = 9 + 3;
        int idx = 0;
        for (TickableText t : this.body) {
            t.render(this.f_96547_, stack, left, top + spacing * idx);
            if (t.causesNewLine()) {
                ++idx;
                left = 29;
                continue;
            }
            left += t.getWidth(this.f_96547_);
        }
    }

    protected void m_7286_(PoseStack stack, float pPartialTicks, int pX, int pY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BASE);
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        GuiComponent.m_93133_((PoseStack)stack, (int)(left + 8), (int)top, (float)0.0f, (float)0.0f, (int)216, (int)141, (int)256, (int)256);
        GuiComponent.m_93133_((PoseStack)stack, (int)(left - 14), (int)top, (float)0.0f, (float)141.0f, (int)18, (int)18, (int)256, (int)256);
        int energyHeight = 87 - Mth.m_14167_((float)(87.0f * (float)((SimChamberContainer)this.f_97732_).getEnergyStored() / (float)HostileConfig.simPowerCap));
        GuiComponent.m_93133_((PoseStack)stack, (int)(left + 211), (int)(top + 48), (float)18.0f, (float)141.0f, (int)7, (int)energyHeight, (int)256, (int)256);
        int dataHeight = 87;
        CachedModel cModel = new CachedModel(((SimChamberContainer)this.f_97732_).m_38853_(0).m_7993_(), 0);
        if (cModel.getModel() != null) {
            ModelTier next;
            int data = cModel.getData();
            ModelTier tier = cModel.getTier();
            dataHeight = tier == (next = tier.next()) ? 0 : 87 - Mth.m_14167_((float)(87.0f * (float)(data - tier.data) / (float)(next.data - tier.data)));
        }
        GuiComponent.m_93133_((PoseStack)stack, (int)(left + 14), (int)(top + 48), (float)18.0f, (float)141.0f, (int)7, (int)dataHeight, (int)256, (int)256);
        RenderSystem.m_157456_((int)0, (ResourceLocation)PLAYER);
        GuiComponent.m_93133_((PoseStack)stack, (int)(left + 28), (int)(top + 145), (float)0.0f, (float)0.0f, (int)176, (int)90, (int)256, (int)256);
    }

    public void m_181908_() {
        if (((SimChamberContainer)this.f_97732_).getFailState() != SimChamberTileEntity.FailureState.NONE) {
            SimChamberTileEntity.FailureState oState = this.lastFailState;
            this.lastFailState = ((SimChamberContainer)this.f_97732_).getFailState();
            if (oState != this.lastFailState) {
                this.body.clear();
                String[] msg = I18n.m_118938_((String)this.lastFailState.getKey(), (Object[])new Object[0]).split("\\n");
                if (this.lastFailState == SimChamberTileEntity.FailureState.INPUT) {
                    CachedModel cModel = new CachedModel(((SimChamberContainer)this.f_97732_).m_38853_(0).m_7993_(), 0);
                    Component name = ERROR;
                    if (cModel.getModel() != null) {
                        name = cModel.getModel().getInput().m_41786_();
                    }
                    msg = I18n.m_118938_((String)this.lastFailState.getKey(), (Object[])new Object[]{name.getString()}).split("\\n");
                }
                for (String s : msg) {
                    this.body.add(new TickableText(s, 0xFFFFFF));
                }
            }
            this.runtimeTextLoaded = false;
        } else if (!this.runtimeTextLoaded) {
            int ticks = 300 - ((SimChamberContainer)this.f_97732_).getRuntime();
            float speed = 0.65f;
            this.body.clear();
            int iters = DataModelItem.getIters(((SimChamberContainer)this.f_97732_).m_38853_(0).m_7993_());
            for (int i = 0; i < 7; ++i) {
                TickableText txt = new TickableText(I18n.m_118938_((String)("hostilenetworks.run." + i), (Object[])new Object[]{iters}), 0xFFFFFF, i != 0 && i != 5, speed);
                this.body.add(txt.setTicks(ticks));
                ticks = Math.max(0, ticks - txt.getMaxUsefulTicks());
                if (i == 0) {
                    txt = new TickableText("v3.0.5", ChatFormatting.GOLD.m_126665_().intValue(), true, speed);
                    this.body.add(txt.setTicks(ticks));
                    ticks = Math.max(0, ticks - txt.getMaxUsefulTicks());
                    continue;
                }
                if (i != 5) continue;
                String key = "hostilenetworks.color_text." + (((SimChamberContainer)this.f_97732_).didPredictionSucceed() ? "success" : "failed");
                txt = new TickableText(I18n.m_118938_((String)key, (Object[])new Object[0]), (((SimChamberContainer)this.f_97732_).didPredictionSucceed() ? ChatFormatting.GOLD : ChatFormatting.RED).m_126665_().intValue(), true, speed);
                this.body.add(txt.setTicks(ticks));
                ticks = Math.max(0, ticks - txt.getMaxUsefulTicks());
            }
            this.runtimeTextLoaded = true;
            this.lastFailState = SimChamberTileEntity.FailureState.NONE;
        }
        TickableText.tickList(this.body);
        if (((SimChamberContainer)this.f_97732_).getRuntime() == 0) {
            this.runtimeTextLoaded = false;
        }
    }
}

