/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.item;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;
import shadows.hostilenetworks.client.DataModelItemStackRenderer;
import shadows.hostilenetworks.data.DataModel;
import shadows.hostilenetworks.data.DataModelManager;
import shadows.hostilenetworks.data.ModelTier;
import shadows.hostilenetworks.util.Color;

public class DataModelItem
extends Item {
    public static final String DATA_MODEL = "data_model";
    public static final String ID = "id";
    public static final String DATA = "data";
    public static final String ITERATIONS = "iterations";

    public DataModelItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> list, TooltipFlag pFlag) {
        if (Screen.m_96638_()) {
            DataModel model = DataModelItem.getStoredModel(pStack);
            if (model == null) {
                list.add((Component)new TranslatableComponent("Error: %s", new Object[]{new TextComponent("Broke_AF").m_130944_(new ChatFormatting[]{ChatFormatting.OBFUSCATED, ChatFormatting.GRAY})}));
                return;
            }
            int data = DataModelItem.getData(pStack);
            ModelTier tier = ModelTier.getByData(data);
            list.add((Component)new TranslatableComponent("hostilenetworks.info.tier", new Object[]{tier.getComponent()}));
            int dProg = data - tier.data;
            int dMax = tier.next().data - tier.data;
            if (tier != ModelTier.SELF_AWARE) {
                list.add((Component)new TranslatableComponent("hostilenetworks.info.data", new Object[]{new TranslatableComponent("hostilenetworks.info.dprog", new Object[]{dProg, dMax}).m_130940_(ChatFormatting.GRAY)}));
                list.add((Component)new TranslatableComponent("hostilenetworks.info.dpk", new Object[]{new TextComponent("" + tier.dataPerKill).m_130940_(ChatFormatting.GRAY)}));
            }
            list.add((Component)new TranslatableComponent("hostilenetworks.info.sim_cost", new Object[]{new TranslatableComponent("hostilenetworks.info.rft", new Object[]{model.getSimCost()}).m_130940_(ChatFormatting.GRAY)}));
        } else {
            list.add((Component)new TranslatableComponent("hostilenetworks.info.hold_shift", new Object[]{Color.withColor("hostilenetworks.color_text.shift", ChatFormatting.WHITE.m_126665_())}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public void m_6787_(CreativeModeTab pGroup, NonNullList<ItemStack> pItems) {
        if (this.m_41389_(pGroup)) {
            for (DataModel model : DataModelManager.INSTANCE.getValues()) {
                ItemStack s = new ItemStack((ItemLike)this);
                DataModelItem.setStoredModel(s, model);
                pItems.add((Object)s);
            }
        }
    }

    public Component m_7626_(ItemStack pStack) {
        DataModel model = DataModelItem.getStoredModel(pStack);
        Object modelName = model == null ? new TextComponent("BROKEN").m_130940_(ChatFormatting.OBFUSCATED) : model.getName();
        return new TranslatableComponent(this.m_5671_(pStack), new Object[]{modelName});
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){
            DataModelItemStackRenderer dmisr = new DataModelItemStackRenderer();

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return this.dmisr;
            }
        });
    }

    @Nullable
    public static DataModel getStoredModel(ItemStack stack) {
        if (!stack.m_41782_()) {
            return null;
        }
        String dmKey = stack.m_41698_(DATA_MODEL).m_128461_(ID);
        return (DataModel)DataModelManager.INSTANCE.getValue(new ResourceLocation(dmKey));
    }

    public static void setStoredModel(ItemStack stack, DataModel model) {
        stack.m_41749_(DATA_MODEL);
        stack.m_41698_(DATA_MODEL).m_128359_(ID, model.getId().toString());
    }

    public static int getData(ItemStack stack) {
        return stack.m_41698_(DATA_MODEL).m_128451_(DATA);
    }

    public static void setData(ItemStack stack, int data) {
        stack.m_41698_(DATA_MODEL).m_128405_(DATA, data);
    }

    public static int getIters(ItemStack stack) {
        return stack.m_41698_(DATA_MODEL).m_128451_(ITERATIONS);
    }

    public static void setIters(ItemStack stack, int data) {
        stack.m_41698_(DATA_MODEL).m_128405_(ITERATIONS, data);
    }

    public static boolean matchesInput(ItemStack model, ItemStack stack) {
        boolean item;
        DataModel dModel = DataModelItem.getStoredModel(model);
        if (dModel == null) {
            return false;
        }
        ItemStack input = dModel.getInput();
        boolean bl = item = input.m_41720_() == stack.m_41720_();
        if (input.m_41782_()) {
            if (stack.m_41782_()) {
                CompoundTag t1 = input.m_41783_();
                CompoundTag t2 = stack.m_41783_();
                for (String s : t1.m_128431_()) {
                    if (t1.m_128423_(s).equals(t2.m_128423_(s))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return item;
    }
}

