/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import shadows.hostilenetworks.Hostile;
import shadows.hostilenetworks.data.ModelTier;
import shadows.hostilenetworks.jei.TickingDataModelWrapper;

public class SimChamberCategory
implements IRecipeCategory<TickingDataModelWrapper> {
    public static final ResourceLocation UID = new ResourceLocation("hostilenetworks", "sim_chamber");
    private final IDrawable background;
    private final IDrawable icon;
    private final Component name;
    private int ticks = 0;
    private long lastTickTime = 0L;
    static List<TickingDataModelWrapper> recipes;
    private ModelTier currentTier = ModelTier.BASIC;

    public SimChamberCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("hostilenetworks", "textures/jei/sim_chamber.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 116, 43);
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)Hostile.Blocks.SIM_CHAMBER));
        this.name = new TranslatableComponent(Hostile.Blocks.SIM_CHAMBER.m_7705_());
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Class<TickingDataModelWrapper> getRecipeClass() {
        return TickingDataModelWrapper.class;
    }

    public Component getTitle() {
        return this.name;
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public void setIngredients(TickingDataModelWrapper recipe, IIngredients ing) {
        ing.setInputs(VanillaTypes.ITEM, Arrays.asList(recipe.model, recipe.input));
        ing.setOutputs(VanillaTypes.ITEM, Arrays.asList(recipe.baseDrop, recipe.prediction));
    }

    public void setRecipe(IRecipeLayout layout, TickingDataModelWrapper recipe, IIngredients ing) {
        IGuiItemStackGroup stacks = layout.getItemStacks();
        stacks.init(0, true, 3, 3);
        stacks.init(1, true, 27, 3);
        stacks.init(2, false, 95, 3);
        stacks.init(3, false, 65, 25);
        stacks.set(ing);
    }

    public void draw(TickingDataModelWrapper recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        long time = mc.f_91073_.m_46467_();
        int width = Mth.m_14167_((float)(35.0f * ((float)(this.ticks % 40) + mc.m_91297_()) / 40.0f));
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)52, (int)9, (float)0.0f, (float)43.0f, (int)width, (int)6, (int)256, (int)256);
        if (time != this.lastTickTime) {
            if (++this.ticks % 30 == 0) {
                ModelTier next = this.currentTier.next();
                if (next == this.currentTier) {
                    next = ModelTier.BASIC;
                }
                for (TickingDataModelWrapper t : recipes) {
                    t.setTier(next);
                }
                this.currentTier = next;
            }
            this.lastTickTime = time;
        }
        Component comp = recipe.currentTier.getComponent();
        width = font.m_92852_((FormattedText)comp);
        font.m_92889_(matrixStack, recipe.currentTier.getComponent(), (float)(33 - width / 2), 30.0f, recipe.currentTier.color.m_126665_().intValue());
        DecimalFormat fmt = new DecimalFormat("##.##%");
        String msg = fmt.format(recipe.currentTier.accuracy);
        width = font.m_92895_(msg);
        font.m_92750_(matrixStack, msg, (float)(114 - width), 30.0f, 0xFFFFFF);
    }
}

