/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.tile;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import shadows.hostilenetworks.Hostile;
import shadows.hostilenetworks.HostileConfig;
import shadows.hostilenetworks.data.DataModel;
import shadows.hostilenetworks.data.DataModelManager;
import shadows.hostilenetworks.item.MobPredictionItem;
import shadows.placebo.block_entity.TickingBlockEntity;
import shadows.placebo.cap.InternalItemHandler;
import shadows.placebo.cap.ModifiableEnergyStorage;
import shadows.placebo.container.EasyContainerData;
import shadows.placebo.recipe.VanillaPacketDispatcher;

public class LootFabTileEntity
extends BlockEntity
implements TickingBlockEntity,
EasyContainerData.IDataAutoRegister {
    protected final FabItemHandler inventory = new FabItemHandler();
    protected final ModifiableEnergyStorage energy = new ModifiableEnergyStorage(HostileConfig.fabPowerCap, HostileConfig.fabPowerCap);
    protected final Object2IntMap<DataModel> savedSelections = new Object2IntOpenHashMap();
    protected final EasyContainerData data = new EasyContainerData();
    protected int runtime = 0;
    protected int currentSel = -1;

    public LootFabTileEntity(BlockPos pos, BlockState state) {
        super(Hostile.TileEntities.LOOT_FABRICATOR, pos, state);
        this.savedSelections.defaultReturnValue(-1);
        this.data.addData(() -> this.runtime, v -> {
            this.runtime = v;
        });
        this.data.addEnergy(this.energy);
    }

    public void registerSlots(Consumer<DataSlot> consumer) {
        this.data.register(consumer);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        DataModel dm = MobPredictionItem.getStoredModel(this.inventory.getStackInSlot(0));
        if (dm != null) {
            int selection = this.savedSelections.getInt((Object)dm);
            if (this.currentSel != selection) {
                this.currentSel = selection;
                this.runtime = 0;
                return;
            }
            if (selection != -1) {
                if (this.runtime == 0) {
                    ItemStack out = dm.getFabDrops().get(selection).m_41777_();
                    if (this.insertInOutput(out, true)) {
                        this.runtime = 60;
                    }
                } else {
                    if (this.energy.getEnergyStored() < HostileConfig.fabPowerCost) {
                        return;
                    }
                    this.energy.setEnergy(this.energy.getEnergyStored() - HostileConfig.fabPowerCost);
                    if (--this.runtime == 0) {
                        this.insertInOutput(dm.getFabDrops().get(selection).m_41777_(), false);
                        this.inventory.getStackInSlot(0).m_41774_(1);
                    }
                }
            } else {
                this.runtime = 0;
            }
        } else {
            this.runtime = 0;
        }
    }

    protected boolean insertInOutput(ItemStack stack, boolean sim) {
        for (int i = 1; i < 17; ++i) {
            if (!(stack = this.inventory.insertItemInternal(i, stack, sim)).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public FabItemHandler getInventory() {
        return this.inventory;
    }

    public void setSelection(DataModel model, int pId) {
        if (pId == -1) {
            this.savedSelections.removeInt((Object)model);
        } else {
            this.savedSelections.put((Object)model, Mth.m_14045_((int)pId, (int)0, (int)(model.getFabDrops().size() - 1)));
        }
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.inventory).cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this.energy).cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("saved_selections", (Tag)this.writeSelections(new CompoundTag()));
        tag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128405_("energy", this.energy.getEnergyStored());
        tag.m_128405_("runtime", this.runtime);
        tag.m_128405_("selection", this.currentSel);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.readSelections(tag.m_128469_("saved_selections"));
        this.inventory.deserializeNBT(tag.m_128469_("inventory"));
        this.energy.setEnergy(tag.m_128451_("energy"));
        this.runtime = tag.m_128451_("runtime");
        this.currentSel = tag.m_128451_("selection");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, t -> ((LootFabTileEntity)((Object)t)).writeSync());
    }

    private CompoundTag writeSync() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("saved_selections", (Tag)this.writeSelections(new CompoundTag()));
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.readSelections(pkt.m_131708_().m_128469_("saved_selections"));
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128365_("saved_selections", (Tag)this.writeSelections(new CompoundTag()));
        return tag;
    }

    private CompoundTag writeSelections(CompoundTag tag) {
        for (Object2IntMap.Entry e : this.savedSelections.object2IntEntrySet()) {
            tag.m_128405_(((DataModel)((Object)e.getKey())).getId().toString(), e.getIntValue());
        }
        return tag;
    }

    private void readSelections(CompoundTag tag) {
        this.savedSelections.clear();
        for (String s : tag.m_128431_()) {
            DataModel dm = (DataModel)DataModelManager.INSTANCE.getValue(new ResourceLocation(s));
            this.savedSelections.put((Object)dm, Mth.m_14045_((int)tag.m_128451_(s), (int)0, (int)(dm.getFabDrops().size() - 1)));
        }
    }

    public int getEnergyStored() {
        return this.energy.getEnergyStored();
    }

    public int getRuntime() {
        return this.runtime;
    }

    public int getSelectedDrop(DataModel model) {
        return model == null ? -1 : this.savedSelections.getInt((Object)model);
    }

    public class FabItemHandler
    extends InternalItemHandler {
        public FabItemHandler() {
            super(17);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return stack.m_41720_() == Hostile.Items.PREDICTION;
            }
            return true;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot > 0) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 0) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }
    }
}

