/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;

public class Dungeon
extends StructureFeature<NoneFeatureConfiguration> {
    public static Set<Biome.BiomeCategory> biomeCategories = ImmutableSet.builder().add((Object)Biome.BiomeCategory.DESERT).add((Object)Biome.BiomeCategory.EXTREME_HILLS).add((Object)Biome.BiomeCategory.FOREST).add((Object)Biome.BiomeCategory.ICY).add((Object)Biome.BiomeCategory.JUNGLE).add((Object)Biome.BiomeCategory.MESA).add((Object)Biome.BiomeCategory.PLAINS).add((Object)Biome.BiomeCategory.SAVANNA).add((Object)Biome.BiomeCategory.SWAMP).add((Object)Biome.BiomeCategory.TAIGA).build();
    public static ImmutableSet<String> whitelistedDimensions = ImmutableSet.of((Object)"minecraft:overworld");
    public static ImmutableSet<String> whitelistedBiomes = ImmutableSet.of();
    public static ImmutableSet<String> blacklistedBiomes = ImmutableSet.of();
    public static final String NAME = "dungeoncrawl:dungeon";

    public Dungeon() {
        super(NoneFeatureConfiguration.f_67815_, Dungeon::pieceGeneratorSupplier);
    }

    private static Optional<PieceGenerator<NoneFeatureConfiguration>> pieceGeneratorSupplier(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context) {
        int centerX = context.f_197355_().m_151382_(7);
        int centerZ = context.f_197355_().m_151391_(7);
        int centerHeight = context.f_197352_().m_156179_(centerX, centerZ, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        if (!context.f_197358_().test(context.f_197352_().m_7158_(QuartPos.m_175400_((int)centerX), QuartPos.m_175400_((int)centerHeight), QuartPos.m_175400_((int)centerZ)))) {
            DungeonCrawl.LOGGER.debug("Found invalid biome {}", (Object)context.f_197352_().m_7158_(QuartPos.m_175400_((int)centerX), QuartPos.m_175400_((int)centerHeight), QuartPos.m_175400_((int)centerZ)).getRegistryName());
            return Optional.empty();
        }
        int minGroundHeight = Dungeon.minHeight(context, centerX, centerZ, centerHeight);
        if (minGroundHeight < 45) {
            return Optional.empty();
        }
        int startHeight = (Boolean)Config.FIXED_GENERATION_HEIGHT.get() != false ? context.f_197352_().m_142051_(context.f_197357_()) - 20 : (minGroundHeight > 80 ? 80 + (minGroundHeight - 80) / 3 : minGroundHeight) - 20;
        return Optional.of((structurePiecesBuilder, generatorContext) -> {
            DungeonBuilder builder = new DungeonBuilder(context.f_197360_(), generatorContext.f_192703_(), startHeight, new BlockPos(centerX, centerHeight, centerZ), generatorContext.f_192705_(), (Random)generatorContext.f_192708_());
            builder.build().forEach(arg_0 -> ((StructurePiecesBuilder)structurePiecesBuilder).m_142679_(arg_0));
        });
    }

    private static int minHeight(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, int centerX, int centerZ, int centerHeight) {
        int minHeight = centerHeight;
        for (int i = 1; i < 9; ++i) {
            int size = i * 5;
            int[] heights = context.m_197375_(centerX - size, size * 2, centerZ - size, size * 2);
            int lowestHeight = Math.min(Math.min(heights[0], heights[1]), Math.min(heights[2], heights[3]));
            minHeight = Math.min(minHeight, lowestHeight);
        }
        return minHeight;
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }

    protected boolean m_5910_() {
        return false;
    }

    public String m_67098_() {
        return NAME;
    }
}

