/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.PlacementConfiguration;
import xiroc.dungeoncrawl.dungeon.StructurePieceTypes;
import xiroc.dungeoncrawl.dungeon.model.ModelSelector;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;

public class DungeonCorridor
extends DungeonPiece {
    public DungeonCorridor() {
        super(StructurePieceTypes.CORRIDOR);
    }

    public DungeonCorridor(CompoundTag p_i51343_2_) {
        super(StructurePieceTypes.CORRIDOR, p_i51343_2_);
    }

    @Override
    public void setupModel(DungeonBuilder builder, ModelSelector modelSelector, List<DungeonPiece> pieces, Random rand) {
        this.model = this.connectedSides == 2 && this.isStraight() ? modelSelector.corridors.roll(rand) : modelSelector.corridorLinkers.roll(rand);
    }

    public void m_183269_(WorldGenLevel worldIn, StructureFeatureManager p_230383_2_, ChunkGenerator p_230383_3_, Random randomIn, BoundingBox structureBoundingBoxIn, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
        if (this.model == null) {
            DungeonCrawl.LOGGER.warn("Missing model for {}", (Object)this);
            return;
        }
        Vec3i offset = this.model.getOffset(this.f_73379_);
        BlockPos pos = new BlockPos(this.x, this.y, this.z).m_141952_(offset);
        this.buildModel(this.model, (LevelAccessor)worldIn, structureBoundingBoxIn, pos, PlacementConfiguration.CORRIDOR, this.theme, this.secondaryTheme, this.stage, this.f_73379_, this.worldGen, false, false);
        if (this.connectedSides != 2 || !this.isStraight()) {
            this.entrances((LevelAccessor)worldIn, structureBoundingBoxIn, this.model, this.worldGen);
        }
        this.placeFeatures((LevelAccessor)worldIn, structureBoundingBoxIn, this.theme, this.secondaryTheme, randomIn, this.stage, this.worldGen);
        this.decorate((LevelAccessor)worldIn, pos, this.model.width, this.model.height, this.model.length, this.theme, structureBoundingBoxIn, this.f_73383_, this.model, this.worldGen);
    }

    @Override
    protected boolean hasPillarAt(BlockPos pos) {
        if (this.f_73379_ == Rotation.NONE || this.f_73379_ == Rotation.CLOCKWISE_180) {
            return pos.m_123341_() % 6 == 0 && pos.m_123343_() % 3 == 0;
        }
        return pos.m_123341_() % 3 == 0 && pos.m_123343_() % 6 == 0;
    }

    @Override
    public void createBoundingBox() {
        if (this.model != null) {
            this.f_73383_ = this.model.createBoundingBoxWithOffset(this.x, this.y, this.z, this.f_73379_);
        }
    }

    @Override
    public int getDungeonPieceType() {
        return 0;
    }

    public boolean isStraight() {
        return this.sides[0] && this.sides[2] || this.sides[1] && this.sides[3];
    }
}

