/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.crafting;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICustomCraftingCategoryExtension;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.api.item.IAncientWillContainer;
import vazkii.botania.common.crafting.recipe.AncientWillRecipe;
import vazkii.botania.common.item.ItemAncientWill;
import vazkii.botania.common.item.ModItems;

public class AncientWillRecipeWrapper
implements ICustomCraftingCategoryExtension {
    private final ResourceLocation name;

    public AncientWillRecipeWrapper(AncientWillRecipe recipe) {
        this.name = recipe.m_6423_();
    }

    public void setIngredients(@Nonnull IIngredients ingredients) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList.Builder helmets = ImmutableList.builder();
        ImmutableList.Builder wills = ImmutableList.builder();
        helmets.add((Object)new ItemStack((ItemLike)ModItems.terrasteelHelm));
        wills.add((Object)new ItemStack((ItemLike)ModItems.ancientWillAhrim));
        wills.add((Object)new ItemStack((ItemLike)ModItems.ancientWillDharok));
        wills.add((Object)new ItemStack((ItemLike)ModItems.ancientWillGuthan));
        wills.add((Object)new ItemStack((ItemLike)ModItems.ancientWillTorag));
        wills.add((Object)new ItemStack((ItemLike)ModItems.ancientWillVerac));
        wills.add((Object)new ItemStack((ItemLike)ModItems.ancientWillKaril));
        builder.add((Object)helmets.build());
        builder.add((Object)wills.build());
        ingredients.setInputLists(VanillaTypes.ITEM, (List)builder.build());
        ingredients.setOutputLists(VanillaTypes.ITEM, (List)ImmutableList.of((Object)helmets.build()));
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IIngredients ingredients) {
        IFocus focus = recipeLayout.getFocus(VanillaTypes.ITEM);
        IGuiItemStackGroup group = recipeLayout.getItemStacks();
        group.set(ingredients);
        if (focus != null) {
            ItemStack focused = (ItemStack)focus.getValue();
            if (focus.getMode() == IFocus.Mode.INPUT && focused.m_41720_() instanceof ItemAncientWill) {
                ItemStack copy = focused.m_41777_();
                copy.m_41764_(1);
                group.set(2, copy);
                group.set(0, this.getHelmetsWithWill(((ItemAncientWill)focused.m_41720_()).type, ingredients));
            } else if (focused.m_41720_() instanceof IAncientWillContainer) {
                group.set(1, new ItemStack((ItemLike)focused.m_41720_()));
                group.set(0, this.getWillsOnHelmet(focused.m_41720_()));
            }
        }
    }

    private List<ItemStack> getHelmetsWithWill(IAncientWillContainer.AncientWillType type, IIngredients ingredients) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ItemStack itemStack : (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0)) {
            ItemStack toAdd = itemStack.m_41777_();
            ((IAncientWillContainer)toAdd.m_41720_()).addAncientWill(toAdd, type);
            builder.add((Object)toAdd);
        }
        return builder.build();
    }

    private List<ItemStack> getWillsOnHelmet(Item item) {
        if (item instanceof IAncientWillContainer) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (IAncientWillContainer.AncientWillType type : IAncientWillContainer.AncientWillType.values()) {
                ItemStack stack = new ItemStack((ItemLike)item);
                ((IAncientWillContainer)item).addAncientWill(stack, type);
                builder.add((Object)stack);
            }
            return builder.build();
        }
        return ImmutableList.of();
    }
}

