/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.saveddata.SavedData;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.item.lens.LensPiston;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.PacketBotaniaEffect;
import vazkii.botania.xplat.IXplatAbstractions;

public class BlockPistonRelay
extends BlockMod {
    public final Map<UUID, GlobalPos> activeBindingAttempts = new HashMap<UUID, GlobalPos>();

    public BlockPistonRelay(BlockBehaviour.Properties builder) {
        super(builder);
    }

    public PushReaction m_5537_(@Nonnull BlockState blockState) {
        return PushReaction.PUSH_ONLY;
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!world.f_46443_) {
            WorldData data = WorldData.get(world);
            if (isMoving && newState.m_60713_(Blocks.f_50110_)) {
                Direction moveDirection = (Direction)newState.m_61143_((Property)MovingPistonBlock.f_60046_);
                BlockPos destPos = data.mapping.get(pos);
                if (destPos != null) {
                    BlockPos newSrcPos = pos.m_142300_(moveDirection);
                    data.mapping.remove(pos);
                    data.mapping.put(newSrcPos, destPos);
                    data.m_77762_();
                    if (newState.m_61143_((Property)MovingPistonBlock.f_60047_) == PistonType.DEFAULT) {
                        LensPiston.moveBlocks(world, destPos.m_142300_(moveDirection.m_122424_()), moveDirection);
                        data.mapping.put(newSrcPos, data.mapping.get(newSrcPos).m_142300_(moveDirection));
                    }
                }
            } else if (data.mapping.remove(pos) != null) {
                data.m_77762_();
            }
        }
    }

    public boolean onUsedByWand(Player player, ItemStack stack, Level world, BlockPos pos) {
        if (world.f_46443_) {
            return false;
        }
        if (player == null || player.m_6144_()) {
            world.m_46961_(pos, true);
        } else {
            GlobalPos clicked = GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)pos.m_7949_());
            if (ItemTwigWand.getBindMode(stack)) {
                this.activeBindingAttempts.put(player.m_142081_(), clicked);
                world.m_5594_(null, pos, ModSounds.ding, SoundSource.BLOCKS, 0.5f, 1.0f);
            } else {
                BlockPos dest;
                WorldData data = WorldData.get(world);
                if (IXplatAbstractions.INSTANCE.isDevEnvironment()) {
                    BotaniaAPI.LOGGER.info("PistonRelay pairs");
                    for (Map.Entry<BlockPos, BlockPos> e : data.mapping.entrySet()) {
                        BotaniaAPI.LOGGER.info("{} -> {}", (Object)e.getKey(), (Object)e.getValue());
                    }
                }
                if ((dest = data.mapping.get(pos)) != null) {
                    IXplatAbstractions.INSTANCE.sendToNear(world, pos, new PacketBotaniaEffect(EffectType.PARTICLE_BEAM, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, dest.m_123341_(), dest.m_123342_(), dest.m_123343_()));
                }
            }
        }
        return true;
    }

    public static class WorldData
    extends SavedData {
        private static final String ID = "PistonRelayPairs";
        public final Map<BlockPos, BlockPos> mapping = new HashMap<BlockPos, BlockPos>();
        public final Map<BlockPos, Integer> scheduled = new HashMap<BlockPos, Integer>();

        public WorldData(@Nonnull CompoundTag cmp) {
            ListTag list = cmp.m_128437_("list", 11);
            for (int i = 0; i < list.size(); i += 2) {
                Tag from = list.get(i);
                Tag to = list.get(i + 1);
                BlockPos fromPos = (BlockPos)((Pair)BlockPos.f_121852_.decode((DynamicOps)NbtOps.f_128958_, (Object)from).result().get()).getFirst();
                BlockPos toPos = (BlockPos)((Pair)BlockPos.f_121852_.decode((DynamicOps)NbtOps.f_128958_, (Object)to).result().get()).getFirst();
                this.mapping.put(fromPos, toPos);
            }
        }

        @Nonnull
        public CompoundTag m_7176_(@Nonnull CompoundTag cmp) {
            ListTag list = new ListTag();
            for (Map.Entry<BlockPos, BlockPos> e : this.mapping.entrySet()) {
                Tag from = (Tag)BlockPos.f_121852_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)e.getKey()).result().get();
                Tag to = (Tag)BlockPos.f_121852_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)e.getValue()).result().get();
                list.add((Object)from);
                list.add((Object)to);
            }
            cmp.m_128365_("list", (Tag)list);
            return cmp;
        }

        public static WorldData get(Level world) {
            WorldData data = (WorldData)((ServerLevel)world).m_8895_().m_164858_(WorldData::new, ID);
            if (data == null) {
                data = new WorldData(new CompoundTag());
                data.m_77762_();
                ((ServerLevel)world).m_8895_().m_164855_(ID, (SavedData)data);
            }
            return data;
        }
    }
}

