/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.api.mana.IManaCollisionGhost;
import vazkii.botania.api.mana.IManaTrigger;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.block.tile.mana.TilePrism;
import vazkii.botania.common.entity.EntityManaBurst;

public class BlockPrism
extends BlockModWaterloggable
implements EntityBlock,
IManaTrigger,
IManaCollisionGhost {
    private static final VoxelShape SHAPE = BlockPrism.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public BlockPrism(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BotaniaStateProps.HAS_LENS, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @Nonnull
    public VoxelShape m_5939_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        EntityCollisionContext econtext;
        if (context instanceof EntityCollisionContext && (econtext = (EntityCollisionContext)context).m_193113_() instanceof EntityManaBurst) {
            return SHAPE;
        }
        return super.m_5939_(state, world, pos, context);
    }

    public void m_7100_(BlockState state, Level world, BlockPos pos, Random rand) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) {
            BlockPrism.redstoneParticlesInShape(state, world, pos, rand);
        }
    }

    public static void redstoneParticlesInShape(BlockState state, Level world, BlockPos pos, Random rand) {
        if (rand.nextBoolean()) {
            AABB localBox = state.m_60808_((BlockGetter)world, pos).m_83215_();
            double x = (double)pos.m_123341_() + localBox.f_82288_ + rand.nextDouble() * (localBox.f_82291_ - localBox.f_82288_);
            double y = (double)pos.m_123342_() + localBox.f_82289_ + rand.nextDouble() * (localBox.f_82292_ - localBox.f_82289_);
            double z = (double)pos.m_123343_() + localBox.f_82290_ + rand.nextDouble() * (localBox.f_82293_ - localBox.f_82290_);
            world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61448_, BotaniaStateProps.HAS_LENS});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean isHeldItemLens;
        BlockEntity tile = world.m_7702_(pos);
        if (!(tile instanceof TilePrism)) {
            return InteractionResult.PASS;
        }
        TilePrism prism = (TilePrism)tile;
        ItemStack lens = prism.getItemHandler().m_8020_(0);
        ItemStack heldItem = player.m_21120_(hand);
        boolean bl = isHeldItemLens = !heldItem.m_41619_() && heldItem.m_41720_() instanceof ILens;
        if (lens.m_41619_() && isHeldItemLens) {
            ItemStack toInsert;
            if (!player.m_150110_().f_35937_) {
                toInsert = heldItem.m_41620_(1);
            } else {
                toInsert = heldItem.m_41777_();
                toInsert.m_41764_(1);
            }
            prism.getItemHandler().m_6836_(0, toInsert);
        } else if (!lens.m_41619_()) {
            player.m_150109_().m_150079_(lens);
            prism.getItemHandler().m_6836_(0, ItemStack.f_41583_);
        } else {
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos;
        Level world = context.m_43725_();
        boolean power = world.m_46755_(pos = context.m_8083_()) > 0 || world.m_46755_(pos.m_7494_()) > 0;
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(power));
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean power = world.m_46755_(pos) > 0 || world.m_46755_(pos.m_7494_()) > 0;
        boolean powered = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_);
        if (!world.f_46443_) {
            if (power && !powered) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)));
            } else if (!power && powered) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity be = world.m_7702_(pos);
            if (be instanceof TileSimpleInventory) {
                TileSimpleInventory inventory = (TileSimpleInventory)be;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)inventory.getItemHandler());
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    @Nonnull
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TilePrism(pos, state);
    }

    @Override
    public void onBurstCollision(IManaBurst burst, Level world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TilePrism) {
            TilePrism prism = (TilePrism)tile;
            prism.onBurstCollision(burst);
        }
    }

    @Override
    public boolean isGhost(BlockState state, Level world, BlockPos pos) {
        return true;
    }
}

