/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.ModSubtiles;

public class SubTileBergamute
extends TileEntitySpecialFlower {
    private static final int RANGE = 4;
    private static final Set<SubTileBergamute> clientFlowers = Collections.newSetFromMap(new WeakHashMap());
    private static final Set<SubTileBergamute> serverFlowers = Collections.newSetFromMap(new WeakHashMap());
    private boolean disabled = false;

    public SubTileBergamute(BlockPos pos, BlockState state) {
        super(ModSubtiles.BERGAMUTE, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        this.disabled = this.m_58904_().m_46753_(this.m_58899_());
        if (this.m_58904_().f_46443_) {
            clientFlowers.add(this);
        } else {
            serverFlowers.add(this);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.m_58904_().f_46443_) {
            clientFlowers.remove(this);
        } else {
            serverFlowers.remove(this);
        }
    }

    public static Pair<Integer, SubTileBergamute> getBergamutesNearby(Level level, double x, double y, double z, int maxCount) {
        int count = 0;
        SubTileBergamute tile = null;
        for (SubTileBergamute f : level.f_46443_ ? clientFlowers : serverFlowers) {
            if (f.disabled || level != f.f_58857_ || !(f.getEffectivePos().m_123299_(x, y, z, true) <= 16.0)) continue;
            if (++count == 1) {
                tile = f;
            }
            if (count < maxCount) continue;
            break;
        }
        return Pair.of((Object)count, tile);
    }

    public static boolean isBergamuteNearby(Level level, double x, double y, double z) {
        return (Integer)SubTileBergamute.getBergamutesNearby(level, x, y, z, 1).getFirst() > 0;
    }

    public static void particle(SubTileBergamute berg) {
        int color = 50943;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 5);
        berg.emitParticle(data, 0.3 + Math.random() * 0.5, 0.5 + Math.random() * 0.5, 0.3 + Math.random() * 0.5, 0.0, 0.0, 0.0);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.getEffectivePos(), 4.0);
    }
}

