/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.block.IWandable;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.block.subtile.functional.SubTileSpectranthemum;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.xplat.IXplatAbstractions;

public class SubTileHopperhock
extends TileEntityFunctionalFlower
implements IWandable {
    private static final String TAG_FILTER_TYPE = "filterType";
    private static final int RANGE_MANA = 10;
    private static final int RANGE = 6;
    private static final int RANGE_MANA_MINI = 2;
    private static final int RANGE_MINI = 1;
    private int filterType = 0;

    protected SubTileHopperhock(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public SubTileHopperhock(BlockPos pos, BlockState state) {
        this(ModSubtiles.HOPPERHOCK, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().f_46443_ || this.redstoneSignal > 0) {
            return;
        }
        boolean pulledAny = false;
        int range = this.getRange();
        BlockPos pos = this.getEffectivePos();
        List items = this.m_58904_().m_45976_(ItemEntity.class, new AABB(pos.m_142082_(-range, -range, -range), pos.m_142082_(range + 1, range + 1, range + 1)));
        for (ItemEntity item : items) {
            if (!DelayHelper.canInteractWith(this, item) || IXplatAbstractions.INSTANCE.itemFlagsComponent(item).getManaInfusionCooldown() > 20) continue;
            ItemStack stack = item.m_32055_();
            boolean priorityInv = false;
            int amountToPutIn = 0;
            Direction direction = null;
            for (Direction dir : Direction.values()) {
                boolean priority;
                Direction sideOfInventory;
                BlockPos inventoryPos = pos.m_142300_(dir);
                if (!IXplatAbstractions.INSTANCE.hasInventory(this.f_58857_, inventoryPos, sideOfInventory = dir.m_122424_())) continue;
                List<ItemStack> filter = SubTileHopperhock.getFilterForInventory(this.m_58904_(), inventoryPos, true);
                boolean canAccept = SubTileHopperhock.canAcceptItem(stack, filter, this.filterType);
                ItemStack simulate = IXplatAbstractions.INSTANCE.insertToInventory(this.f_58857_, inventoryPos, sideOfInventory, stack, true);
                int inserted = stack.m_41613_() - simulate.m_41613_();
                boolean bl = canAccept = canAccept && inserted > 0;
                if (!canAccept) continue;
                boolean bl2 = priority = !filter.isEmpty();
                if (priorityInv && !priority) continue;
                priorityInv = priority;
                amountToPutIn = inserted;
                direction = dir;
            }
            if (direction == null || !item.m_6084_()) continue;
            SubTileSpectranthemum.spawnExplosionParticles((Entity)item, 3);
            InventoryHelper.checkEmpty(IXplatAbstractions.INSTANCE.insertToInventory(this.f_58857_, pos.m_142300_(direction), direction.m_122424_(), stack.m_41620_(amountToPutIn), false));
            item.m_32045_(stack);
            pulledAny = true;
        }
        if (pulledAny && this.getMana() > 0) {
            this.addMana(-1);
        }
    }

    public static boolean canAcceptItem(ItemStack stack, List<ItemStack> filter, int filterType) {
        if (stack.m_41619_()) {
            return false;
        }
        if (filter.isEmpty()) {
            return true;
        }
        switch (filterType) {
            case 0: {
                boolean anyFilter = false;
                for (ItemStack filterEntry : filter) {
                    if (filterEntry == null || filterEntry.m_41619_()) continue;
                    anyFilter = true;
                    if (!SubTileHopperhock.matches(stack, filterEntry)) continue;
                    return true;
                }
                return !anyFilter;
            }
            case 1: {
                return !SubTileHopperhock.canAcceptItem(stack, filter, 0);
            }
        }
        return true;
    }

    public static boolean matches(ItemStack stack, ItemStack filter) {
        Item item = stack.m_41720_();
        if (item != filter.m_41720_()) {
            return false;
        }
        if (item instanceof IManaItem) {
            IManaItem manaItem = (IManaItem)item;
            return SubTileHopperhock.getFullness(manaItem, stack) == SubTileHopperhock.getFullness(manaItem, filter);
        }
        return ItemStack.m_41658_((ItemStack)filter, (ItemStack)stack);
    }

    public static int getFullness(IManaItem item, ItemStack stack) {
        int fuzz;
        int mana = item.getMana(stack);
        return mana <= (fuzz = 10) ? 0 : (mana + fuzz < item.getMaxMana(stack) ? 1 : 2);
    }

    public static List<ItemStack> getFilterForInventory(Level level, BlockPos pos, boolean recursiveForDoubleChests) {
        BlockPos other;
        ChestType type;
        BlockState chest;
        ArrayList<ItemStack> filter = new ArrayList<ItemStack>();
        if (recursiveForDoubleChests && (chest = level.m_8055_(pos)).m_61138_((Property)ChestBlock.f_51479_) && (type = (ChestType)chest.m_61143_((Property)ChestBlock.f_51479_)) != ChestType.SINGLE && level.m_8055_(other = pos.m_142300_(ChestBlock.m_51584_((BlockState)chest))).m_60713_(chest.m_60734_())) {
            filter.addAll(SubTileHopperhock.getFilterForInventory(level, other, false));
        }
        for (Direction dir : Direction.values()) {
            AABB aabb = new AABB(pos.m_142300_(dir));
            List frames = level.m_45976_(ItemFrame.class, aabb);
            for (ItemFrame frame : frames) {
                if (frame.m_6350_() != dir) continue;
                filter.add(frame.m_31822_());
            }
        }
        return filter;
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack wand, Direction side) {
        if (player == null || player.m_6144_()) {
            this.filterType = this.filterType == 2 ? 0 : this.filterType + 1;
            this.sync();
            return true;
        }
        return false;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), this.getRange());
    }

    public int getRange() {
        return this.getMana() > 0 ? 10 : 6;
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_FILTER_TYPE, this.filterType);
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.filterType = cmp.m_128451_(TAG_FILTER_TYPE);
    }

    @Override
    public int getMaxMana() {
        return 20;
    }

    @Override
    public int getColor() {
        return 0x3F3F3F;
    }

    public static class Mini
    extends SubTileHopperhock {
        public Mini(BlockPos pos, BlockState state) {
            super(ModSubtiles.HOPPERHOCK_CHIBI, pos, state);
        }

        @Override
        public int getRange() {
            return this.getMana() > 0 ? 2 : 1;
        }
    }

    public static class WandHud
    extends TileEntityFunctionalFlower.FunctionalWandHud<SubTileHopperhock> {
        public WandHud(SubTileHopperhock flower) {
            super(flower);
        }

        @Override
        public void renderHUD(PoseStack ms, Minecraft mc) {
            super.renderHUD(ms, mc);
            String filter = I18n.m_118938_((String)("botaniamisc.filter" + ((SubTileHopperhock)this.flower).filterType), (Object[])new Object[0]);
            int x = mc.m_91268_().m_85445_() / 2 - mc.f_91062_.m_92895_(filter) / 2;
            int y = mc.m_91268_().m_85446_() / 2 + 30;
            mc.f_91062_.m_92750_(ms, filter, (float)x, (float)y, ChatFormatting.GRAY.m_126665_().intValue());
        }
    }
}

