/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.StringUtil;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import vazkii.botania.api.block.IHourglassTrigger;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.api.block.IWandable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileExposedSimpleInventory;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.xplat.IXplatAbstractions;

public class TileHourglass
extends TileExposedSimpleInventory
implements IWandable {
    private static final String TAG_TIME = "time";
    private static final String TAG_TIME_FRACTION = "timeFraction";
    private static final String TAG_FLIP = "flip";
    private static final String TAG_FLIP_TICKS = "flipTicks";
    private static final String TAG_LOCK = "lock";
    private static final String TAG_MOVE = "move";
    private int time = 0;
    public float timeFraction = 0.0f;
    public float lastFraction = 0.0f;
    public boolean flip = false;
    public int flipTicks = 0;
    public boolean lock = false;
    public boolean move = true;

    public TileHourglass(BlockPos pos, BlockState state) {
        super(ModTiles.HOURGLASS, pos, state);
    }

    private boolean isDust() {
        ItemStack stack = this.getItemHandler().m_8020_(0);
        return !stack.m_41619_() && stack.m_150930_(ModItems.manaPowder);
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, TileHourglass self) {
        int totalTime = self.getTotalTime();
        boolean dust = self.isDust();
        if (totalTime > 0 || dust) {
            if (self.move && !dust) {
                ++self.time;
            }
            if (self.time >= totalTime) {
                self.time = 0;
                self.flip = !self.flip;
                self.flipTicks = 4;
                if (!level.f_46443_) {
                    level.m_7731_(worldPosition, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)), 1);
                    level.m_186460_(worldPosition, state.m_60734_(), 4);
                }
                for (Direction facing : Direction.values()) {
                    BlockPos pos = worldPosition.m_142300_(facing);
                    IHourglassTrigger trigger = IXplatAbstractions.INSTANCE.findHourglassTrigger(level, pos, level.m_8055_(pos), level.m_7702_(pos));
                    if (trigger == null) continue;
                    trigger.onTriggeredByHourglass(self);
                }
            }
            self.lastFraction = self.timeFraction;
            self.timeFraction = (float)self.time / (float)totalTime;
        } else {
            self.time = 0;
            self.lastFraction = 0.0f;
            self.timeFraction = 0.0f;
        }
        if (self.flipTicks > 0) {
            --self.flipTicks;
        }
    }

    public void onManaCollide() {
        if (!this.f_58857_.f_46443_) {
            if (this.isDust()) {
                ++this.time;
            } else {
                this.move = !this.move;
            }
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    public int getTotalTime() {
        ItemStack stack = this.getItemHandler().m_8020_(0);
        if (stack.m_41619_()) {
            return 0;
        }
        return TileHourglass.getStackItemTime(stack) * stack.m_41613_();
    }

    public static int getStackItemTime(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        if (stack.m_150930_(Blocks.f_49992_.m_5456_())) {
            return 20;
        }
        if (stack.m_150930_(Blocks.f_49993_.m_5456_())) {
            return 200;
        }
        if (stack.m_150930_(Blocks.f_50135_.m_5456_())) {
            return 1200;
        }
        if (stack.m_150930_(ModItems.manaPowder)) {
            return 1;
        }
        return 0;
    }

    public int getColor() {
        ItemStack stack = this.getItemHandler().m_8020_(0);
        if (stack.m_41619_()) {
            return 0;
        }
        if (stack.m_150930_(Blocks.f_49992_.m_5456_())) {
            return 16772169;
        }
        if (stack.m_150930_(Blocks.f_49993_.m_5456_())) {
            return 15292416;
        }
        if (stack.m_150930_(Blocks.f_50135_.m_5456_())) {
            return 5914927;
        }
        if (stack.m_150930_(ModItems.manaPowder)) {
            return 240639;
        }
        return 0;
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(1){

            public boolean m_7013_(int index, ItemStack stack) {
                return !stack.m_41619_() && (stack.m_150930_(Blocks.f_49992_.m_5456_()) || stack.m_150930_(Blocks.f_49993_.m_5456_()) || stack.m_150930_(Blocks.f_50135_.m_5456_()) || stack.m_150930_(ModItems.manaPowder));
            }
        };
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.time = 0;
            this.timeFraction = 0.0f;
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    @Override
    public void writePacketNBT(CompoundTag tag) {
        super.writePacketNBT(tag);
        tag.m_128405_(TAG_TIME, this.time);
        tag.m_128350_(TAG_TIME_FRACTION, this.timeFraction);
        tag.m_128379_(TAG_FLIP, this.flip);
        tag.m_128405_(TAG_FLIP_TICKS, this.flipTicks);
        tag.m_128379_(TAG_MOVE, this.move);
        tag.m_128379_(TAG_LOCK, this.lock);
    }

    @Override
    public void readPacketNBT(CompoundTag tag) {
        super.readPacketNBT(tag);
        this.time = tag.m_128451_(TAG_TIME);
        this.timeFraction = tag.m_128457_(TAG_TIME_FRACTION);
        this.flip = tag.m_128471_(TAG_FLIP);
        this.flipTicks = tag.m_128451_(TAG_FLIP_TICKS);
        this.move = tag.m_128471_(TAG_MOVE);
        this.lock = tag.m_128471_(TAG_LOCK);
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack stack, Direction side) {
        boolean bl = this.lock = !this.lock;
        if (!this.m_58904_().f_46443_) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
        return true;
    }

    public static class WandHud
    implements IWandHUD {
        private final TileHourglass hourglass;

        public WandHud(TileHourglass hourglass) {
            this.hourglass = hourglass;
        }

        @Override
        public void renderHUD(PoseStack ms, Minecraft mc) {
            int x = mc.m_91268_().m_85445_() / 2 + 10;
            int y = mc.m_91268_().m_85446_() / 2 - 10;
            ItemStack stack = this.hourglass.getItemHandler().m_8020_(0);
            if (!stack.m_41619_()) {
                mc.m_91291_().m_115123_(stack, x, y);
                mc.m_91291_().m_115169_(mc.f_91062_, stack, x, y);
                int time = this.hourglass.getTotalTime();
                String timeStr = StringUtil.m_14404_((int)time);
                mc.f_91062_.m_92750_(ms, timeStr, (float)(x + 20), (float)y, this.hourglass.getColor());
                String status = "";
                if (this.hourglass.lock) {
                    status = "locked";
                }
                if (!this.hourglass.move) {
                    String string = status = status.isEmpty() ? "stopped" : "lockedStopped";
                }
                if (!status.isEmpty()) {
                    mc.f_91062_.m_92750_(ms, I18n.m_118938_((String)("botaniamisc." + status), (Object[])new Object[0]), (float)(x + 20), (float)(y + 12), this.hourglass.getColor());
                }
            }
        }
    }
}

