/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.corporea;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.api.corporea.ICorporeaRequestor;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.corporea.TileCorporeaBase;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.xplat.IXplatAbstractions;

public class TileCorporeaFunnel
extends TileCorporeaBase
implements ICorporeaRequestor {
    public TileCorporeaFunnel(BlockPos pos, BlockState state) {
        super(ModTiles.CORPOREA_FUNNEL, pos, state);
    }

    public void doRequest() {
        ItemStack stack;
        List<ItemStack> filter;
        ICorporeaSpark spark = this.getSpark();
        if (spark != null && spark.getMaster() != null && !(filter = this.getFilter()).isEmpty() && !(stack = filter.get(this.f_58857_.f_46441_.nextInt(filter.size()))).m_41619_()) {
            this.doCorporeaRequest(CorporeaHelper.instance().createMatcher(stack, true), stack.m_41613_(), spark);
        }
    }

    public List<ItemStack> getFilter() {
        ArrayList<ItemStack> filter = new ArrayList<ItemStack>();
        int[] rotationToStackSize = new int[]{1, 2, 4, 8, 16, 32, 48, 64};
        for (Direction dir : Direction.values()) {
            List frames = this.f_58857_.m_45976_(ItemFrame.class, new AABB(this.f_58858_.m_142300_(dir), this.f_58858_.m_142300_(dir).m_142082_(1, 1, 1)));
            for (ItemFrame frame : frames) {
                ItemStack stack;
                Direction orientation = frame.m_6350_();
                if (orientation != dir || (stack = frame.m_31822_()).m_41619_()) continue;
                ItemStack copy = stack.m_41777_();
                copy.m_41764_(rotationToStackSize[frame.m_31823_()]);
                filter.add(copy);
            }
        }
        return filter;
    }

    @Override
    public void doCorporeaRequest(ICorporeaRequestMatcher request, int count, ICorporeaSpark spark) {
        BlockPos invPos = this.getInvPos();
        List<ItemStack> stacks = CorporeaHelper.instance().requestItem(request, count, spark, true).getStacks();
        spark.onItemsRequested(stacks);
        for (ItemStack reqStack : stacks) {
            if (invPos != null && IXplatAbstractions.INSTANCE.insertToInventory(this.f_58857_, invPos, Direction.UP, reqStack, true).m_41619_()) {
                InventoryHelper.checkEmpty(IXplatAbstractions.INSTANCE.insertToInventory(this.f_58857_, invPos, Direction.UP, reqStack, false));
                continue;
            }
            ItemEntity item = new ItemEntity(this.f_58857_, spark.entity().m_20185_(), spark.entity().m_20186_(), spark.entity().m_20189_(), reqStack);
            this.f_58857_.m_7967_((Entity)item);
        }
    }

    @Nullable
    private BlockPos getInvPos() {
        BlockPos downOne = this.f_58858_.m_7495_();
        if (IXplatAbstractions.INSTANCE.hasInventory(this.f_58857_, downOne, Direction.UP)) {
            return downOne;
        }
        BlockPos downTwo = this.f_58858_.m_6625_(2);
        if (IXplatAbstractions.INSTANCE.hasInventory(this.f_58857_, downTwo, Direction.UP)) {
            return downTwo;
        }
        return null;
    }
}

