/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.corporea;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.api.corporea.ICorporeaRequestor;
import vazkii.botania.api.corporea.ICorporeaResult;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.common.ModStats;
import vazkii.botania.common.advancements.CorporeaRequestTrigger;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.corporea.TileCorporeaBase;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.xplat.IXplatAbstractions;

public class TileCorporeaIndex
extends TileCorporeaBase
implements ICorporeaRequestor {
    public static final double RADIUS = 2.5;
    public static final int MAX_REQUEST = 65536;
    private static InputHandler input;
    private static final Set<TileCorporeaIndex> serverIndexes;
    private static final Set<TileCorporeaIndex> clientIndexes;
    private static final Map<Pattern, IRegexStacker> patterns;
    public int ticksWithCloseby = 0;
    public float closeby = 0.0f;
    public boolean hasCloseby;

    public TileCorporeaIndex(BlockPos pos, BlockState state) {
        super(ModTiles.CORPOREA_INDEX, pos, state);
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, TileCorporeaIndex self) {
        double x = (double)worldPosition.m_123341_() + 0.5;
        double y = (double)worldPosition.m_123342_() + 0.5;
        double z = (double)worldPosition.m_123343_() + 0.5;
        List players = level.m_45976_(Player.class, new AABB(x - 2.5, y - 2.5, z - 2.5, x + 2.5, y + 2.5, z + 2.5));
        self.hasCloseby = false;
        for (Player player : players) {
            if (!TileCorporeaIndex.isInRangeOfIndex(player, self)) continue;
            self.hasCloseby = true;
            break;
        }
        float step = 0.2f;
        if (self.hasCloseby) {
            ++self.ticksWithCloseby;
            if (self.closeby < 1.0f) {
                self.closeby += step;
            }
        } else if (self.closeby > 0.0f) {
            self.closeby -= step;
        }
        if (!self.m_58901_()) {
            TileCorporeaIndex.addIndex(self);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        TileCorporeaIndex.removeIndex(this);
    }

    @Override
    public void doCorporeaRequest(ICorporeaRequestMatcher request, int count, ICorporeaSpark spark) {
        this.doRequest(request, count, spark);
    }

    private ICorporeaResult doRequest(ICorporeaRequestMatcher matcher, int count, ICorporeaSpark spark) {
        ICorporeaResult result = CorporeaHelper.instance().requestItem(matcher, count, spark, true);
        List<ItemStack> stacks = result.getStacks();
        spark.onItemsRequested(stacks);
        for (ItemStack stack : stacks) {
            if (stack.m_41619_()) continue;
            ItemEntity item = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.5, (double)this.f_58858_.m_123343_() + 0.5, stack);
            this.f_58857_.m_7967_((Entity)item);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isInRangeOfIndex(Player player, TileCorporeaIndex index) {
        if (player.f_19853_.m_46472_() != index.f_58857_.m_46472_()) return false;
        if (!((double)MathHelper.pointDistancePlane((double)index.m_58899_().m_123341_() + 0.5, (double)index.m_58899_().m_123343_() + 0.5, player.m_20185_(), player.m_20189_()) < 2.5)) return false;
        double d = (double)index.m_58899_().m_123342_() + 0.5 - player.m_20186_();
        double d2 = player.f_19853_.f_46443_ ? 0.0 : 1.6;
        if (!(Math.abs(d + d2) < 5.0)) return false;
        return true;
    }

    public static void addPattern(String pattern, IRegexStacker stacker) {
        patterns.put(Pattern.compile(pattern), stacker);
    }

    public static int i(Matcher m, int g) {
        try {
            int i = Math.abs(Integer.parseInt(m.group(g)));
            return i;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static InputHandler getInputHandler() {
        if (input == null) {
            input = new InputHandler();
        }
        return input;
    }

    private static void addIndex(TileCorporeaIndex index) {
        Set<TileCorporeaIndex> set = index.f_58857_.f_46443_ ? clientIndexes : serverIndexes;
        set.add(index);
    }

    private static void removeIndex(TileCorporeaIndex index) {
        Set<TileCorporeaIndex> set = index.f_58857_.f_46443_ ? clientIndexes : serverIndexes;
        set.remove(index);
    }

    public static void clearIndexCache() {
        clientIndexes.clear();
        serverIndexes.clear();
    }

    public void performPlayerRequest(ServerPlayer player, ICorporeaRequestMatcher request, int count) {
        if (!IXplatAbstractions.INSTANCE.fireCorporeaIndexRequestEvent(player, request, count, this.getSpark())) {
            ICorporeaResult res = this.doRequest(request, count, this.getSpark());
            player.m_6352_((Component)new TranslatableComponent("botaniamisc.requestMsg", new Object[]{count, request.getRequestName(), res.getMatchedCount(), res.getExtractedCount()}).m_130940_(ChatFormatting.LIGHT_PURPLE), Util.f_137441_);
            player.m_36222_(ModStats.CORPOREA_ITEMS_REQUESTED, res.getExtractedCount());
            CorporeaRequestTrigger.INSTANCE.trigger(player, player.m_183503_(), this.m_58899_(), res.getExtractedCount());
        }
    }

    static {
        serverIndexes = Collections.newSetFromMap(new WeakHashMap());
        clientIndexes = Collections.newSetFromMap(new WeakHashMap());
        patterns = new LinkedHashMap<Pattern, IRegexStacker>();
        TileCorporeaIndex.addPattern("(.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 1;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("a??n?? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 1;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(\\d+)x?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return TileCorporeaIndex.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        TileCorporeaIndex.addPattern("(?:a )?stack(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 64;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(\\d+)x?? stacks?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 64 * TileCorporeaIndex.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        TileCorporeaIndex.addPattern("(?:a )?stack (?:(?:and)|(?:\\+)) (\\d+)(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 64 + TileCorporeaIndex.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        TileCorporeaIndex.addPattern("(\\d+)x?? stacks? (?:(?:and)|(?:\\+)) (\\d+)x?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 64 * TileCorporeaIndex.i(m, 1) + TileCorporeaIndex.i(m, 2);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(3);
            }
        });
        TileCorporeaIndex.addPattern("(?:a )?half (?:of )?(?:a )?stack(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 32;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(?:a )?quarter (?:of )?(?:a )?stack(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 16;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(?:a )?dozen(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 12;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(\\d+)x?? dozens?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 12 * TileCorporeaIndex.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        TileCorporeaIndex.addPattern("(?:all|every) (?:(?:of|the) )?(.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 65536;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(?:the )?answer to life,? the universe and everything (?:of )?(.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 42;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(?:a )?nice (?:of )?(.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 69;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(\\d+)x?? nices?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 69 * TileCorporeaIndex.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        TileCorporeaIndex.addPattern("(?:count|show|display|tell) (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 0;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
    }

    public static final class InputHandler {
        public boolean onChatMessage(ServerPlayer player, String message) {
            if (player.m_5833_()) {
                return false;
            }
            List<TileCorporeaIndex> nearbyIndexes = InputHandler.getNearbyIndexes((Player)player);
            if (!nearbyIndexes.isEmpty()) {
                String msg = message.toLowerCase(Locale.ROOT).trim();
                for (TileCorporeaIndex index : nearbyIndexes) {
                    ItemStack stack;
                    ICorporeaSpark spark = index.getSpark();
                    if (spark == null) continue;
                    String name = "";
                    int count = 0;
                    for (Pattern pattern : patterns.keySet()) {
                        Matcher matcher = pattern.matcher(msg);
                        if (!matcher.matches()) continue;
                        IRegexStacker stacker = patterns.get(pattern);
                        count = Math.min(65536, stacker.getCount(matcher));
                        name = stacker.getName(matcher).toLowerCase(Locale.ROOT).trim();
                    }
                    if (name.equals("this") && !(stack = player.m_21205_()).m_41619_()) {
                        name = stack.m_41786_().getString().toLowerCase(Locale.ROOT).trim();
                    }
                    index.performPlayerRequest(player, CorporeaHelper.instance().createMatcher(name), count);
                }
                return true;
            }
            return false;
        }

        public static List<TileCorporeaIndex> getNearbyIndexes(Player player) {
            return (player.f_19853_.f_46443_ ? clientIndexes : serverIndexes).stream().filter(i -> TileCorporeaIndex.isInRangeOfIndex(player, i)).collect(Collectors.toList());
        }
    }

    public static interface IRegexStacker {
        public int getCount(Matcher var1);

        public String getName(Matcher var1);
    }
}

