/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.RecipeOrechid;
import vazkii.botania.common.crafting.RecipeSerializerBase;

public class RecipeMarimorphosis
extends RecipeOrechid {
    private final int weightBonus;
    private final Set<Biome.BiomeCategory> biomes;

    public RecipeMarimorphosis(ResourceLocation id, Block input, StateIngredient output, int weight, int weightBonus, Collection<Biome.BiomeCategory> biomes) {
        super(id, input, output, weight);
        this.weightBonus = weightBonus;
        this.biomes = Set.copyOf(biomes);
    }

    @Override
    public int getWeight(@Nonnull Level level, @Nonnull BlockPos pos) {
        Biome biome = level.m_46857_(pos);
        if (this.biomes.contains(biome.m_47567_())) {
            return this.getWeight() + this.weightBonus;
        }
        return this.getWeight();
    }

    @Override
    public RecipeType<?> m_6671_() {
        return ModRecipeTypes.MARIMORPHOSIS_TYPE;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return ModRecipeTypes.MARIMORPHOSIS_SERIALIZER;
    }

    public static class Serializer
    extends RecipeSerializerBase<RecipeMarimorphosis> {
        public RecipeMarimorphosis fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            RecipeOrechid base = (RecipeOrechid)ModRecipeTypes.ORECHID_SERIALIZER.m_6729_(recipeId, json);
            HashSet<Biome.BiomeCategory> biomes = new HashSet<Biome.BiomeCategory>();
            JsonArray array = GsonHelper.m_13832_((JsonObject)json, (String)"biomes", (JsonArray)new JsonArray());
            for (JsonElement element : array) {
                biomes.add(Biome.BiomeCategory.m_47643_((String)GsonHelper.m_13805_((JsonElement)element, (String)"biome entry")));
            }
            int weightBonus = GsonHelper.m_13824_((JsonObject)json, (String)"biome_bonus", (int)0);
            if (base.getWeight() + weightBonus <= 0) {
                throw new JsonSyntaxException("Weight combined with bonus cannot be 0 or less");
            }
            return new RecipeMarimorphosis(recipeId, base.getInput(), base.getOutput(), base.getWeight(), weightBonus, biomes);
        }

        public RecipeMarimorphosis fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
            RecipeOrechid base = (RecipeOrechid)ModRecipeTypes.ORECHID_SERIALIZER.m_8005_(recipeId, buffer);
            HashSet<Biome.BiomeCategory> biomes = new HashSet<Biome.BiomeCategory>();
            int size = buffer.m_130242_();
            for (int i = 0; i < size; ++i) {
                biomes.add(Biome.BiomeCategory.m_47643_((String)buffer.m_130277_()));
            }
            int weightBonus = buffer.m_130242_();
            return new RecipeMarimorphosis(recipeId, base.getInput(), base.getOutput(), base.getWeight(), weightBonus, biomes);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull RecipeMarimorphosis recipe) {
            ModRecipeTypes.ORECHID_SERIALIZER.m_6178_(buffer, (Recipe)recipe);
            buffer.m_130130_(recipe.biomes.size());
            for (Biome.BiomeCategory biomeCategory : recipe.biomes) {
                buffer.m_130070_(biomeCategory.m_7912_());
            }
            buffer.m_130130_(recipe.weightBonus);
        }
    }
}

