/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.spark.IManaSpark;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.api.mana.spark.SparkUpgradeType;
import vazkii.botania.common.entity.EntitySparkBase;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.item.ItemSparkUpgrade;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.PacketBotaniaEffect;
import vazkii.botania.xplat.IXplatAbstractions;

public class EntityManaSpark
extends EntitySparkBase
implements IManaSpark {
    private static final int TRANSFER_RATE = 1000;
    private static final String TAG_UPGRADE = "upgrade";
    private static final EntityDataAccessor<Integer> UPGRADE = SynchedEntityData.m_135353_(EntityManaSpark.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final Set<IManaSpark> transfers = Collections.newSetFromMap(new WeakHashMap());
    private int removeTransferants = 2;

    public EntityManaSpark(EntityType<EntityManaSpark> type, Level world) {
        super(type, world);
    }

    public EntityManaSpark(Level world) {
        this(ModEntities.SPARK, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(UPGRADE, (Object)0);
    }

    @Nonnull
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ModItems.spark);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            return;
        }
        ISparkAttachable tile = this.getAttachedTile();
        if (tile == null) {
            this.dropAndKill();
            return;
        }
        SparkUpgradeType upgrade = this.getUpgrade();
        Collection<IManaSpark> transfers = this.getTransfers();
        switch (upgrade) {
            case DISPERSIVE: {
                Player player2;
                List<Player> players = SparkHelper.getEntitiesAround(Player.class, this.f_19853_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() / 2.0, this.m_20189_());
                HashMap receivingPlayers = new HashMap();
                ItemStack input = new ItemStack((ItemLike)ModItems.spark);
                for (Player player2 : players) {
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    stacks.addAll((Collection<ItemStack>)player2.m_150109_().f_35974_);
                    stacks.addAll((Collection<ItemStack>)player2.m_150109_().f_35975_);
                    Container inv = BotaniaAPI.instance().getAccessoriesInventory(player2);
                    for (int i = 0; i < inv.m_6643_(); ++i) {
                        stacks.add(inv.m_8020_(i));
                    }
                    for (ItemStack stack : stacks) {
                        int recv;
                        HashMap<ItemStack, Integer> receivingStacks;
                        IManaItem manaItem;
                        Item item;
                        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof IManaItem) || !(manaItem = (IManaItem)item).canReceiveManaFromItem(stack, input)) continue;
                        boolean add = false;
                        if (!receivingPlayers.containsKey(player2)) {
                            add = true;
                            receivingStacks = new HashMap<ItemStack, Integer>();
                        } else {
                            receivingStacks = (HashMap<ItemStack, Integer>)receivingPlayers.get(player2);
                        }
                        if ((recv = Math.min(this.getAttachedTile().getCurrentMana(), Math.min(1000, manaItem.getMaxMana(stack) - manaItem.getMana(stack)))) <= 0) continue;
                        receivingStacks.put(stack, recv);
                        if (!add) continue;
                        receivingPlayers.put(player2, receivingStacks);
                    }
                }
                if (receivingPlayers.isEmpty()) break;
                ArrayList keys = new ArrayList(receivingPlayers.keySet());
                Collections.shuffle(keys);
                player2 = (Player)keys.iterator().next();
                Map items = (Map)receivingPlayers.get(player2);
                ItemStack stack = (ItemStack)items.keySet().iterator().next();
                int cost = (Integer)items.get(stack);
                int manaToPut = Math.min(this.getAttachedTile().getCurrentMana(), cost);
                ((IManaItem)stack.m_41720_()).addMana(stack, manaToPut);
                this.getAttachedTile().receiveMana(-manaToPut);
                this.particlesTowards((Entity)player2);
                break;
            }
            case DOMINANT: {
                List validSparks = SparkHelper.getSparksAround(this.f_19853_, this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), this.getNetwork()).filter(s -> {
                    SparkUpgradeType otherUpgrade = s.getUpgrade();
                    return s != this && otherUpgrade == SparkUpgradeType.NONE && s.getAttachedTile() instanceof IManaPool;
                }).collect(Collectors.toList());
                if (validSparks.size() <= 0) break;
                ((IManaSpark)validSparks.get(this.f_19853_.f_46441_.nextInt(validSparks.size()))).registerTransfer(this);
                break;
            }
            case RECESSIVE: {
                SparkHelper.getSparksAround(this.f_19853_, this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), this.getNetwork()).filter(s -> {
                    SparkUpgradeType otherUpgrade = s.getUpgrade();
                    return s != this && otherUpgrade != SparkUpgradeType.DOMINANT && otherUpgrade != SparkUpgradeType.RECESSIVE && otherUpgrade != SparkUpgradeType.ISOLATED;
                }).forEach(transfers::add);
                break;
            }
        }
        if (!transfers.isEmpty()) {
            int manaTotal = Math.min(1000 * transfers.size(), tile.getCurrentMana());
            int count = transfers.size();
            int manaSpent = 0;
            if (manaTotal > 0) {
                for (IManaSpark spark : transfers) {
                    --count;
                    if (spark.getAttachedTile() == null || spark.getAttachedTile().isFull() || spark.areIncomingTransfersDone()) continue;
                    ISparkAttachable attached = spark.getAttachedTile();
                    int spend = Math.min(attached.getAvailableSpaceForMana(), (manaTotal - manaSpent) / (count + 1));
                    attached.receiveMana(spend);
                    manaSpent += spend;
                    this.particlesTowards(spark.entity());
                }
                tile.receiveMana(-manaSpent);
            }
        }
        if (this.removeTransferants > 0) {
            --this.removeTransferants;
        }
        this.filterTransfers();
    }

    private void particlesTowards(Entity e) {
        IXplatAbstractions.INSTANCE.sendToTracking(this, new PacketBotaniaEffect(EffectType.SPARK_MANA_FLOW, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_142049_(), e.m_142049_(), ColorHelper.getColorValue(this.getNetwork())));
    }

    public static void particleBeam(Player player, Entity e1, Entity e2) {
        if (e1 != null && e2 != null && !e1.f_19853_.f_46443_) {
            IXplatAbstractions.INSTANCE.sendToPlayer(player, new PacketBotaniaEffect(EffectType.SPARK_NET_INDICATOR, e1.m_20185_(), e1.m_20186_(), e1.m_20189_(), e1.m_142049_(), e2.m_142049_()));
        }
    }

    private void dropAndKill() {
        SparkUpgradeType upgrade = this.getUpgrade();
        this.m_5552_(new ItemStack((ItemLike)ModItems.spark), 0.0f);
        if (upgrade != SparkUpgradeType.NONE) {
            this.m_5552_(ItemSparkUpgrade.getByType(upgrade), 0.0f);
        }
        this.m_146870_();
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.m_6084_() && !stack.m_41619_()) {
            DyeItem dye;
            DyeColor color;
            SparkUpgradeType upgrade = this.getUpgrade();
            if (stack.m_150930_(ModItems.twigWand)) {
                if (!this.f_19853_.f_46443_) {
                    if (player.m_6144_()) {
                        if (upgrade != SparkUpgradeType.NONE) {
                            this.m_5552_(ItemSparkUpgrade.getByType(upgrade), 0.0f);
                            this.setUpgrade(SparkUpgradeType.NONE);
                            this.transfers.clear();
                            this.removeTransferants = 2;
                        } else {
                            this.dropAndKill();
                        }
                    } else {
                        SparkHelper.getSparksAround(this.f_19853_, this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), this.getNetwork()).forEach(s -> EntityManaSpark.particleBeam(player, this, s.entity()));
                    }
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            Item item = stack.m_41720_();
            if (item instanceof ItemSparkUpgrade) {
                ItemSparkUpgrade newUpgrade = (ItemSparkUpgrade)item;
                if (upgrade == SparkUpgradeType.NONE) {
                    if (!this.f_19853_.f_46443_) {
                        this.setUpgrade(newUpgrade.type);
                        stack.m_41774_(1);
                    }
                    return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
                }
            }
            if (stack.m_150930_(ModItems.phantomInk)) {
                if (!this.f_19853_.f_46443_) {
                    this.m_6842_(true);
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            item = stack.m_41720_();
            if (item instanceof DyeItem && (color = (dye = (DyeItem)item).m_41089_()) != this.getNetwork()) {
                if (!this.f_19853_.f_46443_) {
                    this.setNetwork(color);
                    stack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void m_7378_(@Nonnull CompoundTag cmp) {
        super.m_7378_(cmp);
        this.setUpgrade(SparkUpgradeType.values()[cmp.m_128451_(TAG_UPGRADE)]);
    }

    @Override
    protected void m_7380_(@Nonnull CompoundTag cmp) {
        super.m_7380_(cmp);
        cmp.m_128405_(TAG_UPGRADE, this.getUpgrade().ordinal());
    }

    @Override
    public ISparkAttachable getAttachedTile() {
        BlockEntity tile = this.f_19853_.m_7702_(this.getAttachPos());
        if (tile instanceof ISparkAttachable) {
            ISparkAttachable sparkable = (ISparkAttachable)tile;
            return sparkable;
        }
        return null;
    }

    private void filterTransfers() {
        Iterator<IManaSpark> iter = this.transfers.iterator();
        while (iter.hasNext()) {
            IManaSpark spark = iter.next();
            SparkUpgradeType upgr = this.getUpgrade();
            SparkUpgradeType supgr = spark.getUpgrade();
            ISparkAttachable atile = spark.getAttachedTile();
            if (spark != this && ((Entity)spark).m_6084_() && !spark.areIncomingTransfersDone() && this.getNetwork() == spark.getNetwork() && atile != null && !atile.isFull() && (upgr == SparkUpgradeType.NONE && supgr == SparkUpgradeType.DOMINANT || upgr == SparkUpgradeType.RECESSIVE && (supgr == SparkUpgradeType.NONE || supgr == SparkUpgradeType.DISPERSIVE) || !(atile instanceof IManaPool))) continue;
            iter.remove();
        }
    }

    @Override
    public Collection<IManaSpark> getTransfers() {
        this.filterTransfers();
        return this.transfers;
    }

    private boolean hasTransfer(IManaSpark entity) {
        return this.transfers.contains(entity);
    }

    @Override
    public void registerTransfer(IManaSpark entity) {
        if (this.hasTransfer(entity)) {
            return;
        }
        this.transfers.add(entity);
    }

    @Override
    public SparkUpgradeType getUpgrade() {
        return SparkUpgradeType.values()[(Integer)this.f_19804_.m_135370_(UPGRADE)];
    }

    @Override
    public void setUpgrade(SparkUpgradeType upgrade) {
        this.f_19804_.m_135381_(UPGRADE, (Object)upgrade.ordinal());
    }

    @Override
    public boolean areIncomingTransfersDone() {
        ISparkAttachable tile = this.getAttachedTile();
        if (tile instanceof IManaPool) {
            return this.removeTransferants > 0;
        }
        return tile != null && tile.areIncomingTranfersDone();
    }
}

