/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.rod.ItemExchangeRod;
import vazkii.botania.xplat.IXplatAbstractions;

public class ItemAstrolabe
extends Item {
    private static final String TAG_BLOCKSTATE = "blockstate";
    private static final String TAG_SIZE = "size";

    public ItemAstrolabe(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext ctx) {
        ItemStack stack = ctx.m_43722_();
        BlockState state = ctx.m_43725_().m_8055_(ctx.m_8083_());
        Player player = ctx.m_43723_();
        if (player != null && player.m_6144_()) {
            if (this.setBlock(stack, state)) {
                this.displayRemainderCounter(player, stack);
                return InteractionResult.SUCCESS;
            }
        } else if (player != null) {
            boolean did = this.placeAllBlocks(stack, player);
            if (did) {
                this.displayRemainderCounter(player, stack);
            }
            return did ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, @Nonnull InteractionHand hand) {
        ItemStack stack = playerIn.m_21120_(hand);
        if (playerIn.m_6144_()) {
            playerIn.m_5496_(ModSounds.astrolabeConfigure, 1.0f, 1.0f);
            if (!worldIn.f_46443_) {
                int size = ItemAstrolabe.getSize(stack);
                int newSize = size == 11 ? 3 : size + 2;
                ItemAstrolabe.setSize(stack, newSize);
                ItemsRemainingRenderHandler.send(playerIn, stack, 0, (Component)new TextComponent(newSize + "x" + newSize));
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public boolean placeAllBlocks(ItemStack stack, Player player) {
        List<BlockPos> blocksToPlace = ItemAstrolabe.getBlocksToPlace(stack, player);
        if (!ItemAstrolabe.hasBlocks(stack, player, blocksToPlace)) {
            return false;
        }
        int size = ItemAstrolabe.getSize(stack);
        int cost = size * 320;
        if (!ManaItemHandler.instance().requestManaExact(stack, player, cost, false)) {
            return false;
        }
        ItemStack stackToPlace = new ItemStack((ItemLike)ItemAstrolabe.getBlock(stack));
        for (BlockPos coords : blocksToPlace) {
            this.placeBlockAndConsume(player, stack, stackToPlace, coords);
        }
        ManaItemHandler.instance().requestManaExact(stack, player, cost, true);
        return true;
    }

    private void placeBlockAndConsume(Player player, ItemStack requestor, ItemStack blockToPlace, BlockPos coords) {
        if (blockToPlace.m_41619_()) {
            return;
        }
        Block block = Block.m_49814_((Item)blockToPlace.m_41720_());
        BlockState state = block.m_49966_();
        player.f_19853_.m_46597_(coords, state);
        player.f_19853_.m_46796_(2001, coords, Block.m_49956_((BlockState)state));
        if (player.m_150110_().f_35937_) {
            return;
        }
        ArrayList<IBlockProvider> providers = new ArrayList<IBlockProvider>();
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            IBlockProvider provider;
            ItemStack stackInSlot = player.m_150109_().m_8020_(i);
            if (!stackInSlot.m_41619_() && stackInSlot.m_150930_(blockToPlace.m_41720_())) {
                stackInSlot.m_41774_(1);
                return;
            }
            if (stackInSlot.m_41619_() || (provider = IXplatAbstractions.INSTANCE.findBlockProvider(stackInSlot)) == null) continue;
            providers.add(provider);
        }
        for (IBlockProvider prov : providers) {
            if (!prov.provideBlock(player, requestor, block, false)) continue;
            prov.provideBlock(player, requestor, block, true);
            return;
        }
    }

    public static boolean hasBlocks(ItemStack stack, Player player, List<BlockPos> blocks) {
        if (player.m_150110_().f_35937_) {
            return true;
        }
        Block block = ItemAstrolabe.getBlock(stack);
        ItemStack reqStack = new ItemStack((ItemLike)block);
        int required = blocks.size();
        int current = 0;
        ArrayList<IBlockProvider> providersToCheck = new ArrayList<IBlockProvider>();
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            IBlockProvider provider;
            ItemStack stackInSlot = player.m_150109_().m_8020_(i);
            if (!stackInSlot.m_41619_() && stackInSlot.m_150930_(reqStack.m_41720_()) && (current += stackInSlot.m_41613_()) >= required) {
                return true;
            }
            if (stackInSlot.m_41619_() || (provider = IXplatAbstractions.INSTANCE.findBlockProvider(stackInSlot)) == null) continue;
            providersToCheck.add(provider);
        }
        for (IBlockProvider prov : providersToCheck) {
            int count = prov.getBlockCount(player, stack, block);
            if (count == -1) {
                return true;
            }
            if ((current += count) < required) continue;
            return true;
        }
        return false;
    }

    public static List<BlockPos> getBlocksToPlace(ItemStack stack, Player player) {
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        BlockHitResult rtr = ToolCommons.raytraceFromEntity((Entity)player, 5.0, true);
        if (rtr.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos pos = rtr.m_82425_();
            BlockState state = player.f_19853_.m_8055_(pos);
            if (state.m_60767_().m_76336_()) {
                pos = pos.m_7495_();
            }
            int range = (ItemAstrolabe.getSize(stack) ^ 1) / 2;
            Direction dir = rtr.m_82434_();
            Direction rotationDir = Direction.m_122364_((double)player.m_146908_());
            boolean pitchedVertically = Math.abs(player.m_146909_()) > 50.0f;
            boolean axisX = rotationDir.m_122434_() == Direction.Axis.X;
            boolean axisZ = rotationDir.m_122434_() == Direction.Axis.Z;
            int xOff = axisZ || pitchedVertically ? range : 0;
            int yOff = pitchedVertically ? 0 : range;
            int zOff = axisX || pitchedVertically ? range : 0;
            for (int x = -xOff; x < xOff + 1; ++x) {
                for (int y = 0; y < yOff * 2 + 1; ++y) {
                    for (int z = -zOff; z < zOff + 1; ++z) {
                        int xp = pos.m_123341_() + x + dir.m_122429_();
                        int yp = pos.m_123342_() + y + dir.m_122430_();
                        int zp = pos.m_123343_() + z + dir.m_122431_();
                        BlockPos newPos = new BlockPos(xp, yp, zp);
                        BlockState state1 = player.f_19853_.m_8055_(newPos);
                        if (!player.f_19853_.m_6857_().m_61937_(newPos) || !state1.m_60795_() && !state1.m_60767_().m_76336_()) continue;
                        coords.add(newPos);
                    }
                }
            }
        }
        return coords;
    }

    public void displayRemainderCounter(Player player, ItemStack stack) {
        Block block = ItemAstrolabe.getBlock(stack);
        int count = ItemExchangeRod.getInventoryItemCount(player, stack, block.m_5456_());
        if (!player.f_19853_.f_46443_) {
            ItemsRemainingRenderHandler.send(player, new ItemStack((ItemLike)block), count);
        }
    }

    private boolean setBlock(ItemStack stack, BlockState state) {
        if (!state.m_60795_()) {
            ItemNBTHelper.setCompound(stack, TAG_BLOCKSTATE, NbtUtils.m_129202_((BlockState)state));
            return true;
        }
        return false;
    }

    private static void setSize(ItemStack stack, int size) {
        ItemNBTHelper.setInt(stack, TAG_SIZE, size | 1);
    }

    public static int getSize(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_SIZE, 3) | 1;
    }

    public static Block getBlock(ItemStack stack) {
        return ItemAstrolabe.getBlockState(stack).m_60734_();
    }

    public static BlockState getBlockState(ItemStack stack) {
        return NbtUtils.m_129241_((CompoundTag)ItemNBTHelper.getCompound(stack, TAG_BLOCKSTATE, false));
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tip, TooltipFlag flags) {
        Block block = ItemAstrolabe.getBlock(stack);
        int size = ItemAstrolabe.getSize(stack);
        tip.add((Component)new TextComponent(size + " x " + size));
        if (block != Blocks.f_50016_) {
            tip.add((Component)new ItemStack((ItemLike)block).m_41786_().m_6879_().m_130940_(ChatFormatting.GRAY));
        }
    }
}

