/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.terrasteel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ISequentialBreaker;
import vazkii.botania.common.item.ItemTemperanceStone;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.equipment.tool.manasteel.ItemManasteelAxe;

public class ItemTerraAxe
extends ItemManasteelAxe
implements ISequentialBreaker {
    private static final int BLOCK_SWAP_RATE = 10;
    public static final int BLOCK_RANGE = 32;
    private static final int LEAF_BLOCK_RANGE = 3;
    private static final int MANA_PER_DAMAGE = 100;
    private static final Map<ResourceKey<Level>, Set<BlockSwapper>> blockSwappers = new HashMap<ResourceKey<Level>, Set<BlockSwapper>>();
    private static boolean tickingSwappers = false;

    public ItemTerraAxe(Item.Properties props) {
        super(BotaniaAPI.instance().getTerrasteelItemTier(), props);
    }

    public static boolean shouldBreak(Player player) {
        return !player.m_6144_() && !ItemTemperanceStone.hasTemperanceActive(player);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        BlockHitResult raycast = ToolCommons.raytraceFromEntity((Entity)player, 10.0, false);
        if (raycast.m_6662_() == HitResult.Type.BLOCK) {
            Direction face = raycast.m_82434_();
            this.breakOtherBlock(player, stack, pos, pos, face);
            if (player.m_36341_()) {
                BotaniaAPI.instance().breakOnAllCursors(player, stack, pos, face);
            }
        }
        return false;
    }

    @Override
    public int getManaPerDamage() {
        return 100;
    }

    @Override
    public void breakOtherBlock(Player player, ItemStack stack, BlockPos pos, BlockPos originPos, Direction side) {
        if (ItemTerraAxe.shouldBreak(player) && !tickingSwappers) {
            ItemTerraAxe.addBlockSwapper(player.f_19853_, player, stack, pos);
        }
    }

    public static void onTickEnd(ServerLevel world) {
        ResourceKey dim = world.m_46472_();
        if (blockSwappers.containsKey(dim)) {
            tickingSwappers = true;
            Set<BlockSwapper> swappers = blockSwappers.get(dim);
            swappers.removeIf(next -> next == null || !next.tick());
            tickingSwappers = false;
        }
    }

    private static void addBlockSwapper(Level world, Player player, ItemStack stack, BlockPos origCoords) {
        if (world.f_46443_) {
            return;
        }
        BlockSwapper swapper = new BlockSwapper(world, player, stack, origCoords, 32);
        ResourceKey dim = world.m_46472_();
        blockSwappers.computeIfAbsent((ResourceKey<Level>)dim, d -> new HashSet()).add(swapper);
    }

    private static class BlockSwapper {
        public static final int SINGLE_BLOCK_RADIUS = 1;
        private final Level world;
        private final Player player;
        private final ItemStack truncator;
        private final PriorityQueue<SwapCandidate> candidateQueue = new PriorityQueue();
        private final Set<BlockPos> completedCoords = new HashSet<BlockPos>();

        public BlockSwapper(Level world, Player player, ItemStack truncator, BlockPos origCoords, int range) {
            this.world = world;
            this.player = player;
            this.truncator = truncator;
            this.candidateQueue.offer(new SwapCandidate(origCoords, range));
        }

        public boolean tick() {
            if (this.candidateQueue.isEmpty()) {
                return false;
            }
            int remainingSwaps = 10;
            while (remainingSwaps > 0 && !this.candidateQueue.isEmpty()) {
                SwapCandidate cand = this.candidateQueue.poll();
                if (this.completedCoords.contains(cand.coordinates) || cand.range <= 0) continue;
                ToolCommons.removeBlockWithDrops(this.player, this.truncator, this.world, cand.coordinates, state -> state.m_60620_((Tag)BlockTags.f_144280_) || state.m_60620_((Tag)BlockTags.f_13035_));
                --remainingSwaps;
                this.completedCoords.add(cand.coordinates);
                for (BlockPos adj : this.adjacent(cand.coordinates)) {
                    Block block = this.world.m_8055_(adj).m_60734_();
                    boolean isWood = BlockTags.f_13106_.m_8110_((Object)block);
                    boolean isLeaf = BlockTags.f_13035_.m_8110_((Object)block);
                    if (!isWood && !isLeaf) continue;
                    int newRange = isLeaf ? Math.min(3, cand.range - 1) : cand.range - 1;
                    this.candidateQueue.offer(new SwapCandidate(adj, newRange));
                }
            }
            return true;
        }

        public List<BlockPos> adjacent(BlockPos original) {
            ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        if (dx == 0 && dy == 0 && dz == 0) continue;
                        coords.add(original.m_142082_(dx, dy, dz));
                    }
                }
            }
            return coords;
        }

        public record SwapCandidate(BlockPos coordinates, int range) implements Comparable<SwapCandidate>
        {
            @Override
            public int compareTo(@Nonnull SwapCandidate other) {
                return other.range - this.range;
            }
        }
    }
}

