/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.common.advancements.RelicBindTrigger;
import vazkii.botania.common.helper.ItemNBTHelper;

public class ItemRelic
extends Item
implements IRelic {
    private static final String TAG_SOULBIND_UUID = "soulbindUUID";

    public ItemRelic(Item.Properties props) {
        super(props);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!world.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            this.updateRelic(stack, player);
        }
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        if (!this.hasUUID(stack)) {
            tooltip.add((Component)new TranslatableComponent("botaniamisc.relicUnbound"));
        } else if (!this.getSoulbindUUID(stack).equals(Minecraft.m_91087_().f_91074_.m_142081_())) {
            tooltip.add((Component)new TranslatableComponent("botaniamisc.notYourSagittarius"));
        } else {
            tooltip.add((Component)new TranslatableComponent("botaniamisc.relicSoulbound", new Object[]{Minecraft.m_91087_().f_91074_.m_7755_()}));
        }
    }

    public boolean shouldDamageWrongPlayer() {
        return true;
    }

    public void updateRelic(ItemStack stack, Player player) {
        ItemRelic relic;
        Item item;
        if (stack.m_41619_() || !(stack.m_41720_() instanceof IRelic)) {
            return;
        }
        boolean rightPlayer = true;
        if (!this.hasUUID(stack)) {
            this.bindToUUID(player.m_142081_(), stack);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                RelicBindTrigger.INSTANCE.trigger(serverPlayer, stack);
            }
        } else if (!this.getSoulbindUUID(stack).equals(player.m_142081_())) {
            rightPlayer = false;
        }
        if (!(rightPlayer || player.f_19797_ % 10 != 0 || (item = stack.m_41720_()) instanceof ItemRelic && !(relic = (ItemRelic)item).shouldDamageWrongPlayer())) {
            player.m_6469_(ItemRelic.damageSource(), 2.0f);
        }
    }

    public boolean isRightPlayer(Player player, ItemStack stack) {
        return this.hasUUID(stack) && this.getSoulbindUUID(stack).equals(player.m_142081_());
    }

    public static DamageSource damageSource() {
        return new DamageSource("botania-relic"){};
    }

    @Override
    public void bindToUUID(UUID uuid, ItemStack stack) {
        ItemNBTHelper.setString(stack, TAG_SOULBIND_UUID, uuid.toString());
    }

    @Override
    public UUID getSoulbindUUID(ItemStack stack) {
        if (ItemNBTHelper.verifyExistance(stack, TAG_SOULBIND_UUID)) {
            try {
                return UUID.fromString(ItemNBTHelper.getString(stack, TAG_SOULBIND_UUID, ""));
            }
            catch (IllegalArgumentException ex) {
                ItemNBTHelper.removeEntry(stack, TAG_SOULBIND_UUID);
            }
        }
        return null;
    }

    @Override
    public boolean hasUUID(ItemStack stack) {
        return this.getSoulbindUUID(stack) != null;
    }
}

