/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.proxy;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.common.entity.EntityDoppleganger;
import vazkii.botania.xplat.IXplatAbstractions;
import vazkii.patchouli.api.IMultiblock;

public interface IProxy {
    public static final IProxy INSTANCE = IProxy.make();

    private static IProxy make() {
        if (IXplatAbstractions.INSTANCE.isPhysicalClient()) {
            return new ClientProxy();
        }
        return new IProxy(){};
    }

    default public void runOnClient(Supplier<Runnable> s) {
    }

    default public Player getClientPlayer() {
        return null;
    }

    default public boolean isClientPlayerWearingMonocle() {
        return false;
    }

    default public void lightningFX(Vec3 vectorStart, Vec3 vectorEnd, float ticksPerMeter, int colorOuter, int colorInner) {
        this.lightningFX(vectorStart, vectorEnd, ticksPerMeter, System.nanoTime(), colorOuter, colorInner);
    }

    default public void lightningFX(Vec3 vectorStart, Vec3 vectorEnd, float ticksPerMeter, long seed, int colorOuter, int colorInner) {
    }

    default public void addBoss(EntityDoppleganger boss) {
    }

    default public void removeBoss(EntityDoppleganger boss) {
    }

    default public int getClientRenderDistance() {
        return 0;
    }

    default public void addParticleForce(Level world, ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }

    default public void addParticleForceNear(Level world, ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }

    default public void showMultiblock(IMultiblock mb, Component name, BlockPos anchor, Rotation rot) {
    }

    default public void clearSextantMultiblock() {
    }
}

