/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.forge.client;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block.IFloatingFlower;

public class ForgeFloatingFlowerModel
implements IModelGeometry<ForgeFloatingFlowerModel> {
    public static final ModelProperty<IFloatingFlower> FLOATING_PROPERTY = new ModelProperty();
    private final UnbakedModel unbakedFlower;
    private final Map<IFloatingFlower.IslandType, UnbakedModel> unbakedIslands = new HashMap<IFloatingFlower.IslandType, UnbakedModel>();

    private ForgeFloatingFlowerModel(UnbakedModel flower) {
        this.unbakedFlower = flower;
    }

    @Nonnull
    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet<Material> ret = new HashSet<Material>();
        for (Map.Entry<IFloatingFlower.IslandType, ResourceLocation> e : BotaniaAPIClient.instance().getRegisteredIslandTypeModels().entrySet()) {
            UnbakedModel unbakedIsland = modelGetter.apply(e.getValue());
            ret.addAll(unbakedIsland.m_5500_(modelGetter, missingTextureErrors));
            this.unbakedIslands.put(e.getKey(), unbakedIsland);
        }
        ret.addAll(this.unbakedFlower.m_5500_(modelGetter, missingTextureErrors));
        return ret;
    }

    @Nullable
    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, final ModelState transform, ItemOverrides overrides, ResourceLocation name) {
        Transformation moveFlower = new Transformation(new Vector3f(0.0f, 0.2f, 0.0f), null, new Vector3f(0.5f, 0.5f, 0.5f), null);
        final Transformation mul = moveFlower.m_121096_(transform.m_6189_());
        ModelState newTransform = new ModelState(){

            public Transformation m_6189_() {
                return mul;
            }

            public boolean m_7538_() {
                return transform.m_7538_();
            }
        };
        BakedModel bakedFlower = this.unbakedFlower.m_7611_(bakery, spriteGetter, newTransform, name);
        HashMap<IFloatingFlower.IslandType, BakedModel> bakedIslands = new HashMap<IFloatingFlower.IslandType, BakedModel>();
        for (Map.Entry<IFloatingFlower.IslandType, UnbakedModel> e : this.unbakedIslands.entrySet()) {
            BakedModel bakedIsland = e.getValue().m_7611_(bakery, spriteGetter, transform, name);
            bakedIslands.put(e.getKey(), bakedIsland);
        }
        return new Baked(bakedFlower, bakedIslands);
    }

    public static class Baked
    extends BakedModelWrapper<BakedModel> {
        private final Map<IFloatingFlower.IslandType, BakedModel> islands;

        Baked(BakedModel flower, Map<IFloatingFlower.IslandType, BakedModel> islands) {
            super(flower);
            this.islands = islands;
        }

        @Nonnull
        public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand) {
            return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            IFloatingFlower.IslandType type = IFloatingFlower.IslandType.GRASS;
            if (extraData.hasProperty(FLOATING_PROPERTY)) {
                type = ((IFloatingFlower)extraData.getData(FLOATING_PROPERTY)).getIslandType();
            }
            List flower = super.getQuads(null, null, rand, (IModelData)EmptyModelData.INSTANCE);
            List island = this.islands.get(type).getQuads(null, null, rand, (IModelData)EmptyModelData.INSTANCE);
            ArrayList<BakedQuad> ret = new ArrayList<BakedQuad>(flower.size() + island.size());
            ret.addAll(flower);
            ret.addAll(island);
            return ret;
        }

        @Nonnull
        public BakedModel handlePerspective(@Nonnull ItemTransforms.TransformType cameraTransformType, @Nonnull PoseStack poseStack) {
            return ForgeHooksClient.handlePerspective((BakedModel)this, (ItemTransforms.TransformType)cameraTransformType, (PoseStack)poseStack);
        }
    }

    public static enum Loader implements IModelLoader<ForgeFloatingFlowerModel>
    {
        INSTANCE;


        public void m_6213_(@Nonnull ResourceManager resourceManager) {
        }

        @Nonnull
        public ForgeFloatingFlowerModel read(JsonDeserializationContext ctx, JsonObject model) {
            BlockModel flower = (BlockModel)ctx.deserialize((JsonElement)model.getAsJsonObject("flower"), BlockModel.class);
            return new ForgeFloatingFlowerModel((UnbakedModel)flower);
        }
    }
}

