/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.forge.internal_caps;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.botania.common.block.subtile.functional.SubTileLoonuim;
import vazkii.botania.common.internal_caps.EthicalComponent;
import vazkii.botania.common.internal_caps.GhostRailComponent;
import vazkii.botania.common.internal_caps.ItemFlagsComponent;
import vazkii.botania.common.internal_caps.KeptItemsComponent;
import vazkii.botania.common.internal_caps.LooniumComponent;
import vazkii.botania.common.internal_caps.NarslimmusComponent;
import vazkii.botania.common.internal_caps.TigerseyeComponent;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.forge.CapabilityUtil;

public final class ForgeInternalEntityCapabilities {
    public static final Capability<EthicalComponent> TNT_ETHICAL = CapabilityManager.get((CapabilityToken)new CapabilityToken<EthicalComponent>(){});
    public static final Capability<GhostRailComponent> GHOST_RAIL = CapabilityManager.get((CapabilityToken)new CapabilityToken<GhostRailComponent>(){});
    public static final Capability<ItemFlagsComponent> INTERNAL_ITEM = CapabilityManager.get((CapabilityToken)new CapabilityToken<ItemFlagsComponent>(){});
    public static final Capability<KeptItemsComponent> KEPT_ITEMS = CapabilityManager.get((CapabilityToken)new CapabilityToken<KeptItemsComponent>(){});
    public static final Capability<LooniumComponent> LOONIUM_DROP = CapabilityManager.get((CapabilityToken)new CapabilityToken<LooniumComponent>(){});
    public static final Capability<NarslimmusComponent> NARSLIMMUS = CapabilityManager.get((CapabilityToken)new CapabilityToken<NarslimmusComponent>(){});
    public static final Capability<TigerseyeComponent> TIGERSEYE = CapabilityManager.get((CapabilityToken)new CapabilityToken<TigerseyeComponent>(){});

    private ForgeInternalEntityCapabilities() {
    }

    private static class ForgeTigerseyeCap
    extends TigerseyeComponent
    implements INBTSerializable<CompoundTag> {
        private ForgeTigerseyeCap() {
        }
    }

    private static class ForgeNarslimmusCap
    extends NarslimmusComponent
    implements INBTSerializable<CompoundTag> {
        private ForgeNarslimmusCap() {
        }
    }

    private static class ForgeLooniumCap
    extends LooniumComponent
    implements INBTSerializable<CompoundTag> {
        private ForgeLooniumCap() {
        }
    }

    private static class ForgeKeptItemsCap
    extends KeptItemsComponent
    implements INBTSerializable<CompoundTag> {
        private ForgeKeptItemsCap() {
        }
    }

    private static class ForgeItemFlagsCap
    extends ItemFlagsComponent
    implements INBTSerializable<CompoundTag> {
        private ForgeItemFlagsCap() {
        }
    }

    private static class ForgeGhostRailCap
    extends GhostRailComponent
    implements INBTSerializable<CompoundTag> {
        private ForgeGhostRailCap() {
        }
    }

    private static class ForgeEthicalCap
    extends EthicalComponent
    implements INBTSerializable<CompoundTag> {
        public ForgeEthicalCap(PrimedTnt entity) {
            super(entity);
        }
    }

    @Mod.EventBusSubscriber(modid="botania", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeBusEvents {
        @SubscribeEvent
        public static void attachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
            Entity entity = (Entity)evt.getObject();
            if (entity instanceof PrimedTnt) {
                PrimedTnt tnt = (PrimedTnt)entity;
                evt.addCapability(ResourceLocationHelper.prefix("tnt_ethical"), CapabilityUtil.makeSavedProvider(TNT_ETHICAL, new ForgeEthicalCap(tnt)));
            }
            if (entity instanceof AbstractMinecart) {
                evt.addCapability(ResourceLocationHelper.prefix("ghost_rail"), CapabilityUtil.makeSavedProvider(GHOST_RAIL, new ForgeGhostRailCap()));
            }
            if (entity instanceof ItemEntity) {
                evt.addCapability(ResourceLocationHelper.prefix("iitem"), CapabilityUtil.makeSavedProvider(INTERNAL_ITEM, new ForgeItemFlagsCap()));
            }
            if (entity instanceof Player) {
                evt.addCapability(ResourceLocationHelper.prefix("kept_items"), CapabilityUtil.makeSavedProvider(KEPT_ITEMS, new ForgeKeptItemsCap()));
            }
            for (Class<? extends Monster> clz : SubTileLoonuim.VALID_MOBS) {
                if (!clz.isInstance(entity)) continue;
                evt.addCapability(ResourceLocationHelper.prefix("loonium_drop"), CapabilityUtil.makeSavedProvider(LOONIUM_DROP, new ForgeLooniumCap()));
                break;
            }
            if (entity instanceof Slime) {
                evt.addCapability(ResourceLocationHelper.prefix("narslimmus"), CapabilityUtil.makeSavedProvider(NARSLIMMUS, new ForgeNarslimmusCap()));
            }
            if (entity instanceof Creeper) {
                evt.addCapability(ResourceLocationHelper.prefix("tigerseye_pacified"), CapabilityUtil.makeSavedProvider(TIGERSEYE, new ForgeTigerseyeCap()));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="botania", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void registerCaps(RegisterCapabilitiesEvent evt) {
            evt.register(EthicalComponent.class);
            evt.register(GhostRailComponent.class);
            evt.register(ItemFlagsComponent.class);
            evt.register(KeptItemsComponent.class);
            evt.register(LooniumComponent.class);
            evt.register(NarslimmusComponent.class);
            evt.register(TigerseyeComponent.class);
        }
    }
}

