/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.mixin;

import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vazkii.botania.common.item.equipment.tool.elementium.ItemElementiumPick;
import vazkii.botania.xplat.IXplatAbstractions;

@Mixin(value={LootTable.class})
public class MixinLootTable {
    private static final ResourceLocation GOG_SEEDS = new ResourceLocation("gardenofglass", "extra_seeds");
    @Unique
    private boolean callingGogTable;

    @Inject(at={@At(value="RETURN")}, method={"getRandomItemsRaw"})
    private void addGogSeeds(LootContext context, Consumer<ItemStack> stacksOut, CallbackInfo ci) {
        if (IXplatAbstractions.INSTANCE.gogLoaded() && !this.callingGogTable) {
            this.callingGogTable = true;
            context.m_78940_(GOG_SEEDS).m_79148_(context, stacksOut);
            this.callingGogTable = false;
        }
    }

    @ModifyArg(method={"getRandomItems(Lnet/minecraft/world/level/storage/loot/LootContext;Ljava/util/function/Consumer;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/loot/LootTable;getRandomItemsRaw(Lnet/minecraft/world/level/storage/loot/LootContext;Ljava/util/function/Consumer;)V"), index=1)
    private Consumer<ItemStack> filterDisposables(LootContext context, Consumer<ItemStack> inner) {
        return stack -> {
            Entity e = (Entity)context.m_78953_(LootContextParams.f_81455_);
            ItemStack tool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
            if (e != null && tool != null && ItemElementiumPick.shouldFilterOut(e, tool, stack)) {
                return;
            }
            inner.accept((ItemStack)stack);
        };
    }
}

