/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.farmingforblockheads.api.IMarketEntry;
import net.blay09.mods.farmingforblockheads.block.ModBlocks;
import net.blay09.mods.farmingforblockheads.menu.MarketBuySlot;
import net.blay09.mods.farmingforblockheads.menu.MarketFakeSlot;
import net.blay09.mods.farmingforblockheads.menu.ModMenus;
import net.blay09.mods.farmingforblockheads.network.MarketListMessage;
import net.blay09.mods.farmingforblockheads.registry.MarketRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class MarketMenu
extends AbstractContainerMenu {
    private final Player player;
    private final BlockPos pos;
    private final DefaultContainer marketInputBuffer = new DefaultContainer(1);
    private final DefaultContainer marketOutputBuffer = new DefaultContainer(1);
    protected final List<MarketFakeSlot> marketSlots = new ArrayList<MarketFakeSlot>();
    private boolean sentItemList;
    protected IMarketEntry selectedEntry;

    public MarketMenu(int windowId, Inventory playerInventory, BlockPos pos) {
        super((MenuType)ModMenus.market.get(), windowId);
        int j;
        int i;
        this.player = playerInventory.f_35978_;
        this.pos = pos;
        this.m_38897_(new Slot((Container)this.marketInputBuffer, 0, 23, 39));
        this.m_38897_(new MarketBuySlot(this, (Container)this.marketOutputBuffer, 0, 61, 39));
        DefaultContainer fakeInventory = new DefaultContainer(12);
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 3; ++j) {
                MarketFakeSlot slot = new MarketFakeSlot((Container)fakeInventory, j + i * 3, 102 + j * 18, 11 + i * 18);
                this.marketSlots.add(slot);
                this.m_38897_(slot);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 92 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 150));
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemStack = slotStack.m_41777_();
            if (index == 1) {
                if (!this.isReadyToBuy()) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(slotStack, 14, 50, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slotStack, itemStack);
            } else if (index == 0 ? !this.m_38903_(slotStack, 14, 50, true) : (this.isPaymentItem(slotStack) ? !this.m_38903_(slotStack, 0, 1, true) : (index >= 41 && index < 50 ? !this.m_38903_(slotStack, 14, 41, true) : index >= 14 && index < 41 && !this.m_38903_(slotStack, 41, 50, false)))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return itemStack;
    }

    private boolean isPaymentItem(ItemStack itemStack) {
        return this.selectedEntry == null && itemStack.m_41720_() == Items.f_42616_ || this.selectedEntry != null && this.selectedEntry.getCostItem().m_41656_(itemStack) && ItemStack.m_150942_((ItemStack)this.selectedEntry.getCostItem(), (ItemStack)itemStack);
    }

    public void m_38946_() {
        super.m_38946_();
        if (!this.player.f_19853_.f_46443_ && !this.sentItemList) {
            Balm.getNetworking().sendTo(this.player, (Object)new MarketListMessage(MarketRegistry.getGroupedEntries()));
            this.sentItemList = true;
        }
    }

    public void m_6877_(Player player) {
        ItemStack itemStack;
        super.m_6877_(player);
        if (!player.f_19853_.f_46443_ && !(itemStack = this.marketInputBuffer.m_8016_(0)).m_41619_()) {
            player.m_36176_(itemStack, false);
        }
    }

    public boolean m_6875_(Player player) {
        return player.f_19853_.m_8055_(this.pos).m_60734_() == ModBlocks.market && player.m_20275_((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.5, (double)this.pos.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6199_(Container container) {
        if (this.selectedEntry != null) {
            this.marketOutputBuffer.m_6836_(0, this.selectedEntry.getOutputItem().m_41777_());
        } else {
            this.marketOutputBuffer.m_6836_(0, ItemStack.f_41583_);
        }
    }

    public void selectMarketEntry(UUID entryId) {
        this.selectedEntry = MarketRegistry.getEntryById(entryId);
        this.m_6199_((Container)this.marketInputBuffer);
    }

    @Nullable
    public IMarketEntry getSelectedEntry() {
        return this.selectedEntry;
    }

    public boolean m_5882_(ItemStack itemStack, Slot slot) {
        return slot.f_40218_ != this.marketOutputBuffer && super.m_5882_(itemStack, slot);
    }

    public boolean isReadyToBuy() {
        ItemStack payment = this.marketInputBuffer.m_8020_(0);
        return this.selectedEntry != null && !payment.m_41619_() && this.isPaymentItem(payment) && payment.m_41613_() >= this.selectedEntry.getCostItem().m_41613_();
    }

    public void onItemBought() {
        if (this.selectedEntry != null) {
            this.marketInputBuffer.m_7407_(0, this.selectedEntry.getCostItem().m_41613_());
            this.m_6199_((Container)this.marketInputBuffer);
        }
    }
}

