/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.supermartijn642.core.block.BaseTileEntity;
import com.supermartijn642.entangled.Entangled;
import com.supermartijn642.entangled.EntangledConfig;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class EntangledBlockTile
extends BaseTileEntity {
    private boolean bound = false;
    private BlockPos pos;
    private ResourceKey<Level> dimension;
    private BlockState blockState;
    private final int[] redstoneSignal = new int[]{0, 0, 0, 0, 0, 0};
    private final int[] directRedstoneSignal = new int[]{0, 0, 0, 0, 0, 0};
    private int analogOutputSignal = -1;
    private int callDepth = 0;

    public EntangledBlockTile(BlockPos pos, BlockState state) {
        super(Entangled.tile, pos, state);
    }

    public void tick() {
        Level world;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.bound && this.pos != null && (world = this.getDimension()) != null && (world.isAreaLoaded(this.pos, 1) || this.blockState == null || this.analogOutputSignal == -1)) {
            BlockState state = world.m_8055_(this.pos);
            int analogOutputSignal = state.m_60807_() ? state.m_60674_(world, this.pos) : 0;
            boolean signalChanged = false;
            for (Direction direction : Direction.values()) {
                int redstoneSignal = state.m_60746_((BlockGetter)world, this.pos, direction);
                int directRedstoneSignal = state.m_60775_((BlockGetter)world, this.pos, direction);
                if (redstoneSignal == this.redstoneSignal[direction.m_122411_()] && directRedstoneSignal == this.directRedstoneSignal[direction.m_122411_()]) continue;
                signalChanged = true;
                this.redstoneSignal[direction.m_122411_()] = redstoneSignal;
                this.directRedstoneSignal[direction.m_122411_()] = directRedstoneSignal;
            }
            if (state != this.blockState || analogOutputSignal != this.analogOutputSignal || signalChanged) {
                this.blockState = state;
                this.analogOutputSignal = analogOutputSignal;
                this.dataChanged();
                this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
                this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
            }
        }
    }

    public boolean isBound() {
        return this.bound;
    }

    @Nullable
    public BlockPos getBoundBlockPos() {
        return this.pos;
    }

    public ResourceKey<Level> getBoundDimension() {
        return this.dimension;
    }

    public BlockState getBoundBlockState() {
        return this.blockState;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability) {
        if (this.f_58857_ == null) {
            return LazyOptional.empty();
        }
        if (this.bound) {
            BlockEntity tile;
            if (this.f_58857_.f_46443_ && this.f_58857_.m_46472_() != this.dimension || this.callDepth >= 10) {
                return LazyOptional.empty();
            }
            Level world = this.getDimension();
            if (world != null && (tile = world.m_7702_(this.pos)) != null) {
                ++this.callDepth;
                LazyOptional value = tile.getCapability(capability);
                --this.callDepth;
                return value;
            }
        }
        return LazyOptional.empty();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (this.f_58857_ == null) {
            return LazyOptional.empty();
        }
        if (this.bound) {
            BlockEntity tile;
            if (this.f_58857_.f_46443_ && this.f_58857_.m_46472_() != this.dimension || this.callDepth >= 10) {
                return LazyOptional.empty();
            }
            Level world = this.getDimension();
            if (world != null && (tile = world.m_7702_(this.pos)) != null) {
                ++this.callDepth;
                LazyOptional value = tile.getCapability(capability, facing);
                --this.callDepth;
                return value;
            }
        }
        return LazyOptional.empty();
    }

    public boolean bind(BlockPos pos, String dimension) {
        if (!this.canBindTo(pos, dimension)) {
            return false;
        }
        this.pos = pos == null ? null : new BlockPos((Vec3i)pos);
        this.dimension = dimension == null ? null : ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(dimension));
        this.bound = pos != null;
        this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
        this.dataChanged();
        return true;
    }

    public boolean canBindTo(BlockPos pos, String dimension) {
        return pos == null && dimension == null || dimension.equals(this.f_58857_.m_46472_().m_135782_().toString()) ? EntangledConfig.maxDistance.get() == -1 || this.f_58858_.m_123314_((Vec3i)pos, (double)EntangledConfig.maxDistance.get().intValue() + 0.5) : EntangledConfig.allowDimensional.get();
    }

    private Level getDimension() {
        if (this.dimension == null) {
            return null;
        }
        return this.f_58857_.f_46443_ ? (this.f_58857_.m_46472_() == this.dimension ? this.f_58857_ : null) : this.f_58857_.m_142572_().m_129880_(this.dimension);
    }

    private boolean isTargetLoaded() {
        if (this.f_58857_.f_46443_ || !this.bound) {
            return false;
        }
        Level world = this.f_58857_.m_46472_() == this.dimension ? this.f_58857_ : this.f_58857_.m_142572_().m_129880_(this.dimension);
        return world != null && world.m_46749_(this.pos);
    }

    public int getRedstoneSignal(Direction side) {
        if (!this.bound) {
            return 0;
        }
        if (this.isTargetLoaded() && this.callDepth < 10) {
            ++this.callDepth;
            Level world = this.getDimension();
            this.redstoneSignal[side.m_122411_()] = world.m_8055_(this.pos).m_60746_((BlockGetter)world, this.pos, side);
            --this.callDepth;
            return Math.max(this.redstoneSignal[side.m_122411_()], 0);
        }
        return Math.max(this.redstoneSignal[side.m_122411_()], 0);
    }

    public int getDirectRedstoneSignal(Direction side) {
        if (!this.bound) {
            return 0;
        }
        if (this.isTargetLoaded() && this.callDepth < 10) {
            ++this.callDepth;
            Level world = this.getDimension();
            this.directRedstoneSignal[side.m_122411_()] = world.m_8055_(this.pos).m_60775_((BlockGetter)world, this.pos, side);
            --this.callDepth;
            return Math.max(this.directRedstoneSignal[side.m_122411_()], 0);
        }
        return Math.max(this.directRedstoneSignal[side.m_122411_()], 0);
    }

    public int getAnalogOutputSignal() {
        if (!this.bound) {
            return 0;
        }
        if (this.isTargetLoaded() && this.callDepth < 10) {
            ++this.callDepth;
            Level world = this.getDimension();
            this.analogOutputSignal = world.m_8055_(this.pos).m_60674_(world, this.pos);
            --this.callDepth;
            return Math.max(this.analogOutputSignal, 0);
        }
        return Math.max(this.analogOutputSignal, 0);
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("bound")) {
            CompoundTag data = new CompoundTag();
            data.m_128379_("bound", compound.m_128471_("bound"));
            data.m_128405_("boundx", compound.m_128451_("boundx"));
            data.m_128405_("boundy", compound.m_128451_("boundy"));
            data.m_128405_("boundz", compound.m_128451_("boundz"));
            data.m_128359_("dimension", compound.m_128461_("dimension"));
            compound.m_128365_("data", (Tag)data);
        }
        super.m_142466_(compound);
    }

    protected CompoundTag writeData() {
        CompoundTag compound = new CompoundTag();
        if (this.bound) {
            compound.m_128379_("bound", true);
            compound.m_128405_("boundx", this.pos.m_123341_());
            compound.m_128405_("boundy", this.pos.m_123342_());
            compound.m_128405_("boundz", this.pos.m_123343_());
            compound.m_128359_("dimension", this.dimension.m_135782_().toString());
            compound.m_128405_("blockstate", Block.m_49956_((BlockState)this.blockState));
            for (Direction direction : Direction.values()) {
                int index = direction.m_122411_();
                compound.m_128405_("redstoneSignal" + index, this.redstoneSignal[index]);
                compound.m_128405_("directRedstoneSignal" + index, this.directRedstoneSignal[index]);
            }
            compound.m_128405_("analogOutputSignal", this.analogOutputSignal);
        }
        return compound;
    }

    protected void readData(CompoundTag compound) {
        this.bound = compound.m_128471_("bound");
        if (this.bound) {
            this.pos = new BlockPos(compound.m_128451_("boundx"), compound.m_128451_("boundy"), compound.m_128451_("boundz"));
            this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(compound.m_128461_("dimension")));
            this.blockState = Block.m_49803_((int)compound.m_128451_("blockstate"));
            for (Direction direction : Direction.values()) {
                int index = direction.m_122411_();
                this.redstoneSignal[index] = compound.m_128451_("redstoneSignal" + index);
                this.directRedstoneSignal[index] = compound.m_128451_("directRedstoneSignal" + index);
            }
            this.analogOutputSignal = compound.m_128451_("analogOutputSignal");
        }
    }
}

