/*
 * Decompiled with CFR 0.152.
 */
package com.grimbo.chipped;

import com.grimbo.chipped.block.ChippedBlockTypes;
import com.grimbo.chipped.block.ChippedBlocks;
import com.grimbo.chipped.container.ChippedContainerType;
import com.grimbo.chipped.container.ChippedScreen;
import com.grimbo.chipped.item.ChippedItems;
import com.grimbo.chipped.recipe.ChippedSerializer;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

@Mod(value="chipped")
public class Chipped {
    public static final String MOD_ID = "chipped";
    public static final CreativeModeTab CHIPPED = new CreativeModeTab("chippedTab"){

        @NotNull
        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ChippedBlocks.BOTANIST_WORKBENCH.get());
        }
    }.m_40784_("chipped_tab");

    public Chipped() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ChippedBlocks.BLOCKS.register(eventBus);
        ChippedBlocks.register();
        ChippedItems.ITEMS.register(eventBus);
        ChippedSerializer.SERIALIZER.register(eventBus);
        ChippedContainerType.CONTAINER.register(eventBus);
        eventBus.addListener(this::clientRender);
        eventBus.addListener(this::onClientSetupEvent);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void checkHarvest(PlayerEvent.HarvestCheck event) {
        Item held = event.getPlayer().m_21205_().m_41720_();
        if ((held instanceof SwordItem || held instanceof ShearsItem) && event.getTargetBlock().m_60734_() instanceof WebBlock) {
            event.setCanHarvest(true);
        }
    }

    @SubscribeEvent
    public void clientRender(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ChippedBlocks.BOTANIST_WORKBENCH.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ChippedBlocks.LOOM_TABLE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ChippedBlocks.ALCHEMY_BENCH.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ChippedBlocks.MECHANIST_WORKBENCH.get()), (RenderType)RenderType.m_110463_());
        for (RegistryObject<GlassBlock> registryObject : ChippedBlockTypes.GLASSES) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.m_110463_());
        }
        for (RegistryObject<GlassBlock> registryObject : ChippedBlockTypes.GLASS_PANES) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.m_110463_());
        }
        for (int id = 0; id < 16; ++id) {
            DyeColor dyeColor = DyeColor.m_41053_((int)id);
            for (RegistryObject<StainedGlassBlock> registryObject : ChippedBlockTypes.STAINED_GLASSES.get(dyeColor)) {
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.m_110466_());
            }
            for (RegistryObject<StainedGlassBlock> registryObject : ChippedBlockTypes.STAINED_GLASS_PANES.get(dyeColor)) {
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.m_110466_());
            }
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.VINES) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.m_110463_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.BROWN_MUSHROOMS) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.m_110463_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.RED_MUSHROOMS) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.m_110463_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.WARPED_FUNGUS) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.m_110463_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.CRIMSON_FUNGUS) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.m_110463_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.WARPED_ROOTS) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.m_110463_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.CRIMSON_ROOTS) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.m_110463_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.NETHER_SPROUTS) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.m_110463_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.LILY_PAD) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.m_110463_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.REDSTONE_TORCHES) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.m_110463_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlocks.REDSTONE_WALL_TORCHES) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.m_110463_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.COBWEBS) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.m_110463_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.TORCHES) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.m_110463_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlocks.WALL_TORCHES) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.m_110463_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.LANTERNS) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.m_110463_());
        }
        for (RegistryObject<VineBlock> registryObject : ChippedBlockTypes.SOUL_LANTERNS) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.m_110463_());
        }
    }

    @SubscribeEvent
    public void onClientSetupEvent(FMLClientSetupEvent event) {
        for (MenuType container : ChippedContainerType.CONTAINER.getEntries().stream().map(RegistryObject::get).toList()) {
            MenuScreens.m_96206_((MenuType)container, ChippedScreen::new);
        }
    }

    public static int getTorchAngleFromDir(Direction direction) {
        return switch (direction) {
            case Direction.WEST -> 180;
            case Direction.NORTH -> 270;
            case Direction.SOUTH -> 90;
            default -> 0;
        };
    }

    public static int getAngleFromDir(Direction direction) {
        return switch (direction) {
            case Direction.WEST -> 270;
            case Direction.SOUTH -> 180;
            case Direction.EAST -> 90;
            default -> 0;
        };
    }
}

