/*
 * Decompiled with CFR 0.152.
 */
package com.grimbo.chipped.block;

import com.grimbo.chipped.Chipped;
import com.grimbo.chipped.api.BenchType;
import com.grimbo.chipped.api.BlockRegistry;
import com.grimbo.chipped.api.ChippedBlockType;
import com.grimbo.chipped.api.ChippedWoodType;
import com.grimbo.chipped.block.ChippedBlockTypes;
import com.grimbo.chipped.block.ChippedLantern;
import com.grimbo.chipped.block.ChippedWorkbench;
import com.grimbo.chipped.container.ChippedContainer;
import com.grimbo.chipped.container.ChippedContainerType;
import com.grimbo.chipped.item.ChippedItems;
import com.grimbo.chipped.recipe.ChippedSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.WaterLilyBlockItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.CryingObsidianBlock;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.HayBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.MelonBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.NetherSproutsBlock;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.RootsBlock;
import net.minecraft.world.level.block.SoulSandBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ChippedBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"chipped");
    private static final BlockBehaviour.Properties LANTERN_PROPERTIES = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50681_);
    private static final BlockBehaviour.StatePredicate ALWAYS_FALSE_POSITION = (state, world, position) -> false;
    private static final BlockBehaviour.StateArgumentPredicate<EntityType<?>> VALID_SPAWN = (state, world, position, type) -> false;
    public static final List<RegistryObject<WallTorchBlock>> WALL_TORCHES = new ArrayList<RegistryObject<WallTorchBlock>>();
    public static final List<RegistryObject<RedstoneWallTorchBlock>> REDSTONE_WALL_TORCHES = new ArrayList<RegistryObject<RedstoneWallTorchBlock>>();
    public static final List<RegistryObject<CarvedPumpkinBlock>> SPECIAL_CARVED_PUMPKINS = new ArrayList<RegistryObject<CarvedPumpkinBlock>>();
    public static final List<RegistryObject<CarvedPumpkinBlock>> VANILLA_CARVED_PUMPKINS = new ArrayList<RegistryObject<CarvedPumpkinBlock>>();
    public static final List<ChippedBlockType<Block>> stones18 = Stream.of("granite", "diorite", "andesite", "prismarine", "dark_prismarine", "purpur_block", "quartz_block", "sandstone", "red_sandstone", "nether_bricks", "red_nether_bricks").map(ChippedBlockType::new).collect(Collectors.toList());
    public static final String[] specialPumpkinList = new String[]{"end", "end2", "nether"};
    public static final String[] carvedPumpkinList = new String[]{"happy", "angry", "bigeyes", "bighappy", "boo", "bruh", "classic", "enthusiastic", "grinning", "kawaii", "mourn", "owo", "plotting", "sans", "scared", "smallhappy", "squashy", "stretchy", "upsidedown"};
    public static final RegistryObject<Block> BOTANIST_WORKBENCH = ChippedBlocks.register("botanist_workbench", () -> new ChippedWorkbench((id, inv, pos) -> new ChippedContainer(id, inv, pos, (MenuType<ChippedContainer>)((MenuType)ChippedContainerType.BOTANIST_WORKBENCH.get()), ChippedSerializer.BOTANIST_WORKBENCH_TYPE, (Block)BOTANIST_WORKBENCH.get()), BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(2.5f).m_60918_(SoundType.f_56736_).m_60955_().m_60922_(VALID_SPAWN).m_60924_(ALWAYS_FALSE_POSITION).m_60960_(ALWAYS_FALSE_POSITION).m_60971_(ALWAYS_FALSE_POSITION)));
    public static final RegistryObject<Block> GLASSBLOWER = ChippedBlocks.register("glassblower", () -> new ChippedWorkbench((id, inv, pos) -> new ChippedContainer(id, inv, pos, (MenuType<ChippedContainer>)((MenuType)ChippedContainerType.GLASSBLOWER.get()), ChippedSerializer.GLASSBLOWER_TYPE, (Block)GLASSBLOWER.get()), BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(2.5f).m_60918_(SoundType.f_56736_).m_60955_().m_60922_(VALID_SPAWN).m_60924_(ALWAYS_FALSE_POSITION).m_60960_(ALWAYS_FALSE_POSITION).m_60971_(ALWAYS_FALSE_POSITION)));
    public static final RegistryObject<Block> CARPENTERS_TABLE = ChippedBlocks.register("carpenters_table", () -> new ChippedWorkbench((id, inv, pos) -> new ChippedContainer(id, inv, pos, (MenuType<ChippedContainer>)((MenuType)ChippedContainerType.CARPENTERS_TABLE.get()), ChippedSerializer.CARPENTERS_TABLE_TYPE, (Block)CARPENTERS_TABLE.get()), BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(2.5f).m_60918_(SoundType.f_56736_).m_60955_().m_60922_(VALID_SPAWN).m_60924_(ALWAYS_FALSE_POSITION).m_60960_(ALWAYS_FALSE_POSITION).m_60971_(ALWAYS_FALSE_POSITION)));
    public static final RegistryObject<Block> LOOM_TABLE = ChippedBlocks.register("loom_table", () -> new ChippedWorkbench((id, inv, pos) -> new ChippedContainer(id, inv, pos, (MenuType<ChippedContainer>)((MenuType)ChippedContainerType.LOOM_TABLE.get()), ChippedSerializer.LOOM_TABLE_TYPE, (Block)LOOM_TABLE.get()), BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(2.5f).m_60918_(SoundType.f_56736_).m_60955_().m_60922_(VALID_SPAWN).m_60924_(ALWAYS_FALSE_POSITION).m_60960_(ALWAYS_FALSE_POSITION).m_60971_(ALWAYS_FALSE_POSITION)));
    public static final RegistryObject<Block> MASON_TABLE = ChippedBlocks.register("mason_table", () -> new ChippedWorkbench((id, inv, pos) -> new ChippedContainer(id, inv, pos, (MenuType<ChippedContainer>)((MenuType)ChippedContainerType.MASON_TABLE.get()), ChippedSerializer.MASON_TABLE_TYPE, (Block)MASON_TABLE.get()), BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_).m_60955_().m_60922_(VALID_SPAWN).m_60924_(ALWAYS_FALSE_POSITION).m_60960_(ALWAYS_FALSE_POSITION).m_60971_(ALWAYS_FALSE_POSITION).m_60999_()));
    public static final RegistryObject<Block> ALCHEMY_BENCH = ChippedBlocks.register("alchemy_bench", () -> new ChippedWorkbench((id, inv, pos) -> new ChippedContainer(id, inv, pos, (MenuType<ChippedContainer>)((MenuType)ChippedContainerType.ALCHEMY_BENCH.get()), ChippedSerializer.ALCHEMY_BENCH_TYPE, (Block)ALCHEMY_BENCH.get()), BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(2.5f).m_60918_(SoundType.f_56736_).m_60955_().m_60922_(VALID_SPAWN).m_60924_(ALWAYS_FALSE_POSITION).m_60960_(ALWAYS_FALSE_POSITION).m_60971_(ALWAYS_FALSE_POSITION)));
    public static final RegistryObject<Block> MECHANIST_WORKBENCH = ChippedBlocks.register("mechanist_workbench", () -> new ChippedWorkbench((id, inv, pos) -> new ChippedContainer(id, inv, pos, (MenuType<ChippedContainer>)((MenuType)ChippedContainerType.MECHANIST_WORKBENCH.get()), ChippedSerializer.MECHANIST_WORKBENCH_TYPE, (Block)MECHANIST_WORKBENCH.get()), BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(1.0f, 2.0f).m_60918_(SoundType.f_56736_).m_60955_().m_60922_(VALID_SPAWN).m_60924_(ALWAYS_FALSE_POSITION).m_60960_(ALWAYS_FALSE_POSITION).m_60971_(ALWAYS_FALSE_POSITION)));

    public static void register() {
        int i;
        RegistryObject<LanternBlock> lantern;
        for (ChippedBlockType<Block> type : stones18) {
            ChippedBlocks.registerVanillaBlocks(BenchType.MASON, type, 18);
        }
        ChippedBlocks.registerVanillaBlocks(BenchType.MASON, ChippedBlockTypes.STONE, 18);
        ChippedBlocks.registerVanillaBlocks(BenchType.MASON, ChippedBlockTypes.COBBLESTONE, 18);
        ChippedBlocks.registerVanillaBlocks(BenchType.MASON, ChippedBlockTypes.END_STONE, 18);
        ChippedBlocks.registerVanillaBlocks(BenchType.MASON, ChippedBlockTypes.NETHERRACK, 18);
        ChippedBlocks.registerVanillaBlocks(BenchType.MASON, Blocks.f_50706_, ChippedBlockTypes.GILDED_BLACKSTONES, 26);
        ChippedBlocks.registerVanillaBlocks(BenchType.MASON, Blocks.f_50730_, ChippedBlockTypes.BLACKSTONES, 21);
        ChippedBlocks.registerVanillaBlocks(BenchType.MASON, Blocks.f_50137_, ChippedBlockTypes.BASALTS, 20);
        for (int id = 0; id < 16; ++id) {
            DyeColor color = DyeColor.m_41053_((int)id);
            ChippedBlocks.registerVanillaBlocks(BenchType.MASON, ChippedBlockTypes.TERRACOTTAS.computeIfAbsent(color, k -> new ChippedBlockType(k + "_terracotta")), 18);
            ChippedBlocks.registerVanillaBlocks(BenchType.MASON, ChippedBlockTypes.CONCRETES.computeIfAbsent(color, k -> new ChippedBlockType(k + "_concrete")), 18);
        }
        ChippedBlocks.registerVanillaBlocks(BenchType.ALCHEMY, Blocks.f_50080_, ChippedBlockTypes.OBSIDIAN, 20);
        BlockBehaviour.Properties CRYING_OBSIDIAN_PROPERTIES = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50723_);
        ChippedBlocks.registerBlocks(BenchType.ALCHEMY, ChippedBlockTypes.CRYING_OBSIDIAN, () -> new CryingObsidianBlock(CRYING_OBSIDIAN_PROPERTIES), 20);
        ChippedBlocks.registerVanillaBlocks(BenchType.ALCHEMY, Blocks.f_50141_, ChippedBlockTypes.GLOWSTONES, 20);
        ChippedBlocks.registerVanillaBlocks(BenchType.ALCHEMY, Blocks.f_50386_, ChippedBlockTypes.SEA_LANTERNS, 16);
        ChippedBlocks.registerVanillaBlocks(BenchType.BOTANIST, Blocks.f_50701_, ChippedBlockTypes.SHROOMLIGHTS, 16);
        BlockBehaviour.Properties REDSTONE_LAMP_PROPERTIES = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50261_);
        ChippedBlocks.registerBlocks(BenchType.MECHANIST, ChippedBlockTypes.REDSTONE_LAMPS, () -> new RedstoneLampBlock(REDSTONE_LAMP_PROPERTIES), 18);
        BlockBehaviour.Properties WOOL_PROPERTIES = BlockBehaviour.Properties.m_60939_((Material)Material.f_76272_).m_60978_(0.1f).m_60918_(SoundType.f_56745_);
        for (int id = 0; id < 16; ++id) {
            DyeColor color = DyeColor.m_41053_((int)id);
            ChippedBlocks.registerVanillaBlocks(BenchType.LOOM, ChippedBlockTypes.WOOL.computeIfAbsent(color, k -> new ChippedBlockType(k + "_wool")), 18);
            ChippedBlocks.registerBlocks(BenchType.LOOM, ChippedBlockTypes.CARPETS.computeIfAbsent(color, k -> new ChippedBlockType(k + "_carpet")), () -> new WoolCarpetBlock(color, WOOL_PROPERTIES), 18);
        }
        BlockBehaviour.Properties GLASS_PROPERTIES = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_);
        BlockBehaviour.Properties GLASS_PANE_PROPERTIES = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50185_);
        ChippedBlocks.registerBlocks(BenchType.GLASSBLOWER, ChippedBlockTypes.GLASSES, () -> new GlassBlock(GLASS_PROPERTIES), 14);
        ChippedBlocks.registerBlocks(BenchType.GLASSBLOWER, ChippedBlockTypes.GLASS_PANES, () -> new IronBarsBlock(GLASS_PANE_PROPERTIES), 14);
        for (ChippedWoodType type : ChippedWoodType.VALUES) {
            ChippedBlocks.registerBlocks(BenchType.GLASSBLOWER, ChippedBlockTypes.GLASSES, type + "_wood_glass", () -> new GlassBlock(GLASS_PROPERTIES), 6);
            ChippedBlocks.registerBlocks(BenchType.GLASSBLOWER, ChippedBlockTypes.GLASS_PANES, type + "_wood_glass_pane", () -> new IronBarsBlock(GLASS_PANE_PROPERTIES), 6);
        }
        for (int id = 0; id < 16; ++id) {
            DyeColor color = DyeColor.m_41053_((int)id);
            ChippedBlocks.registerBlocks(BenchType.GLASSBLOWER, ChippedBlockTypes.STAINED_GLASSES.computeIfAbsent(color, k -> new ChippedBlockType(k + "_stained_glass")), () -> new StainedGlassBlock(color, GLASS_PROPERTIES), 8);
            ChippedBlocks.registerBlocks(BenchType.GLASSBLOWER, ChippedBlockTypes.STAINED_GLASS_PANES.computeIfAbsent(color, k -> new ChippedBlockType(k + "_stained_glass_pane")), () -> new StainedGlassPaneBlock(color, GLASS_PANE_PROPERTIES), 8);
        }
        ChippedBlocks.registerVanillaBlocks(BenchType.MASON, Blocks.f_50129_, ChippedBlockTypes.CLAYS, 19);
        ChippedBlocks.registerVanillaBlocks(BenchType.BOTANIST, Blocks.f_50577_, ChippedBlockTypes.DRIED_KELP_BLOCKS, 12);
        BlockBehaviour.Properties woodProperties = BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_);
        for (ChippedWoodType type : ChippedWoodType.VALUES) {
            ChippedBlocks.registerBlocks(BenchType.CARPENTERS, ChippedBlockTypes.PLANKS.computeIfAbsent(type, k -> new ChippedBlockType(k + "_planks")), () -> new Block(woodProperties), 18);
        }
        BlockBehaviour.Properties hayProperties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50335_);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.HAY_BLOCKS, () -> new HayBlock(hayProperties), 8);
        BlockBehaviour.Properties melonProperties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50186_);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.MELONS, () -> new MelonBlock(melonProperties), 10);
        BlockBehaviour.Properties vineProperties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50191_);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.VINES, () -> new VineBlock(vineProperties), 17);
        BlockBehaviour.Properties brownMushroomProperties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50072_);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.BROWN_MUSHROOMS, () -> new MushroomBlock(brownMushroomProperties, () -> TreeFeatures.f_195121_), 15);
        BlockBehaviour.Properties redMushroomProperties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50073_);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.RED_MUSHROOMS, () -> new MushroomBlock(redMushroomProperties, () -> TreeFeatures.f_195122_), 15);
        BlockBehaviour.Properties warpedFungusProperties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50691_);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.WARPED_FUNGUS, () -> new MushroomBlock(warpedFungusProperties, () -> TreeFeatures.f_195120_), 14);
        BlockBehaviour.Properties crimsonFungusProperties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50700_);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.CRIMSON_FUNGUS, () -> new MushroomBlock(crimsonFungusProperties, () -> TreeFeatures.f_195118_), 15);
        BlockBehaviour.Properties warpedRootsProperties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50693_);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.WARPED_ROOTS, () -> new RootsBlock(warpedRootsProperties), 9);
        BlockBehaviour.Properties crimsonRootsProperties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50654_);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.CRIMSON_ROOTS, () -> new RootsBlock(crimsonRootsProperties), 14);
        BlockBehaviour.Properties netherSproutsProperties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50694_);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.NETHER_SPROUTS, () -> new NetherSproutsBlock(netherSproutsProperties), 20);
        BlockBehaviour.Properties brownMushroomBlockProperties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50180_);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.BROWN_MUSHROOM_BLOCK, () -> new HugeMushroomBlock(brownMushroomBlockProperties), 24);
        BlockBehaviour.Properties redMushroomBlockProperties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50181_);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.RED_MUSHROOM_BLOCK, () -> new HugeMushroomBlock(redMushroomBlockProperties), 15);
        ChippedBlocks.registerVanillaBlocks(BenchType.BOTANIST, ChippedBlockTypes.WARPED_WART_BLOCK, 14);
        ChippedBlocks.registerVanillaBlocks(BenchType.BOTANIST, ChippedBlockTypes.NETHER_WART_BLOCK, 13);
        BlockBehaviour.Properties cobwebProperties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50033_).m_60913_(0.26666668f, 4.0f);
        ChippedBlocks.registerBlocks(BenchType.BOTANIST, ChippedBlockTypes.COBWEBS, () -> new WebBlock(cobwebProperties), 10);
        BlockBehaviour.Properties soulSandProperties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50135_);
        ChippedBlocks.registerBlocks(BenchType.ALCHEMY, ChippedBlockTypes.SOUL_SANDS, () -> new SoulSandBlock(soulSandProperties), 11);
        BlockBehaviour.Properties lilyPadProperties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50196_);
        for (int i2 = 1; i2 <= 6; ++i2) {
            String name = ChippedBlockTypes.LILY_PAD.getId() + "_" + i2;
            RegistryObject lilyPad = BLOCKS.register(name, () -> new WaterlilyBlock(lilyPadProperties){

                public PlantType getPlantType(BlockGetter world, BlockPos pos) {
                    return PlantType.WATER;
                }
            });
            BlockRegistry.addBlock(BenchType.BOTANIST, ChippedBlockTypes.LILY_PAD, lilyPad);
            ChippedItems.ITEMS.register(name, () -> new WaterLilyBlockItem((Block)lilyPad.get(), new Item.Properties().m_41491_(Chipped.CHIPPED)));
        }
        VoxelShape CHONK_LANTERN_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0), (VoxelShape)Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0));
        VoxelShape THICC_LANTERN_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0), (VoxelShape)Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0));
        VoxelShape DONUT_LANTERN_SHAPE_EAST = Block.m_49796_((double)5.0, (double)0.0, (double)1.0, (double)11.0, (double)15.0, (double)15.0);
        VoxelShape DONUT_LANTERN_SHAPE_NORTH = Block.m_49796_((double)1.0, (double)0.0, (double)5.0, (double)15.0, (double)15.0, (double)11.0);
        VoxelShape TALL_LANTERN_SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0);
        VoxelShape HANGING_WOOD_LANTERN = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0), Block.m_49796_((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), Block.m_49796_((double)5.0, (double)13.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0)});
        VoxelShape WOOD_LANTERN = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)11.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), Block.m_49796_((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0)});
        VoxelShape HANGING_JAR_LANTERN = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)7.0, (double)11.0, (double)7.0, (double)9.0, (double)12.0, (double)9.0), (VoxelShape)Block.m_49796_((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0));
        VoxelShape JAR_LANTERN = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)7.0, (double)6.0, (double)7.0, (double)9.0, (double)7.0, (double)9.0), (VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0));
        VoxelShape HANGING_PAPER_LANTERN = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)4.0, (double)5.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0), Block.m_49796_((double)5.0, (double)14.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0)});
        VoxelShape PAPER_LANTERN = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0), Block.m_49796_((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0)});
        VoxelShape HANGING_PAPER_LANTERN_2 = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)4.0, (double)9.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0), Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0), Block.m_49796_((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.m_49796_((double)5.0, (double)15.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), Block.m_49796_((double)5.0, (double)8.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0)});
        VoxelShape PAPER_LANTERN_2 = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0), Block.m_49796_((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0)});
        for (int i3 : new int[]{1, 3, 4}) {
            lantern = ChippedBlocks.register("lantern_" + i3, () -> new LanternBlock(LANTERN_PROPERTIES));
            BlockRegistry.addGenericBlock(BenchType.MECHANIST, ChippedBlockTypes.LANTERNS, lantern);
        }
        ChippedBlocks.registerSpecialLantern(ChippedBlockTypes.LANTERNS, HANGING_WOOD_LANTERN, WOOD_LANTERN, 2);
        ChippedBlocks.registerSpecialLantern(ChippedBlockTypes.LANTERNS, HANGING_JAR_LANTERN, JAR_LANTERN, 6);
        ChippedBlocks.registerSpecialLantern(ChippedBlockTypes.LANTERNS, HANGING_PAPER_LANTERN, PAPER_LANTERN, 9, 10, 11, 12, 13, 14);
        for (int i3 : new int[]{1, 3}) {
            lantern = ChippedBlocks.register("soul_lantern_" + i3, () -> new LanternBlock(LANTERN_PROPERTIES));
            BlockRegistry.addGenericBlock(BenchType.MECHANIST, ChippedBlockTypes.SOUL_LANTERNS, lantern);
        }
        ChippedBlocks.registerSpecialLantern(ChippedBlockTypes.SOUL_LANTERNS, HANGING_WOOD_LANTERN, WOOD_LANTERN, 2);
        ChippedBlocks.registerSpecialLantern(ChippedBlockTypes.SOUL_LANTERNS, HANGING_JAR_LANTERN, JAR_LANTERN, 5);
        ChippedBlocks.registerSpecialLantern(ChippedBlockTypes.SOUL_LANTERNS, HANGING_PAPER_LANTERN_2, PAPER_LANTERN_2, 6, 7, 8, 9, 10, 11);
        RegistryObject<ChippedLantern> lantern1 = ChippedBlocks.register("special_lantern_1", () -> new ChippedLantern(LANTERN_PROPERTIES, CHONK_LANTERN_SHAPE));
        RegistryObject<ChippedLantern> lantern2 = ChippedBlocks.register("special_lantern_2", () -> new ChippedLantern(LANTERN_PROPERTIES, DONUT_LANTERN_SHAPE_EAST, DONUT_LANTERN_SHAPE_NORTH));
        RegistryObject<ChippedLantern> lantern3 = ChippedBlocks.register("special_lantern_3", () -> new ChippedLantern(LANTERN_PROPERTIES, TALL_LANTERN_SHAPE));
        RegistryObject<ChippedLantern> lantern4 = ChippedBlocks.register("special_lantern_4", () -> new ChippedLantern(LANTERN_PROPERTIES, THICC_LANTERN_SHAPE));
        BlockRegistry.addGenericBlock(BenchType.MECHANIST, ChippedBlockTypes.LANTERNS, lantern1);
        BlockRegistry.addGenericBlock(BenchType.MECHANIST, ChippedBlockTypes.LANTERNS, lantern2);
        BlockRegistry.addGenericBlock(BenchType.MECHANIST, ChippedBlockTypes.LANTERNS, lantern3);
        BlockRegistry.addGenericBlock(BenchType.MECHANIST, ChippedBlockTypes.LANTERNS, lantern4);
        RegistryObject<ChippedLantern> soulLantern1 = ChippedBlocks.register("special_soul_lantern_1", () -> new ChippedLantern(LANTERN_PROPERTIES, CHONK_LANTERN_SHAPE));
        RegistryObject<ChippedLantern> soulLantern2 = ChippedBlocks.register("special_soul_lantern_2", () -> new ChippedLantern(LANTERN_PROPERTIES, DONUT_LANTERN_SHAPE_EAST, DONUT_LANTERN_SHAPE_NORTH));
        RegistryObject<ChippedLantern> soulLantern3 = ChippedBlocks.register("special_soul_lantern_3", () -> new ChippedLantern(LANTERN_PROPERTIES, TALL_LANTERN_SHAPE));
        RegistryObject<ChippedLantern> soulLantern4 = ChippedBlocks.register("special_soul_lantern_4", () -> new ChippedLantern(LANTERN_PROPERTIES, THICC_LANTERN_SHAPE));
        BlockRegistry.addGenericBlock(BenchType.MECHANIST, ChippedBlockTypes.SOUL_LANTERNS, soulLantern1);
        BlockRegistry.addGenericBlock(BenchType.MECHANIST, ChippedBlockTypes.SOUL_LANTERNS, soulLantern2);
        BlockRegistry.addGenericBlock(BenchType.MECHANIST, ChippedBlockTypes.SOUL_LANTERNS, soulLantern3);
        BlockRegistry.addGenericBlock(BenchType.MECHANIST, ChippedBlockTypes.SOUL_LANTERNS, soulLantern4);
        BlockBehaviour.Properties REDSTONE_TORCH_PROPERTIES = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50174_);
        BlockBehaviour.Properties REDSTONE_WALL_TORCH_PROPERTIES = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50123_);
        for (int i4 = 2; i4 <= 6; ++i4) {
            RegistryObject redstoneWallTorch = BLOCKS.register("redstone_wall_torch_" + i4, () -> new RedstoneWallTorchBlock(REDSTONE_WALL_TORCH_PROPERTIES));
            RegistryObject redstoneTorch = BLOCKS.register("redstone_torch_" + i4, () -> new RedstoneTorchBlock(REDSTONE_TORCH_PROPERTIES));
            ChippedItems.ITEMS.register("redstone_torch_" + i4, () -> new StandingAndWallBlockItem((Block)redstoneTorch.get(), (Block)redstoneWallTorch.get(), new Item.Properties().m_41491_(Chipped.CHIPPED)));
            BlockRegistry.addBlock(BenchType.MECHANIST, ChippedBlockTypes.REDSTONE_TORCHES, redstoneTorch);
            REDSTONE_WALL_TORCHES.add((RegistryObject<RedstoneWallTorchBlock>)redstoneWallTorch);
        }
        BlockBehaviour.Properties TORCH_PROPERTIES = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50081_);
        BlockBehaviour.Properties WALL_TORCH_PROPERTIES = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50082_);
        for (int i5 = 1; i5 <= 9; ++i5) {
            RegistryObject wallTorch = BLOCKS.register("wall_torch_" + i5, () -> new WallTorchBlock(TORCH_PROPERTIES, (ParticleOptions)ParticleTypes.f_123744_));
            RegistryObject torch = BLOCKS.register("torch_" + i5, () -> new TorchBlock(WALL_TORCH_PROPERTIES, (ParticleOptions)ParticleTypes.f_123744_));
            ChippedItems.ITEMS.register("torch_" + i5, () -> new StandingAndWallBlockItem((Block)torch.get(), (Block)wallTorch.get(), new Item.Properties().m_41491_(Chipped.CHIPPED)));
            BlockRegistry.addBlock(BenchType.CARPENTERS, ChippedBlockTypes.TORCHES, torch);
            WALL_TORCHES.add((RegistryObject<WallTorchBlock>)wallTorch);
        }
        BlockBehaviour.Properties PUMPKIN_PROPERTIES = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50143_);
        BlockBehaviour.Properties JACK_O_LANTERN_PROPERTIES = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50144_);
        for (RegistryObject pumpkin : specialPumpkinList) {
            RegistryObject<PumpkinBlock> pumpkinBlock = ChippedBlocks.register("pumpkin_" + (String)pumpkin, () -> new PumpkinBlock(PUMPKIN_PROPERTIES));
            RegistryObject<CarvedPumpkinBlock> jackOLanternBlock = ChippedBlocks.register("jack_o_lantern_" + (String)pumpkin, () -> new CarvedPumpkinBlock(JACK_O_LANTERN_PROPERTIES));
            RegistryObject<CarvedPumpkinBlock> carvedPumpkinBlock = ChippedBlocks.register("carved_pumpkin_" + (String)pumpkin, () -> new CarvedPumpkinBlock(PUMPKIN_PROPERTIES));
            BlockRegistry.addBlock(BenchType.BOTANIST, ChippedBlockTypes.JACK_O_LANTERNS, jackOLanternBlock);
            BlockRegistry.addBlock(BenchType.BOTANIST, ChippedBlockTypes.CARVED_PUMPKINS, carvedPumpkinBlock);
            BlockRegistry.addBlock(BenchType.BOTANIST, ChippedBlockTypes.PUMPKINS, pumpkinBlock);
            SPECIAL_CARVED_PUMPKINS.add(jackOLanternBlock);
            SPECIAL_CARVED_PUMPKINS.add(carvedPumpkinBlock);
        }
        for (i = 1; i <= 13; ++i) {
            RegistryObject<PumpkinBlock> pumpkinBlock = ChippedBlocks.register("pumpkin_" + i, () -> new PumpkinBlock(PUMPKIN_PROPERTIES));
            BlockRegistry.addBlock(BenchType.BOTANIST, ChippedBlockTypes.PUMPKINS, pumpkinBlock);
        }
        for (i = 1; i <= carvedPumpkinList.length; ++i) {
            RegistryObject<CarvedPumpkinBlock> jackOLanternBlock = ChippedBlocks.register("jack_o_lantern_" + i, () -> new CarvedPumpkinBlock(JACK_O_LANTERN_PROPERTIES));
            RegistryObject<CarvedPumpkinBlock> carvedPumpkinBlock = ChippedBlocks.register("carved_pumpkin_" + i, () -> new CarvedPumpkinBlock(PUMPKIN_PROPERTIES));
            BlockRegistry.addBlock(BenchType.BOTANIST, ChippedBlockTypes.JACK_O_LANTERNS, jackOLanternBlock);
            BlockRegistry.addBlock(BenchType.BOTANIST, ChippedBlockTypes.CARVED_PUMPKINS, carvedPumpkinBlock);
            VANILLA_CARVED_PUMPKINS.add(carvedPumpkinBlock);
            VANILLA_CARVED_PUMPKINS.add(jackOLanternBlock);
        }
    }

    private static void registerSpecialLantern(ChippedBlockType<Block> list, final VoxelShape hangingShape, final VoxelShape normalShape, int ... indices) {
        for (int i : indices) {
            RegistryObject<LanternBlock> lantern = ChippedBlocks.register(list.getId() + "_" + i, () -> new LanternBlock(LANTERN_PROPERTIES){

                @NotNull
                public VoxelShape m_5940_(@NotNull BlockState blockState, @NotNull BlockGetter blockReader, @NotNull BlockPos pos, @NotNull CollisionContext selectionContext) {
                    return (Boolean)blockState.m_61143_((Property)f_153459_) != false ? hangingShape : normalShape;
                }
            });
            BlockRegistry.addGenericBlock(BenchType.MECHANIST, list, lantern);
        }
    }

    private static void registerVanillaBlocks(BenchType bench, ChippedBlockType<Block> type, int count) {
        ChippedBlocks.registerVanillaBlocks(bench, (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("minecraft", type.getId())), type, count);
    }

    private static void registerVanillaBlocks(BenchType bench, Block vanillaBlock, ChippedBlockType<Block> type, int count) {
        ChippedBlocks.registerBlocks(bench, type, () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)vanillaBlock)), count);
    }

    private static <T extends Block> void registerBlocks(BenchType bench, ChippedBlockType<T> type, Supplier<T> block, int count) {
        ChippedBlocks.registerBlocks(bench, type, type.getId(), block, count);
    }

    private static <T extends Block> void registerBlocks(BenchType bench, ChippedBlockType<T> type, String name, Supplier<T> block, int count) {
        for (int i = 1; i <= count; ++i) {
            BlockRegistry.addBlock(bench, type, ChippedBlocks.register(name + "_" + i, block));
        }
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ChippedItems.ITEMS.register(name, () -> new BlockItem((Block)toReturn.get(), new Item.Properties().m_41491_(Chipped.CHIPPED)));
        return toReturn;
    }
}

