/*
 * Decompiled with CFR 0.152.
 */
package com.grimbo.chipped.integration.jei;

import com.grimbo.chipped.block.ChippedBlocks;
import com.grimbo.chipped.integration.jei.ChippedRecipeCategory;
import com.grimbo.chipped.recipe.ChippedRecipe;
import com.grimbo.chipped.recipe.ChippedSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("chipped", "chipped");

    @NotNull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper helper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new ChippedRecipeCategory(((Block)ChippedBlocks.BOTANIST_WORKBENCH.get()).m_5456_(), helper), new ChippedRecipeCategory(((Block)ChippedBlocks.GLASSBLOWER.get()).m_5456_(), helper), new ChippedRecipeCategory(((Block)ChippedBlocks.CARPENTERS_TABLE.get()).m_5456_(), helper), new ChippedRecipeCategory(((Block)ChippedBlocks.LOOM_TABLE.get()).m_5456_(), helper), new ChippedRecipeCategory(((Block)ChippedBlocks.MASON_TABLE.get()).m_5456_(), helper), new ChippedRecipeCategory(((Block)ChippedBlocks.ALCHEMY_BENCH.get()).m_5456_(), helper), new ChippedRecipeCategory(((Block)ChippedBlocks.MECHANIST_WORKBENCH.get()).m_5456_(), helper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        registration.addRecipes(JEIPlugin.flatten(recipeManager.m_44013_(ChippedSerializer.BOTANIST_WORKBENCH_TYPE)), JEIPlugin.getUidFromId("botanist_workbench"));
        registration.addRecipes(JEIPlugin.flatten(recipeManager.m_44013_(ChippedSerializer.GLASSBLOWER_TYPE)), JEIPlugin.getUidFromId("glassblower"));
        registration.addRecipes(JEIPlugin.flatten(recipeManager.m_44013_(ChippedSerializer.CARPENTERS_TABLE_TYPE)), JEIPlugin.getUidFromId("carpenters_table"));
        registration.addRecipes(JEIPlugin.flatten(recipeManager.m_44013_(ChippedSerializer.LOOM_TABLE_TYPE)), JEIPlugin.getUidFromId("loom_table"));
        registration.addRecipes(JEIPlugin.flatten(recipeManager.m_44013_(ChippedSerializer.MASON_TABLE_TYPE)), JEIPlugin.getUidFromId("mason_table"));
        registration.addRecipes(JEIPlugin.flatten(recipeManager.m_44013_(ChippedSerializer.ALCHEMY_BENCH_TYPE)), JEIPlugin.getUidFromId("alchemy_bench"));
        registration.addRecipes(JEIPlugin.flatten(recipeManager.m_44013_(ChippedSerializer.MECHANIST_WORKBENCH_TYPE)), JEIPlugin.getUidFromId("mechanist_workbench"));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ChippedBlocks.BOTANIST_WORKBENCH.get()), new ResourceLocation[]{JEIPlugin.getUidFromId("botanist_workbench")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ChippedBlocks.GLASSBLOWER.get()), new ResourceLocation[]{JEIPlugin.getUidFromId("glassblower")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ChippedBlocks.CARPENTERS_TABLE.get()), new ResourceLocation[]{JEIPlugin.getUidFromId("carpenters_table")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ChippedBlocks.LOOM_TABLE.get()), new ResourceLocation[]{JEIPlugin.getUidFromId("loom_table")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ChippedBlocks.MASON_TABLE.get()), new ResourceLocation[]{JEIPlugin.getUidFromId("mason_table")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ChippedBlocks.ALCHEMY_BENCH.get()), new ResourceLocation[]{JEIPlugin.getUidFromId("alchemy_bench")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ChippedBlocks.MECHANIST_WORKBENCH.get()), new ResourceLocation[]{JEIPlugin.getUidFromId("mechanist_workbench")});
    }

    private static List<ChippedRecipeCategory.FlattenedRecipe> flatten(Collection<ChippedRecipe> recipes) {
        ArrayList<ChippedRecipeCategory.FlattenedRecipe> flattenedRecipes = new ArrayList<ChippedRecipeCategory.FlattenedRecipe>();
        for (ChippedRecipe recipe : recipes) {
            for (Tag<Item> tag : recipe.getTags()) {
                for (Item item : tag.m_6497_()) {
                    flattenedRecipes.add(new ChippedRecipeCategory.FlattenedRecipe(tag, new ItemStack((ItemLike)item)));
                }
            }
        }
        return flattenedRecipes;
    }

    private static ResourceLocation getUidFromId(String id) {
        return new ResourceLocation("chipped", id);
    }
}

