/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.FloweringLilyPadBlock;
import net.joefoxe.hexerei.block.custom.PickableDoubleFlower;
import net.joefoxe.hexerei.block.custom.PickableFlower;
import net.joefoxe.hexerei.client.renderer.entity.ModEntityTypes;
import net.joefoxe.hexerei.config.HexConfig;
import net.joefoxe.hexerei.config.ModKeyBindings;
import net.joefoxe.hexerei.container.ModContainers;
import net.joefoxe.hexerei.data.recipes.HexereiDataGenerator;
import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.joefoxe.hexerei.events.SageBurningPlateEvent;
import net.joefoxe.hexerei.fluid.ModFluids;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.custom.FlowerOutputItem;
import net.joefoxe.hexerei.particle.ModParticleTypes;
import net.joefoxe.hexerei.screen.BroomScreen;
import net.joefoxe.hexerei.screen.CofferScreen;
import net.joefoxe.hexerei.screen.HerbJarScreen;
import net.joefoxe.hexerei.screen.MixingCauldronScreen;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.ClientProxy;
import net.joefoxe.hexerei.util.HexereiConstants;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.ServerProxy;
import net.joefoxe.hexerei.util.SidedProxy;
import net.joefoxe.hexerei.world.biome.ModBiomes;
import net.joefoxe.hexerei.world.gen.ModBiomeGeneration;
import net.joefoxe.hexerei.world.gen.ModConfiguredStructures;
import net.joefoxe.hexerei.world.gen.ModFeatures;
import net.joefoxe.hexerei.world.processor.DarkCovenLegProcessor;
import net.joefoxe.hexerei.world.processor.MangroveTreeLegProcessor;
import net.joefoxe.hexerei.world.processor.WitchHutLegProcessor;
import net.joefoxe.hexerei.world.structure.ModStructures;
import net.joefoxe.hexerei.world.structure.structures.WitchHutStructure;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="hexerei")
public class Hexerei {
    public static SidedProxy proxy = (SidedProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static final String MOD_ID = "hexerei";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Logger LOGGER = LogManager.getLogger();
    public static final SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)HexereiConstants.CHANNEL_NAME).clientAcceptedVersions(HexereiConstants.PROTOCOL_VERSION::equals).serverAcceptedVersions(HexereiConstants.PROTOCOL_VERSION::equals).networkProtocolVersion(HexereiConstants.PROTOCOL_VERSION::toString).simpleChannel();
    public static StructureProcessorType<WitchHutLegProcessor> WITCH_HUT_LEG_PROCESSOR = () -> WitchHutLegProcessor.CODEC;
    public static StructureProcessorType<DarkCovenLegProcessor> DARK_COVEN_LEG_PROCESSOR = () -> DarkCovenLegProcessor.CODEC;
    public static StructureProcessorType<MangroveTreeLegProcessor> MANGROVE_TREE_LEG_PROCESSOR = () -> MangroveTreeLegProcessor.CODEC;
    private static Method GETCODEC_METHOD;

    public Hexerei() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(HexereiDataGenerator::gatherData);
        eventBus.addGenericListener(RecipeSerializer.class, ModItems::registerRecipeSerializers);
        ModItems.register(eventBus);
        ModBlocks.register(eventBus);
        ModFluids.register(eventBus);
        ModTileEntities.register(eventBus);
        ModContainers.register(eventBus);
        ModRecipeTypes.register(eventBus);
        ModParticleTypes.PARTICLES.register(eventBus);
        ModFeatures.register(eventBus);
        ModStructures.register(eventBus);
        ModBiomes.register(eventBus);
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        ModEntityTypes.register(eventBus);
        eventBus.addListener(this::loadComplete);
        eventBus.addListener(this::setup);
        eventBus.addListener(this::enqueueIMC);
        eventBus.addListener(this::processIMC);
        eventBus.addListener(this::doClientStuff);
        forgeEventBus.addListener(EventPriority.NORMAL, this::addDimensionalSpacing);
        forgeEventBus.addListener(EventPriority.NORMAL, WitchHutStructure::setupStructureSpawns);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)HexConfig.COMMON_CONFIG);
        HexConfig.loadConfig(HexConfig.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("Hexerei-common.toml"));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ModBiomeGeneration.generateBiomes();
            AxeItem.f_150683_ = new ImmutableMap.Builder().putAll(AxeItem.f_150683_).put((Object)((Block)ModBlocks.MAHOGANY_LOG.get()), (Object)((Block)ModBlocks.STRIPPED_MAHOGANY_LOG.get())).put((Object)((Block)ModBlocks.MAHOGANY_WOOD.get()), (Object)((Block)ModBlocks.STRIPPED_MAHOGANY_WOOD.get())).put((Object)((Block)ModBlocks.WILLOW_LOG.get()), (Object)((Block)ModBlocks.STRIPPED_WILLOW_LOG.get())).put((Object)((Block)ModBlocks.WILLOW_WOOD.get()), (Object)((Block)ModBlocks.STRIPPED_WILLOW_WOOD.get())).build();
            ModStructures.setupStructures();
            ModConfiguredStructures.registerConfiguredStructures();
            Registry.m_122965_((Registry)Registry.f_122891_, (ResourceLocation)new ResourceLocation(MOD_ID, "witch_hut_leg_processor"), WITCH_HUT_LEG_PROCESSOR);
            Registry.m_122965_((Registry)Registry.f_122891_, (ResourceLocation)new ResourceLocation(MOD_ID, "dark_coven_leg_processor"), DARK_COVEN_LEG_PROCESSOR);
            Registry.m_122965_((Registry)Registry.f_122891_, (ResourceLocation)new ResourceLocation(MOD_ID, "mangrove_tree_leg_processor"), MANGROVE_TREE_LEG_PROCESSOR);
            HexereiPacketHandler.register();
            ComposterBlock.f_51914_.put((Object)((Block)ModBlocks.WILLOW_VINES.get()).m_5456_(), 0.5f);
            ComposterBlock.f_51914_.put((Object)((LeavesBlock)ModBlocks.WILLOW_LEAVES.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((LeavesBlock)ModBlocks.MAHOGANY_LEAVES.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((SaplingBlock)ModBlocks.WILLOW_SAPLING.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((SaplingBlock)ModBlocks.MAHOGANY_SAPLING.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((PickableFlower)ModBlocks.MANDRAKE_FLOWER.get()).m_5456_(), 1.0f);
            ComposterBlock.f_51914_.put((Object)((PickableFlower)ModBlocks.BELLADONNA_FLOWER.get()).m_5456_(), 1.0f);
            ComposterBlock.f_51914_.put((Object)((PickableDoubleFlower)ModBlocks.MUGWORT_BUSH.get()).m_5456_(), 1.0f);
            ComposterBlock.f_51914_.put((Object)((PickableDoubleFlower)ModBlocks.YELLOW_DOCK_BUSH.get()).m_5456_(), 1.0f);
            ComposterBlock.f_51914_.put((Object)((FloweringLilyPadBlock)ModBlocks.LILY_PAD_BLOCK.get()).m_5456_(), 1.0f);
            ComposterBlock.f_51914_.put((Object)((FlowerOutputItem)ModItems.BELLADONNA_BERRIES.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((FlowerOutputItem)ModItems.BELLADONNA_FLOWERS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((FlowerOutputItem)ModItems.MANDRAKE_FLOWERS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((FlowerOutputItem)ModItems.MANDRAKE_ROOT.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((FlowerOutputItem)ModItems.MUGWORT_FLOWERS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((FlowerOutputItem)ModItems.MUGWORT_LEAVES.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((FlowerOutputItem)ModItems.YELLOW_DOCK_FLOWERS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((FlowerOutputItem)ModItems.YELLOW_DOCK_LEAVES.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Item)ModItems.DRIED_BELLADONNA_FLOWERS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Item)ModItems.DRIED_MANDRAKE_FLOWERS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Item)ModItems.DRIED_MUGWORT_FLOWERS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Item)ModItems.DRIED_MUGWORT_LEAVES.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Item)ModItems.DRIED_YELLOW_DOCK_FLOWERS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Item)ModItems.DRIED_YELLOW_DOCK_LEAVES.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Item)ModItems.SAGE.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Item)ModItems.SAGE_SEED.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Item)ModItems.DRIED_SAGE.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Item)ModItems.TALLOW_IMPURITY.get()).m_5456_(), 0.3f);
        });
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ModKeyBindings.init();
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.QUICKSILVER_FLUID.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.QUICKSILVER_FLOWING.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModFluids.QUICKSILVER_BLOCK.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.BLOOD_FLUID.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.BLOOD_FLOWING.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModFluids.BLOOD_BLOCK.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.TALLOW_FLUID.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.TALLOW_FLOWING.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModFluids.TALLOW_BLOCK.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.MAHOGANY_DOOR.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.MAHOGANY_TRAPDOOR.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.MAHOGANY_TRAPDOOR.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WILLOW_DOOR.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WILLOW_TRAPDOOR.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.MIXING_CAULDRON.get()), (RenderType)RenderType.m_110457_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.CRYSTAL_BALL.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.CRYSTAL_BALL_ORB.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.CRYSTAL_BALL_LARGE_RING.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.CRYSTAL_BALL_SMALL_RING.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.HERB_JAR.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.HERB_DRYING_RACK_FULL.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.HERB_DRYING_RACK.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.MAHOGANY_SAPLING.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WILLOW_SAPLING.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.MANDRAKE_FLOWER.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.BELLADONNA_FLOWER.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.MUGWORT_BUSH.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.YELLOW_DOCK_BUSH.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.CANDELABRA.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SAGE.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LILY_PAD_BLOCK.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WILLOW_VINES.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WILLOW_VINES_PLANT.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SELENITE_BLOCK.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SELENITE_CLUSTER.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.BUDDING_SELENITE.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LARGE_SELENITE_BUD.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.MEDIUM_SELENITE_BUD.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SMALL_SELENITE_BUD.get()), (RenderType)RenderType.m_110466_());
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.MIXING_CAULDRON_CONTAINER.get()), MixingCauldronScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.COFFER_CONTAINER.get()), CofferScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.HERB_JAR_CONTAINER.get()), HerbJarScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.BROOM_CONTAINER.get()), BroomScreen::new);
        });
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)MOD_ID, (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            ChunkGenerator chunkGenerator = serverLevel.m_7726_().m_8481_();
            if (chunkGenerator instanceof FlatLevelSource && serverLevel.m_46472_().equals((Object)Level.f_46428_)) {
                return;
            }
            StructureSettings worldStructureConfig = chunkGenerator.m_62205_();
            HashMap structureToMultiMap = new HashMap();
            HashMap featureToMultiMap = new HashMap();
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                Biome.BiomeCategory biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory != Biome.BiomeCategory.SWAMP) continue;
                Hexerei.associateBiomeToConfiguredStructure(structureToMultiMap, ModConfiguredStructures.CONFIGURED_WITCH_HUT, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
                Hexerei.associateBiomeToConfiguredStructure(structureToMultiMap, ModConfiguredStructures.CONFIGURED_DARK_COVEN, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            ImmutableMap.Builder tempStructureToMultiMap = ImmutableMap.builder();
            worldStructureConfig.f_189361_.entrySet().stream().filter(entry -> !structureToMultiMap.containsKey(entry.getKey())).forEach(arg_0 -> ((ImmutableMap.Builder)tempStructureToMultiMap).put(arg_0));
            structureToMultiMap.forEach((key, value) -> tempStructureToMultiMap.put(key, (Object)ImmutableMultimap.copyOf((Multimap)value)));
            worldStructureConfig.f_189361_ = tempStructureToMultiMap.build();
            try {
                ResourceLocation cgRL;
                if (GETCODEC_METHOD == null) {
                    GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"codec", (Class[])new Class[0]);
                }
                if ((cgRL = Registry.f_122890_.m_7981_((Object)((Codec)GETCODEC_METHOD.invoke((Object)chunkGenerator, new Object[0])))) != null && cgRL.m_135827_().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error("Was unable to check if " + serverLevel.m_46472_().m_135782_() + " is using Terraforged's ChunkGenerator.");
            }
            if (chunkGenerator instanceof FlatLevelSource && serverLevel.m_46472_().equals((Object)Level.f_46428_)) {
                return;
            }
            HashMap<StructureFeature, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(worldStructureConfig.m_64590_());
            tempMap.putIfAbsent((StructureFeature)ModStructures.WITCH_HUT.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)ModStructures.WITCH_HUT.get()));
            worldStructureConfig.f_64582_ = tempMap;
        }
    }

    private static void associateBiomeToConfiguredStructure(Map<StructureFeature<?>, HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>>> structureToMultiMap, ConfiguredStructureFeature<?, ?> configuredStructureFeature, ResourceKey<Biome> biomeRegistryKey) {
        structureToMultiMap.putIfAbsent(configuredStructureFeature.f_65403_, HashMultimap.create());
        HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>> configuredStructureToBiomeMultiMap = structureToMultiMap.get(configuredStructureFeature.f_65403_);
        if (configuredStructureToBiomeMultiMap.containsValue(biomeRegistryKey)) {
            LOGGER.error("    Detected 2 ConfiguredStructureFeatures that share the same base StructureFeature trying to be added to same biome. One will be prevented from spawning.\n    This issue happens with vanilla too and is why a Snowy Village and Plains Village cannot spawn in the same biome because they both use the Village base structure.\n    The two conflicting ConfiguredStructures are: {}, {}\n    The biome that is attempting to be shared: {}\n", (Object)BuiltinRegistries.f_123862_.m_7447_(configuredStructureFeature), (Object)BuiltinRegistries.f_123862_.m_7447_((Object)((ConfiguredStructureFeature)configuredStructureToBiomeMultiMap.entries().stream().filter(e -> e.getValue() == biomeRegistryKey).findFirst().get().getKey())), biomeRegistryKey);
        } else {
            configuredStructureToBiomeMultiMap.put(configuredStructureFeature, biomeRegistryKey);
        }
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new SageBurningPlateEvent());
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            LOGGER.info("HELLO from Register Block");
        }
    }
}

