/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.ITileEntity;
import net.joefoxe.hexerei.container.CofferContainer;
import net.joefoxe.hexerei.tileentity.CofferTile;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public class Coffer
extends BaseEntityBlock
implements ITileEntity<CofferTile>,
EntityBlock,
SimpleWaterloggedBlock {
    public static final IntegerProperty ANGLE = IntegerProperty.m_61631_((String)"angle", (int)0, (int)180);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)4.0, (double)12.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape SHAPE_TURNED = Stream.of(Block.m_49796_((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)4.0, (double)14.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public RenderShape m_7514_(BlockState iBlockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)context.m_8125_())).m_61124_((Property)ANGLE, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        if (p_220053_1_.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST || p_220053_1_.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
            return SHAPE_TURNED;
        }
        return SHAPE;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> entityType) {
        return entityType == ModTileEntities.COFFER_TILE.get() ? (world2, pos, state2, entity) -> ((CofferTile)entity).tick() : null;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(handIn);
        if (!worldIn.m_5776_()) {
            BlockEntity tileEntity = worldIn.m_7702_(pos);
            if (tileEntity instanceof CofferTile) {
                MenuProvider containerProvider = this.createContainerProvider(worldIn, pos);
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, (BlockPos)tileEntity.m_58899_());
            } else {
                throw new IllegalStateException("Our Container provider is missing!");
            }
        }
        return InteractionResult.SUCCESS;
    }

    public Coffer(BlockBehaviour.Properties properties) {
        super(properties.m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HorizontalDirectionalBlock.f_54117_, ANGLE, WATERLOGGED});
    }

    public void setAngle(Level worldIn, BlockPos pos, BlockState state, int angle) {
        worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)ANGLE, (Comparable)Integer.valueOf(Mth.m_14045_((int)angle, (int)0, (int)180))), 2);
    }

    public int getAngle(Level worldIn, BlockPos pos) {
        return (Integer)worldIn.m_8055_(pos).m_61143_((Property)ANGLE);
    }

    public void m_6256_(BlockState state, Level world, BlockPos pos, Player player) {
        if (player instanceof FakePlayer) {
            return;
        }
        if (world instanceof ServerLevel) {
            ItemStack cloneItemStack = this.m_7397_((BlockGetter)world, pos, state);
            world.m_46961_(pos, false);
            if (world.m_8055_(pos) != state && !world.m_5776_()) {
                if (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() == Items.f_41852_) {
                    player.m_21008_(InteractionHand.MAIN_HAND, cloneItemStack);
                } else {
                    player.m_150109_().m_150079_(cloneItemStack);
                }
            }
        }
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        super.onBlockExploded(state, world, pos, explosion);
        if (world instanceof ServerLevel) {
            ItemStack cloneItemStack = this.m_7397_((BlockGetter)world, pos, state);
            if (world.m_8055_(pos) != state && !world.m_5776_()) {
                world.m_7967_((Entity)new ItemEntity(world, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() - 0.5f), (double)((float)pos.m_123343_() + 0.5f), cloneItemStack));
            }
        }
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        Component customName;
        ItemStack item = new ItemStack((ItemLike)this);
        Optional<CofferTile> tileEntityOptional = Optional.ofNullable((CofferTile)this.getBlockEntity(worldIn, pos));
        CompoundTag tag = item.m_41784_();
        CompoundTag inv = tileEntityOptional.map(coffer -> coffer.itemHandler.serializeNBT()).orElse(new CompoundTag());
        ItemStackHandler empty = tileEntityOptional.map(herb_jar -> herb_jar.itemHandler).orElse(new ItemStackHandler(36));
        boolean flag = false;
        for (int i = 0; i < 36; ++i) {
            if (empty.getStackInSlot(i).m_41619_()) continue;
            flag = true;
            break;
        }
        if (flag) {
            tag.m_128365_("Inventory", (Tag)inv);
        }
        if ((customName = (Component)tileEntityOptional.map(CofferTile::m_7770_).orElse(null)) != null && customName.getString().length() > 0) {
            item.m_41714_(customName);
        }
        return item;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (stack.m_41788_()) {
            BlockEntity tileentity = worldIn.m_7702_(pos);
            ((CofferTile)tileentity).customName = stack.m_41786_();
        }
        if (worldIn.m_5776_()) {
            return;
        }
        if (stack == null) {
            return;
        }
        this.withTileEntityDo((BlockGetter)worldIn, pos, te -> te.readInventory(stack.m_41784_().m_128469_("Inventory")));
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag inv = stack.m_41784_().m_128469_("Inventory");
        ListTag tagList = inv.m_128437_("Items", 10);
        if (Screen.m_96638_()) {
            tooltip.add((Component)new TranslatableComponent("<%s>", new Object[]{new TranslatableComponent("tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAA6600)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag itemTags = tagList.m_128728_(i);
                TranslatableComponent itemText2 = (TranslatableComponent)new TranslatableComponent(ItemStack.m_41712_((CompoundTag)itemTags).m_41778_()).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x998800)));
                TranslatableComponent itemText = (TranslatableComponent)new TranslatableComponent(" - %s", new Object[]{itemText2}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999)));
                int countText = ItemStack.m_41712_((CompoundTag)itemTags).m_41613_();
                itemText.m_130946_(" x" + countText);
                tooltip.add((Component)itemText);
            }
            if (tagList.size() < 1) {
                tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.coffer_shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.coffer_shift_2").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.coffer_shift_3").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.coffer_shift_4").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.coffer_shift_5").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            }
        } else {
            tooltip.add((Component)new TranslatableComponent("[%s]", new Object[]{new TranslatableComponent("tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAA00)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            for (int i = 0; i < Math.min(tagList.size(), 3); ++i) {
                CompoundTag itemTags = tagList.m_128728_(i);
                TranslatableComponent itemText2 = (TranslatableComponent)new TranslatableComponent(ItemStack.m_41712_((CompoundTag)itemTags).m_41778_()).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x998800)));
                TranslatableComponent itemText = (TranslatableComponent)new TranslatableComponent(" - %s", new Object[]{itemText2}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999)));
                int countText = ItemStack.m_41712_((CompoundTag)itemTags).m_41613_();
                itemText.m_130946_(" x" + countText);
                tooltip.add((Component)itemText);
            }
            if (tagList.size() > 3) {
                tooltip.add((Component)new TranslatableComponent(". . . ").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            } else if (tagList.size() < 1) {
                tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.coffer").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            }
        }
        super.m_5871_(stack, world, tooltip, flagIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level world, BlockPos pos, Random rand) {
        super.m_7100_(state, world, pos, rand);
    }

    private MenuProvider createContainerProvider(final Level worldIn, final BlockPos pos) {
        return new MenuProvider(){

            @Nullable
            public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                return new CofferContainer(i, worldIn, pos, playerInventory, playerEntity);
            }

            public Component m_5446_() {
                if (((CofferTile)worldIn.m_7702_((BlockPos)pos)).customName != null) {
                    return new TranslatableComponent(((CofferTile)worldIn.m_7702_((BlockPos)pos)).customName.getString());
                }
                return new TranslatableComponent("screen.hexerei.coffer");
            }
        };
    }

    @Override
    public Class<CofferTile> getTileEntityClass() {
        return CofferTile.class;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CofferTile((BlockEntityType)ModTileEntities.COFFER_TILE.get(), pos, state);
    }
}

