/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.ITileEntity;
import net.joefoxe.hexerei.container.HerbJarContainer;
import net.joefoxe.hexerei.items.JarHandler;
import net.joefoxe.hexerei.tileentity.HerbJarTile;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkHooks;

public class HerbJar
extends Block
implements ITileEntity<HerbJarTile>,
EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty HANGING = BlockStateProperties.f_61435_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)5.0, (double)-0.5, (double)5.0, (double)11.0, (double)0.0, (double)11.0), Block.m_49796_((double)5.5, (double)13.0, (double)5.5, (double)10.5, (double)15.0, (double)10.5), Block.m_49796_((double)4.5, (double)12.0, (double)10.5, (double)11.5, (double)14.0, (double)11.5), Block.m_49796_((double)4.5, (double)12.0, (double)4.5, (double)11.5, (double)14.0, (double)5.5), Block.m_49796_((double)4.5, (double)12.0, (double)5.5, (double)5.5, (double)14.0, (double)10.5), Block.m_49796_((double)10.5, (double)12.0, (double)5.5, (double)11.5, (double)14.0, (double)10.5), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0), Block.m_49796_((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public RenderShape m_7514_(BlockState iBlockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate;
            if (direction.m_122434_() != Direction.Axis.Y || !(blockstate = (BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return (BlockState)((BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)context.m_8125_());
        }
        return null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(handIn);
        if (itemstack.m_41619_() && player.m_6144_() || ((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_() != hit.m_82434_()) {
            BlockEntity tileEntity = worldIn.m_7702_(pos);
            if (!worldIn.m_5776_()) {
                if (tileEntity instanceof HerbJarTile) {
                    MenuProvider containerProvider = this.createContainerProvider(worldIn, pos);
                    NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, (BlockPos)tileEntity.m_58899_());
                } else {
                    throw new IllegalStateException("Our Container provider is missing!");
                }
            }
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity instanceof HerbJarTile) {
            ((HerbJarTile)tileEntity).interactPutItems(player);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        ItemStack cloneItemStack = this.m_7397_((BlockGetter)world, pos, state);
        if (!world.m_5776_()) {
            HerbJar.m_49840_((Level)((ServerLevel)world), (BlockPos)pos, (ItemStack)cloneItemStack);
        }
        super.m_5707_(world, pos, state, player);
    }

    protected BlockHitResult rayTraceEyeLevel(Level world, Player player, double length) {
        Vec3 eyePos = player.m_20299_(1.0f);
        Vec3 lookPos = player.m_20252_(1.0f);
        Vec3 endPos = eyePos.m_82520_(lookPos.f_82479_ * length, lookPos.f_82480_ * length, lookPos.f_82481_ * length);
        ClipContext context = new ClipContext(eyePos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
        return world.m_45547_(context);
    }

    public void m_6256_(BlockState state, Level worldIn, BlockPos pos, Player playerIn) {
        BlockHitResult rayResult = this.rayTraceEyeLevel(worldIn, playerIn, playerIn.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_() + 1.0);
        if (rayResult.m_6662_() == HitResult.Type.MISS) {
            return;
        }
        Direction side = rayResult.m_82434_();
        BlockEntity tile = worldIn.m_7702_(pos);
        HerbJarTile herbJarTile = null;
        if (tile instanceof HerbJarTile) {
            herbJarTile = (HerbJarTile)tile;
        }
        if (((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_() != rayResult.m_82434_()) {
            return;
        }
        ItemStack item = playerIn.m_6144_() ? herbJarTile.takeItems(0, herbJarTile.itemHandler.getStackInSlot(0).m_41613_()) : herbJarTile.takeItems(0, 1);
        if (!item.m_41619_()) {
            if (!playerIn.f_36093_.m_36054_(item)) {
                this.dropItemStack(worldIn, pos.m_142300_(side), playerIn, item);
                worldIn.m_7260_(pos, state, state, 3);
            } else {
                worldIn.m_6263_(null, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((worldIn.f_46441_.nextFloat() - worldIn.f_46441_.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
        super.m_6256_(state, worldIn, pos, playerIn);
    }

    private void dropItemStack(Level world, BlockPos pos, Player player, @Nonnull ItemStack stack) {
        ItemEntity entity = new ItemEntity(world, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.3f), (double)((float)pos.m_123343_() + 0.5f), stack);
        Vec3 motion = entity.m_20184_();
        entity.m_5997_(-motion.f_82479_, -motion.f_82480_, -motion.f_82481_);
        world.m_7967_((Entity)entity);
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public HerbJar(BlockBehaviour.Properties properties) {
        super(properties.m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HorizontalDirectionalBlock.f_54117_, HANGING, WATERLOGGED});
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        super.onBlockExploded(state, world, pos, explosion);
        if (world instanceof ServerLevel) {
            ItemStack cloneItemStack = this.m_7397_((BlockGetter)world, pos, state);
            if (world.m_8055_(pos) != state && !world.m_5776_()) {
                world.m_7967_((Entity)new ItemEntity(world, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() - 0.5f), (double)((float)pos.m_123343_() + 0.5f), cloneItemStack));
            }
        }
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag inv = stack.m_41784_().m_128469_("Inventory");
        ListTag tagList = inv.m_128437_("Items", 10);
        if (Screen.m_96638_()) {
            tooltip.add((Component)new TranslatableComponent("<%s>", new Object[]{new TranslatableComponent("tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAA6600)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            if (tagList.size() >= 1) {
                tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.herb_jar_shift_4").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.herb_jar_shift_5").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.herb_jar_shift_6").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            }
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag itemTags = tagList.m_128728_(i);
                itemTags.m_128405_("Count", 1);
                TranslatableComponent itemText2 = (TranslatableComponent)new TranslatableComponent(ItemStack.m_41712_((CompoundTag)itemTags).m_41778_()).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x998800)));
                TranslatableComponent itemText = (TranslatableComponent)new TranslatableComponent(" - %s", new Object[]{itemText2}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999)));
                int countText = Integer.parseInt(String.valueOf(itemTags.m_128423_("ExtendedCount")));
                itemText.m_130946_(" x" + countText);
                tooltip.add((Component)itemText);
            }
            if (tagList.size() < 1) {
                tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.coffer_shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.coffer_shift_2").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.coffer_shift_3").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.herb_jar_shift_4").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.herb_jar_shift_5").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.herb_jar_shift_6").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.herb_jar_shift_7").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            }
        } else {
            tooltip.add((Component)new TranslatableComponent("[%s]", new Object[]{new TranslatableComponent("tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAA00)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            for (int i = 0; i < Math.min(tagList.size(), 1); ++i) {
                CompoundTag itemTags = tagList.m_128728_(i);
                itemTags.m_128405_("Count", 1);
                TranslatableComponent itemText2 = (TranslatableComponent)new TranslatableComponent(ItemStack.m_41712_((CompoundTag)itemTags).m_41778_()).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x998800)));
                TranslatableComponent itemText = (TranslatableComponent)new TranslatableComponent(" - %s", new Object[]{itemText2}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999)));
                int countText = Integer.parseInt(String.valueOf(itemTags.m_128423_("ExtendedCount")));
                itemText.m_130946_(" x" + countText);
                tooltip.add((Component)itemText);
            }
        }
        super.m_5871_(stack, world, tooltip, flagIn);
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        Component customName;
        ItemStack item = new ItemStack((ItemLike)this);
        Optional<HerbJarTile> tileEntityOptional = Optional.ofNullable((HerbJarTile)this.getBlockEntity(worldIn, pos));
        CompoundTag tag = item.m_41784_();
        JarHandler empty = tileEntityOptional.map(herb_jar -> herb_jar.itemHandler).orElse(new JarHandler(1, 1024));
        CompoundTag inv = tileEntityOptional.map(herb_jar -> herb_jar.itemHandler.serializeNBT()).orElse(new CompoundTag());
        if (!empty.getStackInSlot(0).m_41619_()) {
            tag.m_128365_("Inventory", (Tag)inv);
        }
        if ((customName = (Component)tileEntityOptional.map(HerbJarTile::m_7770_).orElse(null)) != null && customName.getString().length() > 0) {
            item.m_41714_(customName);
        }
        return item;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (stack.m_41788_()) {
            BlockEntity tileentity = worldIn.m_7702_(pos);
            ((HerbJarTile)tileentity).customName = stack.m_41786_();
        }
        if (worldIn.m_5776_()) {
            return;
        }
        if (stack == null) {
            return;
        }
        this.withTileEntityDo((BlockGetter)worldIn, pos, te -> te.readInventory(stack.m_41784_().m_128469_("Inventory")));
    }

    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && fluidStateIn.m_76152_() == Fluids.f_76193_) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
            worldIn.m_186469_(pos, fluidStateIn.m_76152_(), fluidStateIn.m_76152_().m_6718_((LevelReader)worldIn));
            return true;
        }
        return false;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.m_60710_((LevelReader)worldIn, currentPos) && !worldIn.m_5776_() && worldIn instanceof ServerLevel) {
            ItemStack cloneItemStack = this.m_7397_((BlockGetter)worldIn, currentPos, stateIn);
            worldIn.m_7967_((Entity)new ItemEntity((Level)((ServerLevel)worldIn).m_6018_(), (double)((float)currentPos.m_123341_() + 0.5f), (double)((float)currentPos.m_123342_() - 0.5f), (double)((float)currentPos.m_123343_() + 0.5f), cloneItemStack));
        }
        return !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction direction = HerbJar.getBlockConnected(state).m_122424_();
        return Block.m_49863_((LevelReader)worldIn, (BlockPos)pos.m_142300_(direction), (Direction)direction.m_122424_());
    }

    protected static Direction getBlockConnected(BlockState state) {
        return (Boolean)state.m_61143_((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level world, BlockPos pos, Random rand) {
    }

    private MenuProvider createContainerProvider(final Level worldIn, final BlockPos pos) {
        return new MenuProvider(){

            @Nullable
            public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                return new HerbJarContainer(i, worldIn, pos, playerInventory, playerEntity);
            }

            public Component m_5446_() {
                if (((HerbJarTile)worldIn.m_7702_((BlockPos)pos)).customName != null) {
                    return new TranslatableComponent(((HerbJarTile)worldIn.m_7702_((BlockPos)pos)).customName.getString());
                }
                return new TranslatableComponent("screen.hexerei.herb_jar");
            }
        };
    }

    @Override
    public Class<HerbJarTile> getTileEntityClass() {
        return HerbJarTile.class;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new HerbJarTile((BlockEntityType)ModTileEntities.HERB_JAR_TILE.get(), pos, state);
    }
}

