/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.joefoxe.hexerei.Hexerei;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HexConfig {
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec.BooleanValue JARS_ONLY_HOLD_HERBS;
    public static ForgeConfigSpec.ConfigValue<Integer> SAGE_BURNING_PLATE_RANGE;
    public static ForgeConfigSpec.ConfigValue<Integer> SAGE_BUNDLE_DURATION;
    public static ForgeConfigSpec.ConfigValue<Integer> WITCH_HUT_SPACING;
    public static ForgeConfigSpec.ConfigValue<Integer> WITCH_HUT_SEPARATION;
    public static ForgeConfigSpec.ConfigValue<Integer> DARK_COVEN_SPACING;
    public static ForgeConfigSpec.ConfigValue<Integer> DARK_COVEN_SEPARATION;
    public static ForgeConfigSpec.ConfigValue<Integer> BROOM_BRUSH_DURABILITY;
    public static ForgeConfigSpec.ConfigValue<Integer> ENHANCED_BROOM_BRUSH_DURABILITY;
    public static ForgeConfigSpec.ConfigValue<Integer> BROOM_NETHERITE_TIP_DURABILITY;
    public static ForgeConfigSpec.ConfigValue<Integer> BROOM_WATERPROOF_TIP_DURABILITY;

    public static void refreshServer() {
        Hexerei.LOGGER.debug("Refreshing Server Config");
        JARS_ONLY_HOLD_HERBS.get();
        SAGE_BURNING_PLATE_RANGE.get();
        SAGE_BUNDLE_DURATION.get();
        WITCH_HUT_SPACING.get();
        WITCH_HUT_SEPARATION.get();
        DARK_COVEN_SPACING.get();
        DARK_COVEN_SEPARATION.get();
        BROOM_BRUSH_DURABILITY.get();
        ENHANCED_BROOM_BRUSH_DURABILITY.get();
        BROOM_NETHERITE_TIP_DURABILITY.get();
        BROOM_WATERPROOF_TIP_DURABILITY.get();
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        Hexerei.LOGGER.debug("Loading config file {}", (Object)path);
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        Hexerei.LOGGER.debug("Built TOML config for {}", (Object)path.toString());
        configData.load();
        Hexerei.LOGGER.debug("Loaded TOML config file {}", (Object)path.toString());
        spec.setConfig((CommentedConfig)configData);
        JARS_ONLY_HOLD_HERBS.get();
        SAGE_BURNING_PLATE_RANGE.get();
        SAGE_BUNDLE_DURATION.get();
        WITCH_HUT_SPACING.get();
        WITCH_HUT_SEPARATION.get();
        DARK_COVEN_SPACING.get();
        DARK_COVEN_SEPARATION.get();
        BROOM_BRUSH_DURABILITY.get();
        ENHANCED_BROOM_BRUSH_DURABILITY.get();
        BROOM_NETHERITE_TIP_DURABILITY.get();
        BROOM_WATERPROOF_TIP_DURABILITY.get();
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("Settings");
        builder.pop();
        builder.push("Herb Jar Settings");
        JARS_ONLY_HOLD_HERBS = builder.comment("Disabling allows jars to hold any item").translation("hexerei.config.jars_only_hold_herbs").define("jars_only_hold_herbs", true);
        builder.pop();
        builder.push("Sage Burning Plate Settings");
        SAGE_BURNING_PLATE_RANGE = builder.comment("Range of the Sage Burning Plate, setting to 0 will disable completely").translation("hexerei.config.spawn_disable_range").define("spawn_disable_range", (Object)48);
        builder.pop();
        builder.push("Sage Bundle Settings");
        SAGE_BUNDLE_DURATION = builder.comment("Duration of how long each bundle will last while burning").translation("hexerei.config.sage_bundle_duration").define("sage_bundle_duration_in_seconds", (Object)3600);
        builder.pop();
        builder.push("");
        builder.pop();
        builder.push("Structures");
        builder.pop();
        builder.push("Witch Hut Spacing");
        WITCH_HUT_SPACING = builder.comment("spacing between witch huts, lower both spacing and separation to increase spawn rates").translation("hexerei.config.witch_hut_spacing").define("witch_hut_spacing", (Object)20);
        builder.pop();
        builder.push("Witch Hut Separation");
        WITCH_HUT_SEPARATION = builder.comment("separation of the witch huts, lower both spacing and separation to increase spawn rates").translation("hexerei.config.witch_hut_separation").define("witch_hut_separation", (Object)8);
        builder.pop();
        builder.push("Dark Coven Spacing");
        DARK_COVEN_SPACING = builder.comment("spacing between dark covens, lower both spacing and separation to increase spawn rates").translation("hexerei.config.dark_coven_spacing").define("dark_coven_spacing", (Object)29);
        builder.pop();
        builder.push("Dark Coven Separation");
        DARK_COVEN_SEPARATION = builder.comment("separation of the dark covens, lower both spacing and separation to increase spawn rates").translation("hexerei.config.dark_coven_separation").define("dark_coven_separation", (Object)11);
        builder.pop();
        builder.push("Broom Brush Durability");
        BROOM_BRUSH_DURABILITY = builder.comment("100 durability will be about 16 minutes of flight time").translation("hexerei.config.broom_brush_durability").define("broom_brush_durability", (Object)100);
        builder.pop();
        builder.push("Enhanced Broom Brush Durability");
        ENHANCED_BROOM_BRUSH_DURABILITY = builder.comment("200 durability will be about 32 minutes of flight time").translation("hexerei.config.enhanced_broom_brush_durability").define("enhanced_broom_brush_durability", (Object)200);
        builder.pop();
        builder.push("Broom Netherite Tip Durability");
        BROOM_NETHERITE_TIP_DURABILITY = builder.comment("1 second of active time per 1 durability").translation("hexerei.config.broom_netherite_tip_durability").define("broom_netherite_tip_durability", (Object)200);
        builder.pop();
        builder.push("Broom Waterproof Tip Durability");
        BROOM_WATERPROOF_TIP_DURABILITY = builder.comment("1 second of active time per 1 durability").translation("hexerei.config.broom_waterproof_tip_durability").define("broom_waterproof_tip_durability", (Object)800);
        builder.pop();
        COMMON_CONFIG = builder.build();
    }
}

