/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.integration.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.CandleDipper;
import net.joefoxe.hexerei.data.recipes.DipperRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class DipperRecipeCategory
implements IRecipeCategory<DipperRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("hexerei", "dipper");
    public static final ResourceLocation TEXTURE = new ResourceLocation("hexerei", "textures/gui/dipper_jei.png");
    public static final ResourceLocation TEXTURE_BLANK = new ResourceLocation("hexerei", "textures/block/blank.png");
    private final IDrawable background;
    private final IDrawable cauldron;
    private final IDrawable icon;
    private final IDrawable liquid;

    public DipperRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 100, 92);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((ItemLike)ModBlocks.CANDLE_DIPPER.get()));
        this.liquid = helper.createDrawable(TEXTURE_BLANK, 0, 0, 16, 16);
        this.cauldron = helper.createDrawable(TEXTURE, 106, 3, 12, 9);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends DipperRecipe> getRecipeClass() {
        return DipperRecipe.class;
    }

    public Component getTitle() {
        return ((CandleDipper)ModBlocks.CANDLE_DIPPER.get()).m_49954_();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(DipperRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.m_7527_());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
    }

    public void setRecipe(IRecipeLayout recipeLayout, DipperRecipe recipe, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 14, 13);
        recipeLayout.getItemStacks().init(1, false, 68, 22);
        recipeLayout.getItemStacks().set(ingredients);
        FluidStack input = recipe.getLiquid();
        if (recipe.getFluidLevelsConsumed() != 0 && !input.isEmpty()) {
            input.setAmount(Mth.m_14045_((int)recipe.getFluidLevelsConsumed(), (int)0, (int)2000));
        }
        if (!input.isEmpty()) {
            recipeLayout.getFluidStacks().init(2, true, 17, 36, 12, 9, recipe.getFluidLevelsConsumed(), false, this.cauldron);
            recipeLayout.getFluidStacks().set(2, input);
        }
    }

    public void draw(DipperRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        String dryingTimeString;
        String dippingTimeString;
        int numberOfDips = recipe.getNumberOfDips();
        int dippingTime = recipe.getDippingTime();
        int dryingTime = recipe.getDryingTime();
        Minecraft minecraft = Minecraft.m_91087_();
        matrixStack.m_85841_(0.6f, 0.6f, 0.6f);
        String numberOfDipsString = numberOfDips < Integer.MAX_VALUE ? Integer.toString(numberOfDips) : "?";
        TranslatableComponent times_dipped_1 = new TranslatableComponent("gui.jei.category.dipper.times_dipped_1");
        TranslatableComponent times_dipped_3 = new TranslatableComponent("gui.jei.category.dipper.result", new Object[]{numberOfDipsString});
        minecraft.f_91062_.m_92889_(matrixStack, (Component)times_dipped_1, 9.996f, 93.296f, -8355712);
        minecraft.f_91062_.m_92889_(matrixStack, (Component)times_dipped_3, 108.29f, 93.296f, -8355712);
        Object object = dippingTime < Integer.MAX_VALUE ? dippingTime / 20 + (String)(dippingTime % 20 == 0 ? "" : "." + Integer.toString(dippingTime % 20)) : (dippingTimeString = "?");
        if (dippingTimeString.charAt(dippingTimeString.length() - 1) == '0' && dippingTime != 0 && dippingTime % 20 != 0) {
            dippingTimeString = dippingTimeString.substring(0, dippingTimeString.length() - 1);
        }
        TranslatableComponent dip_time_1 = new TranslatableComponent("gui.jei.category.dipper.dip_time_1");
        TranslatableComponent dip_time_3 = new TranslatableComponent("gui.jei.category.dipper.resultSeconds", new Object[]{dippingTimeString});
        minecraft.f_91062_.m_92889_(matrixStack, (Component)dip_time_1, 9.996f, 113.288f, -8355712);
        minecraft.f_91062_.m_92889_(matrixStack, (Component)dip_time_3, 108.29f, 113.288f, -8355712);
        Object object2 = dryingTime < Integer.MAX_VALUE ? dryingTime / 20 + (String)(dryingTime % 20 == 0 ? "" : "." + Integer.toString(dryingTime % 20)) : (dryingTimeString = "?");
        if (dryingTimeString.charAt(dryingTimeString.length() - 1) == '0' && dryingTime != 0 && dryingTime % 20 != 0) {
            dryingTimeString = dryingTimeString.substring(0, dryingTimeString.length() - 1);
        }
        TranslatableComponent dry_time_1 = new TranslatableComponent("gui.jei.category.dipper.dry_time_1");
        TranslatableComponent dry_time_3 = new TranslatableComponent("gui.jei.category.dipper.resultSeconds", new Object[]{dryingTimeString});
        minecraft.f_91062_.m_92889_(matrixStack, (Component)dry_time_1, 9.996f, 133.28f, -8355712);
        minecraft.f_91062_.m_92889_(matrixStack, (Component)dry_time_3, 108.29f, 133.28f, -8355712);
        String outputName = recipe.m_8043_().m_41786_().getString();
        minecraft.f_91062_.m_92883_(matrixStack, outputName, 8.33f, 6.664f, -12566464);
    }
}

