/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.integration.jei;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.data.recipes.DipperRecipe;
import net.joefoxe.hexerei.data.recipes.DryingRackRecipe;
import net.joefoxe.hexerei.data.recipes.MixingCauldronRecipe;
import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.joefoxe.hexerei.data.recipes.PestleAndMortarRecipe;
import net.joefoxe.hexerei.integration.jei.DipperRecipeCategory;
import net.joefoxe.hexerei.integration.jei.DryingRackRecipeCategory;
import net.joefoxe.hexerei.integration.jei.MixingCauldronRecipeCategory;
import net.joefoxe.hexerei.integration.jei.PestleAndMortarRecipeCategory;
import net.joefoxe.hexerei.screen.MixingCauldronScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class HexereiJei
implements IModPlugin {
    public static final ResourceLocation MIXING_CAULDRON_UID = new ResourceLocation("hexerei", "mixing_cauldron");
    public static final ResourceLocation DIPPER_UID = new ResourceLocation("hexerei", "dipper");
    public static final ResourceLocation DRYING_RACK_UID = new ResourceLocation("hexerei", "drying_rack");
    public static final ResourceLocation PESTLE_AND_MORTAR_UID = new ResourceLocation("hexerei", "pestle_and_mortar");

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("hexerei", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new MixingCauldronRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new DipperRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new PestleAndMortarRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new DryingRackRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.MIXING_CAULDRON.get()), new ResourceLocation[]{MIXING_CAULDRON_UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CANDLE_DIPPER.get()), new ResourceLocation[]{DIPPER_UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.HERB_DRYING_RACK.get()), new ResourceLocation[]{DRYING_RACK_UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.PESTLE_AND_MORTAR.get()), new ResourceLocation[]{PESTLE_AND_MORTAR_UID});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(MixingCauldronScreen.class, 66, 30, 28, 26, new ResourceLocation[]{MIXING_CAULDRON_UID});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager rm = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_();
        registration.addRecipes((Collection)rm.m_44013_(ModRecipeTypes.MIXING_CAULDRON_RECIPE).stream().filter(r -> r instanceof MixingCauldronRecipe).collect(Collectors.toList()), MixingCauldronRecipeCategory.UID);
        registration.addRecipes((Collection)rm.m_44013_(ModRecipeTypes.DIPPER_RECIPE).stream().filter(r -> r instanceof DipperRecipe).collect(Collectors.toList()), DipperRecipeCategory.UID);
        registration.addRecipes((Collection)rm.m_44013_(ModRecipeTypes.DRYING_RACK_RECIPE).stream().filter(r -> r instanceof DryingRackRecipe).collect(Collectors.toList()), DryingRackRecipeCategory.UID);
        registration.addRecipes((Collection)rm.m_44013_(ModRecipeTypes.PESTLE_AND_MORTAR_RECIPE).stream().filter(r -> r instanceof PestleAndMortarRecipe).collect(Collectors.toList()), PestleAndMortarRecipeCategory.UID);
    }
}

