/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.integration.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.MixingCauldron;
import net.joefoxe.hexerei.data.recipes.MixingCauldronRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class MixingCauldronRecipeCategory
implements IRecipeCategory<MixingCauldronRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("hexerei", "mixing_cauldron");
    public static final ResourceLocation TEXTURE = new ResourceLocation("hexerei", "textures/gui/mixing_cauldron_gui_jei.png");
    public static final ResourceLocation TEXTURE_BLANK = new ResourceLocation("hexerei", "textures/block/blank.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable liquid;

    public MixingCauldronRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 176, 105);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((ItemLike)ModBlocks.MIXING_CAULDRON.get()));
        this.liquid = helper.createDrawable(TEXTURE, 182, 2, 12, 10);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends MixingCauldronRecipe> getRecipeClass() {
        return MixingCauldronRecipe.class;
    }

    public Component getTitle() {
        return ((MixingCauldron)ModBlocks.MIXING_CAULDRON.get()).m_49954_();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(MixingCauldronRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.m_7527_());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
    }

    public void setRecipe(IRecipeLayout recipeLayout, MixingCauldronRecipe recipe, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 79, 13);
        recipeLayout.getItemStacks().init(1, true, 101, 22);
        recipeLayout.getItemStacks().init(2, true, 110, 44);
        recipeLayout.getItemStacks().init(3, true, 101, 66);
        recipeLayout.getItemStacks().init(4, true, 79, 75);
        recipeLayout.getItemStacks().init(5, true, 57, 66);
        recipeLayout.getItemStacks().init(6, true, 48, 44);
        recipeLayout.getItemStacks().init(7, true, 57, 22);
        recipeLayout.getItemStacks().init(8, false, 141, 36);
        recipeLayout.getItemStacks().set(ingredients);
        FluidStack input = recipe.getLiquid();
        FluidStack output = recipe.getLiquidOutput();
        if (recipe.getFluidLevelsConsumed() != 0) {
            if (!input.isEmpty()) {
                input.setAmount(Mth.m_14045_((int)recipe.getFluidLevelsConsumed(), (int)0, (int)2000));
            }
        } else if (!output.isEmpty()) {
            output.setAmount(2000);
        }
        if (!output.isEmpty()) {
            output.setAmount(2000 - recipe.getFluidLevelsConsumed());
        }
        if (!input.isEmpty()) {
            recipeLayout.getFluidStacks().init(9, true, 20, 48, 12, 10, 2000, false, this.liquid);
            recipeLayout.getFluidStacks().set(9, input);
        }
        if (!output.isEmpty()) {
            recipeLayout.getFluidStacks().init(10, false, 144, 61, 12, 10, 2000, true, this.liquid);
            recipeLayout.getFluidStacks().set(10, output);
        }
    }

    public void draw(MixingCauldronRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        String outputName = recipe.m_8043_().m_41786_().getString();
        matrixStack.m_85841_(0.6f, 0.6f, 0.6f);
        minecraft.f_91062_.m_92883_(matrixStack, outputName, 71.638f, 6.664f, -12566464);
        minecraft.f_91062_.m_92889_(matrixStack, (Component)new TranslatableComponent("gui.jei.category.mixing_cauldron.fluid"), 31.654f, 59.976f, -12566464);
        minecraft.f_91062_.m_92889_(matrixStack, (Component)new TranslatableComponent("gui.jei.category.mixing_cauldron.output"), 233.24f, 39.984f, -12566464);
    }
}

