/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.List;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.message.DowsingRodUpdatePositionPacket;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.PacketDistributor;

public class DowsingRodItem
extends Item {
    public BlockPos nearestPos = null;
    public boolean swampMode = true;
    public static final DynamicCommandExceptionType ERROR_INVALID_BIOME = new DynamicCommandExceptionType(p_137850_ -> new TranslatableComponent("commands.locatebiome.invalid", new Object[]{p_137850_}));

    public DowsingRodItem(Item.Properties properties) {
        super(properties);
    }

    public static double angleDifference(double angle1, double angle2) {
        double diff = (angle2 - angle1 + 180.0) % 360.0 - 180.0;
        return diff < -180.0 ? diff + 360.0 : diff;
    }

    public void m_6883_(ItemStack p_41404_, Level world, Entity entity, int p_41407_, boolean p_41408_) {
        super.m_6883_(p_41404_, world, entity, p_41407_, p_41408_);
        if (entity instanceof Player && (this.nearestPos == null && ((Player)entity).m_21205_() == p_41404_ || ((Player)entity).m_21206_() == p_41404_)) {
            if (this.swampMode) {
                this.findSwamp(world, entity);
            } else {
                this.findJungle(world, entity);
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        BlockHitResult raytraceresult = DowsingRodItem.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (playerIn.m_36341_()) {
            if (!worldIn.f_46443_) {
                playerIn.m_36335_().m_41524_((Item)this, 20);
                this.swampMode = !this.swampMode;
                String s = "display.hexerei.dowsing_rod_swamp";
                if (!this.swampMode) {
                    s = "display.hexerei.dowsing_rod_jungle";
                }
                if (this.swampMode) {
                    this.findSwamp(worldIn, (Entity)playerIn);
                } else {
                    this.findJungle(worldIn, (Entity)playerIn);
                }
                playerIn.m_5661_((Component)new TranslatableComponent(s), true);
            }
        } else if (this.swampMode) {
            this.findSwamp(worldIn, (Entity)playerIn);
        } else {
            this.findJungle(worldIn, (Entity)playerIn);
        }
        if (!worldIn.f_46443_) {
            HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> worldIn.m_46745_(playerIn.m_142538_())), (Object)new DowsingRodUpdatePositionPacket(itemstack, this.nearestPos, this.swampMode));
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public void findSwamp(Level worldIn, Entity entity) {
        if (!worldIn.f_46443_) {
            Biome biome = null;
            try {
                biome = (Biome)entity.m_20194_().m_129911_().m_175515_(Registry.f_122885_).m_123009_(Biomes.f_48207_).orElseThrow(() -> ERROR_INVALID_BIOME.create((Object)Biomes.f_48207_));
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
            this.nearestPos = ((ServerLevel)worldIn).m_8705_(biome, entity.m_142538_(), 6400, 8);
        }
    }

    public void findJungle(Level worldIn, Entity entity) {
        if (!worldIn.f_46443_) {
            Biome biome = null;
            try {
                biome = (Biome)entity.m_20194_().m_129911_().m_175515_(Registry.f_122885_).m_123009_(Biomes.f_48222_).orElseThrow(() -> ERROR_INVALID_BIOME.create((Object)Biomes.f_48207_));
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
            this.nearestPos = ((ServerLevel)worldIn).m_8705_(biome, entity.m_142538_(), 6400, 8);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)new TranslatableComponent("<%s>", new Object[]{new TranslatableComponent("tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAA6600)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.dowsing_rod_2").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.dowsing_rod_3").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.dowsing_rod_4").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.dowsing_rod_5").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
        } else {
            tooltip.add((Component)new TranslatableComponent("[%s]", new Object[]{new TranslatableComponent("tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAA00)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.dowsing_rod").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
        }
        super.m_7373_(stack, world, tooltip, flagIn);
    }
}

