/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.custom.Coffer;
import net.joefoxe.hexerei.container.CofferContainer;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.message.TESyncPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class CofferTile
extends RandomizableContainerBlockEntity
implements Clearable {
    public final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
    public int degreesOpened;
    public int buttonToggled = 0;
    public static final int lidOpenAmount = 112;
    public Component customName;

    public CofferTile(BlockEntityType<?> tileEntityTypeIn, BlockPos blockPos, BlockState blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
    }

    public CofferTile(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModTileEntities.COFFER_TILE.get(), blockPos, blockState);
    }

    public BlockEntityType<?> m_58903_() {
        return super.m_58903_();
    }

    public void readInventory(CompoundTag compound) {
        this.itemHandler.deserializeNBT(compound);
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    public void m_6596_() {
        super.m_6596_();
    }

    public void m_5856_(Player p_18955_) {
        super.m_5856_(p_18955_);
    }

    public void m_5785_(Player p_18954_) {
        super.m_5785_(p_18954_);
    }

    public boolean m_7013_(int p_18952_, ItemStack p_18953_) {
        return super.m_7013_(p_18952_, p_18953_);
    }

    public int m_18947_(Item p_18948_) {
        return super.m_18947_(p_18948_);
    }

    protected Component m_6820_() {
        return new TranslatableComponent("container.hexerei.coffer");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new CofferContainer(id, this.f_58857_, this.f_58858_, player, player.f_35978_);
    }

    public void m_6211_() {
        super.m_6211_();
        this.items.clear();
    }

    public AABB getRenderBoundingBox() {
        AABB aabb = super.getRenderBoundingBox().m_82377_(5.0, 5.0, 5.0);
        return aabb;
    }

    public void requestModelDataUpdate() {
        super.requestModelDataUpdate();
    }

    @NotNull
    public IModelData getModelData() {
        return super.getModelData();
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    public void onLoad() {
        super.onLoad();
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
    }

    public CompoundTag serializeNBT() {
        return super.serializeNBT();
    }

    public CompoundTag save(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        return tag;
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.itemHandler.deserializeNBT(compoundTag.m_128469_("inv"));
        if (compoundTag.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)compoundTag.m_128461_("CustomName"));
        }
    }

    public CompoundTag m_5995_() {
        return this.save(new CompoundTag());
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, tag -> this.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.deserializeNBT(pkt.m_131708_());
    }

    public void sync() {
        this.m_6596_();
        if (!this.f_58857_.f_46443_) {
            HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new TESyncPacket(this.f_58858_, this.save(new CompoundTag())));
        }
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 2);
        }
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(36){

            protected void onContentsChanged(int slot) {
                CofferTile.this.sync();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            public int getSlotLimit(int slot) {
                return 64;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        return super.getCapability(cap);
    }

    public ItemStack getItemStackInSlot(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    public int getNumberOfItems() {
        int num = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i) == ItemStack.f_41583_) continue;
            ++num;
        }
        return num;
    }

    public static double getDistanceToEntity(Entity entity, BlockPos pos) {
        double deltaX = entity.m_20185_() - (double)pos.m_123341_();
        double deltaY = entity.m_20186_() - (double)pos.m_123342_();
        double deltaZ = entity.m_20189_() - (double)pos.m_123343_();
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public Component m_5446_() {
        return this.customName != null ? this.customName : new TranslatableComponent("");
    }

    public Component m_7770_() {
        return this.customName;
    }

    public boolean m_8077_() {
        return this.customName != null;
    }

    public Component m_7755_() {
        return this.customName;
    }

    public int getDegreesOpened() {
        return this.degreesOpened;
    }

    public void setDegreesOpened(int degrees) {
        this.degreesOpened = degrees;
    }

    public int getButtonToggled() {
        return this.buttonToggled;
    }

    public void setButtonToggled(int degrees) {
        this.buttonToggled = degrees;
    }

    public void tick() {
        int distanceFromSide;
        if (this.f_58857_.f_46443_) {
            return;
        }
        boolean flag = false;
        Player playerEntity = this.f_58857_.m_45924_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), 5.0, false);
        if (playerEntity != null && Math.floor(CofferTile.getDistanceToEntity((Entity)playerEntity, this.f_58858_)) < 4.0) {
            distanceFromSide = 56 - Math.abs(56 - this.degreesOpened);
            flag = true;
            this.degreesOpened = (double)this.degreesOpened + Math.floor((double)distanceFromSide / 56.0 * 6.0) + 2.0 < 112.0 ? (int)((double)this.degreesOpened + (Math.floor((double)distanceFromSide / 56.0 * 6.0) + 2.0)) : 112;
            ((Coffer)this.m_58900_().m_60734_()).setAngle(this.f_58857_, this.f_58858_, this.m_58900_(), this.degreesOpened);
        }
        if (!flag) {
            distanceFromSide = 56 - Math.abs(56 - this.degreesOpened);
            this.degreesOpened = (double)this.degreesOpened + Math.floor((double)distanceFromSide / 56.0 * 6.0) + 2.0 > 0.0 ? (int)((double)this.degreesOpened - (Math.floor((double)distanceFromSide / 56.0 * 6.0) + 2.0)) : 0;
            ((Coffer)this.m_58900_().m_60734_()).setAngle(this.f_58857_, this.f_58858_, this.m_58900_(), this.degreesOpened);
        }
    }

    public int m_6643_() {
        return 0;
    }

    public int m_6893_() {
        return super.m_6893_();
    }
}

