/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import net.joefoxe.hexerei.block.custom.CrystalBall;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class CrystalBallTile
extends BlockEntity {
    public int degreesSpun;
    public int bobAmount;
    public float orbOffset = 0.0f;
    public float smallRingOffset = 0.0f;
    public float largeRingOffset = 0.0f;

    public CrystalBallTile(BlockEntityType<?> tileEntityTypeIn, BlockPos blockPos, BlockState blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
    }

    public CrystalBallTile(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModTileEntities.CRYSTAL_BALL_TILE.get(), blockPos, blockState);
    }

    public static double getDistanceToEntity(Entity entity, BlockPos pos) {
        double deltaX = entity.m_20182_().f_82479_ - (double)pos.m_123341_();
        double deltaY = entity.m_20182_().f_82480_ - (double)pos.m_123342_();
        double deltaZ = entity.m_20182_().f_82481_ - (double)pos.m_123343_();
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    private float moveTo(float input, float movedTo, float speed) {
        float distance = movedTo - input;
        if (Math.abs(distance) <= speed) {
            return movedTo;
        }
        input = distance > 0.0f ? (input += speed) : (input -= speed);
        return input;
    }

    public AABB getRenderBoundingBox() {
        AABB aabb = super.getRenderBoundingBox().m_82377_(5.0, 5.0, 5.0);
        return aabb;
    }

    public void tick() {
        if (this.f_58857_.f_46443_) {
            float currentTime = this.m_58904_().m_46467_();
            if (this.largeRingOffset > -7.0f) {
                this.degreesSpun = this.degreesSpun + 1 < 112 ? ++this.degreesSpun : 0;
            }
            if (this.f_58857_.m_45924_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), 4.0, false) != null) {
                this.orbOffset = this.moveTo(this.orbOffset, (float)Math.sin(Math.PI * (double)currentTime / 10.0) / 4.0f, 0.25f);
                this.smallRingOffset = this.moveTo(this.smallRingOffset, (float)Math.sin(Math.PI * (double)(currentTime + 20.0f) / 15.0) / 4.0f, 0.25f);
                this.largeRingOffset = this.moveTo(this.largeRingOffset, (float)Math.sin(Math.PI * (double)(currentTime + 40.0f) / 20.0) / 4.0f, 0.35f);
            } else {
                this.orbOffset = this.moveTo(this.orbOffset, -0.5f, 0.1f);
                this.smallRingOffset = this.moveTo(this.smallRingOffset, -4.5f, 0.25f);
                this.largeRingOffset = this.moveTo(this.largeRingOffset, -7.0f, 0.25f);
            }
            return;
        }
        if (this.largeRingOffset > -7.0f) {
            this.degreesSpun = this.degreesSpun + 1 < 112 ? ++this.degreesSpun : 0;
        }
        boolean flag = true;
        if (this.f_58857_.m_45924_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), 4.0, false) != null) {
            ((CrystalBall)this.m_58900_().m_60734_()).setPlayerNear(this.f_58857_, this.f_58858_, this.m_58900_(), true);
            flag = false;
        }
        if (flag) {
            ((CrystalBall)this.m_58900_().m_60734_()).setPlayerNear(this.f_58857_, this.f_58858_, this.m_58900_(), false);
        }
    }
}

