/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.config.HexConfig;
import net.joefoxe.hexerei.container.HerbJarContainer;
import net.joefoxe.hexerei.items.JarHandler;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiTags;
import net.joefoxe.hexerei.util.message.MessageCountUpdate;
import net.joefoxe.hexerei.util.message.TESyncPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.Clearable;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;

public class HerbJarTile
extends RandomizableContainerBlockEntity
implements Clearable,
MenuProvider {
    public JarHandler itemHandler;
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler).cast();
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
    private final FormattedCharSequence[] renderText = new FormattedCharSequence[1];
    private final Component[] signText = new Component[]{new TextComponent("Text")};
    public int degreesOpened;
    public Component customName;
    private long lastClickTime;
    private UUID lastClickUUID;

    public HerbJarTile(BlockEntityType<?> tileEntityTypeIn, BlockPos blockPos, BlockState blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
        this.itemHandler = this.createHandler();
    }

    public HerbJarTile(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModTileEntities.HERB_JAR_TILE.get(), blockPos, blockState);
    }

    public void readInventory(CompoundTag compound) {
        this.itemHandler.deserializeNBT(compound);
    }

    public NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    public ItemStack getItemStackInSlot(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    protected void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    public void m_6596_() {
        super.m_6596_();
    }

    protected Component m_6820_() {
        return new TranslatableComponent("container.hexerei.herb_jar");
    }

    public CompoundTag save(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        return tag;
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.itemHandler.deserializeNBT(compoundTag.m_128469_("inv"));
        if (compoundTag.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)compoundTag.m_128461_("CustomName"));
        }
    }

    public CompoundTag m_5995_() {
        return this.save(new CompoundTag());
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, tag -> this.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.deserializeNBT(pkt.m_131708_());
    }

    public void sync() {
        this.m_6596_();
        if (!this.f_58857_.f_46443_) {
            HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new TESyncPacket(this.f_58858_, this.save(new CompoundTag())));
        }
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 2);
        }
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new HerbJarContainer(id, this.f_58857_, this.f_58858_, player, player.f_35978_);
    }

    public void m_6211_() {
        super.m_6211_();
    }

    public AABB getRenderBoundingBox() {
        AABB aabb = super.getRenderBoundingBox().m_82377_(5.0, 5.0, 5.0);
        return aabb;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public FormattedCharSequence reorderText(int row, Function<Component, FormattedCharSequence> textProcessorFunction) {
        if (this.renderText[row] == null && this.customName != null) {
            this.renderText[row] = textProcessorFunction.apply(this.customName);
        }
        return this.renderText[row];
    }

    private JarHandler createHandler() {
        return new JarHandler(1, 1024){

            protected void onContentsChanged(int slot) {
                HerbJarTile.this.sync();
            }

            @Override
            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (((Boolean)HexConfig.JARS_ONLY_HOLD_HERBS.get()).booleanValue()) {
                    return stack.m_150922_(HexereiTags.Items.HERB_ITEM);
                }
                return true;
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public Item getItemInSlot(int slot) {
        return this.itemHandler.getStackInSlot(slot).m_41720_();
    }

    public int getNumberOfItems() {
        int num = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i) == ItemStack.f_41583_) continue;
            ++num;
        }
        return num;
    }

    public static double getDistanceToEntity(Entity entity, BlockPos pos) {
        double deltaX = entity.m_20185_() - (double)pos.m_123341_();
        double deltaY = entity.m_20186_() - (double)pos.m_123342_();
        double deltaZ = entity.m_20189_() - (double)pos.m_123343_();
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public Component m_5446_() {
        return this.customName != null ? this.customName : new TranslatableComponent("");
    }

    @Nonnull
    public ItemStack takeItems(int slot, int count) {
        ItemStack stack = this.itemHandler.getStackInSlot(slot).m_41777_();
        stack.m_41764_(Math.min(count, this.itemHandler.getStackInSlot(slot).m_41741_()));
        this.itemHandler.getStackInSlot(slot).m_41764_(this.itemHandler.getStackInSlot(slot).m_41613_() - stack.m_41613_());
        return stack;
    }

    public int putItems(int slot, @Nonnull ItemStack stack, int count) {
        if (((Boolean)HexConfig.JARS_ONLY_HOLD_HERBS.get()).booleanValue() && !stack.m_150922_(HexereiTags.Items.HERB_ITEM)) {
            return 0;
        }
        if (((ItemStack)this.itemHandler.getContents().get(0)).m_41619_()) {
            this.itemHandler.insertItem(0, stack.m_41777_(), false);
            this.sync();
            stack.m_41774_(count);
            return count;
        }
        if (!((ItemStack)this.itemHandler.getContents().get(0)).m_41656_(stack)) {
            return 0;
        }
        if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)((ItemStack)this.itemHandler.getContents().get(0)))) {
            return 0;
        }
        int countAdded = Math.min(count, stack.m_41613_());
        countAdded = Math.min(countAdded, 1024 - ((ItemStack)this.itemHandler.getContents().get(0)).m_41613_());
        ((ItemStack)this.itemHandler.getContents().get(0)).m_41764_(((ItemStack)this.itemHandler.getContents().get(0)).m_41613_() + countAdded);
        stack.m_41774_(countAdded);
        return countAdded;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientUpdateCount(int slot, int count) {
        if (!Objects.requireNonNull(this.m_58904_()).f_46443_) {
            return;
        }
        Minecraft.m_91087_().m_6937_(() -> this.clientUpdateCountAsync(slot, count));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientUpdateCountAsync(int slot, int count) {
        if (this.itemHandler.getStackInSlot(0).m_41613_() != count) {
            ItemStack newStack = this.itemHandler.getStackInSlot(0).m_41777_();
            this.itemHandler.setStackInSlot(0, newStack);
        }
    }

    protected void syncClientCount(int slot, int count) {
        if (this.m_58904_() != null && this.m_58904_().f_46443_) {
            return;
        }
        PacketDistributor.TargetPoint point = new PacketDistributor.TargetPoint((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), 500.0, this.m_58904_().m_46472_());
        HexereiPacketHandler.instance.send(PacketDistributor.NEAR.with(() -> point), (Object)new MessageCountUpdate(this.m_58899_(), slot, count));
    }

    public int interactPutItems(Player player) {
        int count = Objects.requireNonNull(this.m_58904_()).m_46467_() - this.lastClickTime < 10L && player.m_142081_().equals(this.lastClickUUID) ? this.interactPutCurrentInventory(0, player) : this.interactPutCurrentItem(0, player);
        this.lastClickTime = this.m_58904_().m_46467_();
        this.lastClickUUID = player.m_142081_();
        if (count > 0) {
            this.sync();
        }
        return count;
    }

    public int interactPutCurrentItem(int slot, Player player) {
        int count = 0;
        ItemStack playerStack = player.f_36093_.m_36056_();
        if (!playerStack.m_41619_()) {
            count = this.putItems(slot, playerStack, playerStack.m_41613_());
        }
        return count;
    }

    public int interactPutCurrentInventory(int slot, Player player) {
        int count = 0;
        if (!((ItemStack)this.itemHandler.getContents().get(0)).m_41619_()) {
            int n = player.f_36093_.m_6643_();
            for (int i = 0; i < n; ++i) {
                ItemStack subStack = player.f_36093_.m_8020_(i);
                if (subStack.m_41619_()) continue;
                int subCount = this.putItems(slot, subStack, subStack.m_41613_());
                if (subCount > 0 && subStack.m_41613_() == 0) {
                    player.f_36093_.m_6836_(i, ItemStack.f_41583_);
                }
                count += subCount;
            }
        }
        if (count > 0 && player instanceof ServerPlayer) {
            ((ServerPlayer)player).m_143399_(player.f_36096_);
        }
        return count;
    }

    public Component m_7770_() {
        return this.customName;
    }

    public boolean m_8077_() {
        return this.customName != null;
    }

    public Component m_7755_() {
        return this.customName;
    }

    public int getDegreesOpened() {
        return this.degreesOpened;
    }

    public void setDegreesOpened(int degrees) {
        this.degreesOpened = degrees;
    }

    public int m_6643_() {
        return 0;
    }
}

