/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.custom.SageBurningPlate;
import net.joefoxe.hexerei.config.HexConfig;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.particle.ModParticleTypes;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.message.EmitExtinguishParticlesPacket;
import net.joefoxe.hexerei.util.message.TESyncPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.network.PacketDistributor;

public class SageBurningPlateTile
extends RandomizableContainerBlockEntity
implements WorldlyContainer,
Clearable,
MenuProvider {
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    public int burnTimeMax = 20;
    public int burnTime = 20;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public SageBurningPlateTile(BlockEntityType<?> tileEntityTypeIn, BlockPos blockPos, BlockState blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
    }

    public NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    public void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    public int m_6893_() {
        return 1;
    }

    public void m_6596_() {
        super.m_6596_();
    }

    public void sync() {
        this.m_6596_();
        if (!this.f_58857_.f_46443_) {
            HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new TESyncPacket(this.f_58858_, this.save(new CompoundTag())));
        }
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 2);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        return super.getCapability(cap);
    }

    public Item getItemInSlot(int slot) {
        return ((ItemStack)this.items.get(slot)).m_41720_();
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
    }

    public CompoundTag serializeNBT() {
        return super.serializeNBT();
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    public void onLoad() {
        super.onLoad();
    }

    public SageBurningPlateTile(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModTileEntities.SAGE_BURNING_PLATE_TILE.get(), blockPos, blockState);
    }

    public void m_6836_(int index, ItemStack stack) {
        if (index >= 0 && index < this.items.size()) {
            ItemStack itemStack = stack.m_41777_();
            this.items.set(index, (Object)itemStack);
            this.burnTime = this.burnTimeMax;
        }
        this.sync();
    }

    public ItemStack m_7407_(int index, int p_59614_) {
        this.m_59640_(null);
        if (((Boolean)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            Random random = new Random();
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)), 11);
            this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_144098_, SoundSource.PLAYERS, 1.0f, random.nextFloat() * 0.4f + 1.0f);
            this.sync();
            if (!this.f_58857_.f_46443_) {
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new EmitExtinguishParticlesPacket(this.f_58858_));
            }
        }
        ItemStack itemstack = ContainerHelper.m_18969_(this.m_7086_(), (int)index, (int)p_59614_);
        this.sync();
        return itemstack;
    }

    public void m_142466_(CompoundTag nbt) {
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(nbt)) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
        }
        if (nbt.m_128425_("burnTime", 3)) {
            this.burnTime = nbt.m_128451_("burnTime");
        }
        if (nbt.m_128425_("burnTimeMax", 3)) {
            this.burnTimeMax = nbt.m_128451_("burnTimeMax");
        }
        super.m_142466_(nbt);
    }

    protected Component m_6820_() {
        return new TranslatableComponent("container.hexerei.sage_burning_plate");
    }

    protected AbstractContainerMenu m_6555_(int p_58627_, Inventory p_58628_) {
        return null;
    }

    public void m_183515_(CompoundTag compound) {
        ContainerHelper.m_18973_((CompoundTag)compound, this.items);
        compound.m_128405_("burnTime", this.burnTime);
        compound.m_128405_("burnTimeMax", this.burnTimeMax);
    }

    public CompoundTag save(CompoundTag compound) {
        super.m_183515_(compound);
        ContainerHelper.m_18973_((CompoundTag)compound, this.items);
        compound.m_128405_("burnTime", this.burnTime);
        compound.m_128405_("burnTimeMax", this.burnTimeMax);
        return compound;
    }

    public CompoundTag m_5995_() {
        return this.save(new CompoundTag());
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, tag -> this.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.deserializeNBT(pkt.m_131708_());
    }

    public static double getDistanceToEntity(Entity entity, BlockPos pos) {
        double deltaX = entity.m_20182_().m_7096_() - (double)pos.m_123341_() - 0.5;
        double deltaY = entity.m_20182_().m_7098_() - (double)pos.m_123342_() - 0.5;
        double deltaZ = entity.m_20182_().m_7094_() - (double)pos.m_123343_() - 0.5;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public static double getDistance(float x1, float y1, float x2, float y2) {
        double deltaX = x2 - x1;
        double deltaY = y2 - y1;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    public AABB getRenderBoundingBox() {
        AABB aabb = super.getRenderBoundingBox().m_82377_(5.0, 5.0, 5.0);
        return aabb;
    }

    private float moveTo(float input, float moveTo, float speed) {
        float distance = moveTo - input;
        if (Math.abs(distance) <= speed) {
            return moveTo;
        }
        input = distance > 0.0f ? (input += speed) : (input -= speed);
        return input;
    }

    private float moveToAngle(float input, float movedTo, float speed) {
        float distance = movedTo - input;
        if (Math.abs(distance) <= speed) {
            return movedTo;
        }
        input = distance > 0.0f ? (Math.abs(distance) < 180.0f ? (input += speed) : (input -= speed)) : (Math.abs(distance) < 180.0f ? (input -= speed) : (input += speed));
        if (input < -90.0f) {
            input += 360.0f;
        }
        if (input > 270.0f) {
            input -= 360.0f;
        }
        return input;
    }

    public float getAngle(Vec3 pos) {
        float angle = (float)Math.toDegrees(Math.atan2(pos.m_7094_() - (double)this.m_58899_().m_123343_() - 0.5, pos.m_7096_() - (double)this.m_58899_().m_123341_() - 0.5));
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public float getSpeed(double pos, double posTo) {
        return (float)((double)0.01f + (double)0.1f * (Math.abs(pos - posTo) / 3.0));
    }

    public Vec3 rotateAroundVec(Vec3 vector3dCenter, float rotation, Vec3 vector3d) {
        Vec3 newVec = vector3d.m_82546_(vector3dCenter);
        newVec = newVec.m_82524_(rotation / 180.0f * (float)Math.PI);
        newVec = newVec.m_82549_(vector3dCenter);
        return newVec;
    }

    public int putItems(int slot, @Nonnull ItemStack stack) {
        ItemStack stack1 = stack.m_41777_();
        Random rand = new Random();
        if (((ItemStack)this.items.get(slot)).m_41619_() && this.m_7013_(slot, stack)) {
            stack1.m_41764_(1);
            this.items.set(slot, (Object)stack1);
            this.burnTime = this.burnTimeMax;
            this.sync();
            stack.m_41774_(1);
            this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, rand.nextFloat() * 0.4f + 1.0f);
            return 1;
        }
        return 0;
    }

    public int interactSageBurningPlate(Player player, BlockHitResult hit) {
        if (!player.m_6144_()) {
            if (!player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                Random rand = new Random();
                if (((ItemStack)this.items.get(0)).m_41619_()) {
                    this.putItems(0, player.m_21120_(InteractionHand.MAIN_HAND));
                    return 1;
                }
            }
        } else if (!((ItemStack)this.items.get(0)).m_41619_()) {
            player.f_36093_.m_150079_(((ItemStack)this.items.get(0)).m_41777_());
            this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.nextFloat() * 0.4f + 1.0f);
            this.m_7407_(0, 1);
        }
        return 0;
    }

    public void extinguishParticles() {
        Random rand = new Random();
        float offsetX = 0.0f;
        float offsetZ = 0.0f;
        float damageOutOf5 = (float)(((ItemStack)this.m_7086_().get(0)).m_41776_() - ((ItemStack)this.m_7086_().get(0)).m_41773_()) / (float)((ItemStack)this.m_7086_().get(0)).m_41776_() * 5.0f;
        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.NORTH) {
            offsetX = -0.25f;
            if (damageOutOf5 <= 4.0f && damageOutOf5 > 3.0f) {
                offsetX = (float)((double)offsetX + 0.09);
            }
            if (damageOutOf5 <= 3.0f && damageOutOf5 > 2.0f) {
                offsetX = (float)((double)offsetX + 0.18);
            }
            if (damageOutOf5 <= 2.0f && damageOutOf5 > 1.0f) {
                offsetX = (float)((double)offsetX + 0.25);
            }
            if (damageOutOf5 <= 1.0f && damageOutOf5 >= 0.0f) {
                offsetX = (float)((double)offsetX + 0.33);
            }
        }
        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.SOUTH) {
            offsetX = 0.25f;
            if (damageOutOf5 <= 4.0f && damageOutOf5 > 3.0f) {
                offsetX = (float)((double)offsetX - 0.09);
            }
            if (damageOutOf5 <= 3.0f && damageOutOf5 > 2.0f) {
                offsetX = (float)((double)offsetX - 0.18);
            }
            if (damageOutOf5 <= 2.0f && damageOutOf5 > 1.0f) {
                offsetX = (float)((double)offsetX - 0.25);
            }
            if (damageOutOf5 <= 1.0f && damageOutOf5 >= 0.0f) {
                offsetX = (float)((double)offsetX - 0.33);
            }
        }
        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
            offsetZ = 0.25f;
            if (damageOutOf5 <= 4.0f && damageOutOf5 > 3.0f) {
                offsetZ = (float)((double)offsetZ - 0.09);
            }
            if (damageOutOf5 <= 3.0f && damageOutOf5 > 2.0f) {
                offsetZ = (float)((double)offsetZ - 0.18);
            }
            if (damageOutOf5 <= 2.0f && damageOutOf5 > 1.0f) {
                offsetZ = (float)((double)offsetZ - 0.25);
            }
            if (damageOutOf5 <= 1.0f && damageOutOf5 >= 0.0f) {
                offsetZ = (float)((double)offsetZ - 0.33);
            }
        }
        if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST) {
            offsetZ = -0.25f;
            if (damageOutOf5 <= 4.0f && damageOutOf5 > 3.0f) {
                offsetZ = (float)((double)offsetZ + 0.09);
            }
            if (damageOutOf5 <= 3.0f && damageOutOf5 > 2.0f) {
                offsetZ = (float)((double)offsetZ + 0.18);
            }
            if (damageOutOf5 <= 2.0f && damageOutOf5 > 1.0f) {
                offsetZ = (float)((double)offsetZ + 0.25);
            }
            if (damageOutOf5 <= 1.0f && damageOutOf5 >= 0.0f) {
                offsetZ = (float)((double)offsetZ + 0.33);
            }
        }
        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)((float)this.f_58858_.m_123341_() + 0.5f + offsetX), (double)((float)this.f_58858_.m_123342_() + 0.25f), (double)((float)this.f_58858_.m_123343_() + 0.5f + offsetZ), (rand.nextDouble() - 0.5) / 50.0, (rand.nextDouble() + 0.5) * 0.045, (rand.nextDouble() - 0.5) / 50.0);
        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123777_, (double)((float)this.f_58858_.m_123341_() + 0.5f + offsetX), (double)((float)this.f_58858_.m_123342_() + 0.25f), (double)((float)this.f_58858_.m_123343_() + 0.5f + offsetZ), (rand.nextDouble() - 0.5) / 50.0, (rand.nextDouble() + 0.5) * 0.045, (rand.nextDouble() - 0.5) / 50.0);
        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)this.f_58858_.m_123341_() + 0.5f + offsetX), (double)((float)this.f_58858_.m_123342_() + 0.25f), (double)((float)this.f_58858_.m_123343_() + 0.5f + offsetZ), (rand.nextDouble() - 0.5) / 50.0, (rand.nextDouble() + 0.5) * 0.045, (rand.nextDouble() - 0.5) / 50.0);
        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)this.f_58858_.m_123341_() + 0.5f + offsetX), (double)((float)this.f_58858_.m_123342_() + 0.25f), (double)((float)this.f_58858_.m_123343_() + 0.5f + offsetZ), (rand.nextDouble() - 0.5) / 50.0, (rand.nextDouble() + 0.5) * 0.045, (rand.nextDouble() - 0.5) / 50.0);
        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)this.f_58858_.m_123341_() + 0.5f + offsetX), (double)((float)this.f_58858_.m_123342_() + 0.25f), (double)((float)this.f_58858_.m_123343_() + 0.5f + offsetZ), (rand.nextDouble() - 0.5) / 50.0, (rand.nextDouble() + 0.5) * 0.045, (rand.nextDouble() - 0.5) / 50.0);
    }

    public void emitParticles() {
        Random rand = new Random();
        if (rand.nextInt(4) == 0 && this.f_58857_.f_46443_) {
            float offsetX = 0.0f;
            float offsetZ = 0.0f;
            float damageOutOf5 = (float)(((ItemStack)this.m_7086_().get(0)).m_41776_() - ((ItemStack)this.m_7086_().get(0)).m_41773_()) / (float)((ItemStack)this.m_7086_().get(0)).m_41776_() * 5.0f;
            if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.NORTH) {
                offsetX = -0.25f;
                if (damageOutOf5 <= 4.0f && damageOutOf5 > 3.0f) {
                    offsetX = (float)((double)offsetX + 0.09);
                }
                if (damageOutOf5 <= 3.0f && damageOutOf5 > 2.0f) {
                    offsetX = (float)((double)offsetX + 0.18);
                }
                if (damageOutOf5 <= 2.0f && damageOutOf5 > 1.0f) {
                    offsetX = (float)((double)offsetX + 0.25);
                }
                if (damageOutOf5 <= 1.0f && damageOutOf5 > 0.0f) {
                    offsetX = (float)((double)offsetX + 0.33);
                }
            }
            if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.SOUTH) {
                offsetX = 0.25f;
                if (damageOutOf5 <= 4.0f && damageOutOf5 > 3.0f) {
                    offsetX = (float)((double)offsetX - 0.09);
                }
                if (damageOutOf5 <= 3.0f && damageOutOf5 > 2.0f) {
                    offsetX = (float)((double)offsetX - 0.18);
                }
                if (damageOutOf5 <= 2.0f && damageOutOf5 > 1.0f) {
                    offsetX = (float)((double)offsetX - 0.25);
                }
                if (damageOutOf5 <= 1.0f && damageOutOf5 > 0.0f) {
                    offsetX = (float)((double)offsetX - 0.33);
                }
            }
            if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
                offsetZ = 0.25f;
                if (damageOutOf5 <= 4.0f && damageOutOf5 > 3.0f) {
                    offsetZ = (float)((double)offsetZ - 0.09);
                }
                if (damageOutOf5 <= 3.0f && damageOutOf5 > 2.0f) {
                    offsetZ = (float)((double)offsetZ - 0.18);
                }
                if (damageOutOf5 <= 2.0f && damageOutOf5 > 1.0f) {
                    offsetZ = (float)((double)offsetZ - 0.25);
                }
                if (damageOutOf5 <= 1.0f && damageOutOf5 > 0.0f) {
                    offsetZ = (float)((double)offsetZ - 0.33);
                }
            }
            if (this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST) {
                offsetZ = -0.25f;
                if (damageOutOf5 <= 4.0f && damageOutOf5 > 3.0f) {
                    offsetZ = (float)((double)offsetZ + 0.09);
                }
                if (damageOutOf5 <= 3.0f && damageOutOf5 > 2.0f) {
                    offsetZ = (float)((double)offsetZ + 0.18);
                }
                if (damageOutOf5 <= 2.0f && damageOutOf5 > 1.0f) {
                    offsetZ = (float)((double)offsetZ + 0.25);
                }
                if (damageOutOf5 <= 1.0f && damageOutOf5 > 0.0f) {
                    offsetZ = (float)((double)offsetZ + 0.33);
                }
            }
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)this.f_58858_.m_123341_() + 0.5f + offsetX), (double)((float)this.f_58858_.m_123342_() + 0.25f), (double)((float)this.f_58858_.m_123343_() + 0.5f + offsetZ), (rand.nextDouble() - 0.5) / 50.0, (rand.nextDouble() + 0.5) * 0.045, (rand.nextDouble() - 0.5) / 50.0);
            if (rand.nextInt(10) == 0) {
                this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123777_, (double)((float)this.f_58858_.m_123341_() + 0.5f + offsetX), (double)((float)this.f_58858_.m_123342_() + 0.25f), (double)((float)this.f_58858_.m_123343_() + 0.5f + offsetZ), (rand.nextDouble() - 0.5) / 50.0, (rand.nextDouble() + 0.5) * 0.045, (rand.nextDouble() - 0.5) / 50.0);
            }
        }
        if ((Integer)this.m_58900_().m_61143_((Property)SageBurningPlate.MODE) != 3) {
            for (int i = 0; i < 360; ++i) {
                BlockPos pos;
                Vec3 vec = new Vec3((double)(Mth.m_14031_((float)((float)i / 360.0f * ((float)Math.PI * 2))) * (rand.nextFloat() * (float)((Integer)HexConfig.SAGE_BURNING_PLATE_RANGE.get()).intValue())), (double)(Mth.m_14031_((float)((float)rand.nextInt(360) / 360.0f * ((float)Math.PI * 2))) * (rand.nextFloat() * (float)((Integer)HexConfig.SAGE_BURNING_PLATE_RANGE.get()).intValue())), (double)(Mth.m_14089_((float)((float)i / 360.0f * ((float)Math.PI * 2))) * (rand.nextFloat() * (float)((Integer)HexConfig.SAGE_BURNING_PLATE_RANGE.get()).intValue())));
                Vec3 vec2 = new Vec3((double)(Mth.m_14031_((float)((float)i / 360.0f * ((float)Math.PI * 2))) * (float)((Integer)HexConfig.SAGE_BURNING_PLATE_RANGE.get()).intValue()), 0.0, (double)(Mth.m_14089_((float)((float)i / 360.0f * ((float)Math.PI * 2))) * (float)((Integer)HexConfig.SAGE_BURNING_PLATE_RANGE.get()).intValue()));
                BlockPos pos2 = new BlockPos((double)((float)this.f_58858_.m_123341_() + 0.5f) + vec2.m_7096_(), (double)((float)this.f_58858_.m_123342_() + 0.25f) + vec2.m_7098_(), (double)((float)this.f_58858_.m_123343_() + 0.5f) + vec2.m_7094_());
                if (!(rand.nextInt(40) != 0 || (Integer)this.m_58900_().m_61143_((Property)SageBurningPlate.MODE) != 0 && (Integer)this.m_58900_().m_61143_((Property)SageBurningPlate.MODE) != 1 || this.f_58857_.m_8055_((pos = new BlockPos((double)((float)this.f_58858_.m_123341_() + 0.5f) + vec.m_7096_(), (double)((float)this.f_58858_.m_123342_() + 0.25f) + vec.m_7098_(), (double)((float)this.f_58858_.m_123343_() + 0.5f) + vec.m_7094_())).m_7495_()).m_60795_() && this.f_58857_.m_8055_(pos.m_7495_().m_7495_()).m_60795_() || !this.f_58857_.m_8055_(pos).m_60795_())) {
                    this.f_58857_.m_7106_((ParticleOptions)ModParticleTypes.FOG.get(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (rand.nextDouble() - 0.5) / 15.0, (rand.nextDouble() + 0.5) * 0.015, (rand.nextDouble() - 0.5) / 15.0);
                }
                if (rand.nextInt(160) != 0 || (Integer)this.m_58900_().m_61143_((Property)SageBurningPlate.MODE) != 1 && (Integer)this.m_58900_().m_61143_((Property)SageBurningPlate.MODE) != 2) continue;
                this.f_58857_.m_7106_((ParticleOptions)ModParticleTypes.FOG.get(), (double)pos2.m_123341_(), (double)pos2.m_123342_(), (double)pos2.m_123343_(), (rand.nextDouble() - 0.5) / 15.0, (rand.nextDouble() + 0.5) * 0.015, (rand.nextDouble() - 0.5) / 15.0);
            }
        }
    }

    public void tick() {
        if (((Boolean)this.m_58900_().m_61143_((Property)SageBurningPlate.LIT)).booleanValue()) {
            if (this.burnTime <= 0) {
                if (!this.f_58857_.f_46443_) {
                    ((ItemStack)this.items.get(0)).m_41629_(1, new Random(), null);
                    if (((ItemStack)this.items.get(0)).m_41773_() >= ((ItemStack)this.items.get(0)).m_41776_()) {
                        this.m_7407_(0, 1);
                    } else {
                        this.sync();
                    }
                    this.burnTime = this.burnTimeMax;
                }
            } else {
                --this.burnTime;
                this.emitParticles();
            }
        }
    }

    public int[] m_7071_(Direction p_19238_) {
        return new int[]{0};
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.m_7013_(index, itemStackIn);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return ((ItemStack)this.items.get(index)).m_41619_() && stack.m_150930_((Item)ModItems.DRIED_SAGE_BUNDLE.get());
    }

    public boolean m_7157_(int index, ItemStack p_19240_, Direction p_19241_) {
        return true;
    }

    public int m_6643_() {
        return this.items.size();
    }
}

