/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util;

import io.netty.buffer.Unpooled;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IRegistryDelegate;
import net.minecraftforge.registries.RegistryObject;

public class HexereiUtil {
    private static final DecimalFormat dfShort = new DecimalFormat("0.0");
    private static final DecimalFormat dfShortDouble = new DecimalFormat("0.00");

    public static String format1DP(double value) {
        return dfShort.format(value);
    }

    public static String format2DP(double value) {
        return dfShortDouble.format(value);
    }

    public static boolean isPointInRegion(int x, int y, int width, int height, double mouseX, double mouseY) {
        return mouseX >= (double)(x - 1) && mouseX < (double)(x + width + 1) && mouseY >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    public static float[] rgbIntToFloatArray(int rgbInt) {
        int r = rgbInt >> 16 & 0xFF;
        int g = rgbInt >> 8 & 0xFF;
        int b = rgbInt >> 0 & 0xFF;
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
    }

    public static int[] rgbIntToIntArray(int rgbInt) {
        int r = rgbInt >> 16 & 0xFF;
        int g = rgbInt >> 8 & 0xFF;
        int b = rgbInt >> 0 & 0xFF;
        return new int[]{r, g, b};
    }

    public static boolean entityIsHostile(Entity entity) {
        return entity.m_6095_().m_20674_().equals((Object)MobCategory.MONSTER);
    }

    public static List<BlockPos> getAllTileEntityPositionsNearby(BlockEntityType<?> te, Integer radius, Level world, Entity entity) {
        BlockPos entitypos = entity.m_142538_();
        ArrayList<BlockPos> nearby = new ArrayList<BlockPos>();
        List<BlockEntity> tiles = HexereiUtil.getTileEntitiesAroundPosition(world, entitypos, radius);
        for (BlockEntity tile : tiles) {
            BlockPos tilePos;
            BlockEntityType tileType = tile.m_58903_();
            if (tileType == null || !tileType.equals(te) || !(tilePos = tile.m_58899_()).m_123306_((Position)entity.m_20182_(), (double)radius.intValue())) continue;
            nearby.add(tile.m_58899_());
        }
        return nearby;
    }

    private static List<BlockEntity> getTileEntitiesAroundPosition(Level world, BlockPos pos, Integer radius) {
        ArrayList<BlockEntity> blockentities = new ArrayList<BlockEntity>();
        int chunkradius = (int)Math.ceil((double)radius.intValue() / 16.0);
        int chunkPosX = pos.m_123341_() >> 4;
        int chunkPosZ = pos.m_123343_() >> 4;
        for (int x = chunkPosX - chunkradius; x < chunkPosX + chunkradius; ++x) {
            for (int z = chunkPosZ - chunkradius; z < chunkPosZ + chunkradius; ++z) {
                if (!world.m_7232_(x, z)) continue;
                for (BlockEntity be : world.m_6325_(x, z).m_62954_().values()) {
                    if (blockentities.contains(be)) continue;
                    blockentities.add(be);
                }
            }
        }
        return blockentities;
    }

    public static ResourceLocation getResource(String name) {
        return HexereiUtil.getResource("hexerei", name);
    }

    public static ResourceLocation getResource(String modId, String name) {
        return new ResourceLocation(modId, name);
    }

    public static String getResourcePath(String name) {
        return HexereiUtil.getResourcePath("hexerei", name);
    }

    public static String getResourcePath(String modId, String name) {
        return HexereiUtil.getResource(modId, name).toString();
    }

    public static FriendlyByteBuf createBuf() {
        return new FriendlyByteBuf(Unpooled.buffer());
    }

    public static <T> T make(Supplier<T> supplier) {
        return supplier.get();
    }

    public static <T> T make(T object, Consumer<T> consumer) {
        consumer.accept(object);
        return object;
    }

    public static BlockState getBlockStateWithExistingProperties(BlockState oldState, BlockState newState) {
        BlockState finalState = newState;
        for (Property property : oldState.m_61147_()) {
            if (!newState.m_61138_(property)) continue;
            finalState = HexereiUtil.newStateWithOldProperty(oldState, finalState, property);
        }
        return finalState;
    }

    public static BlockState setBlockStateWithExistingProperties(Level level, BlockPos pos, BlockState newState, int flags) {
        BlockState oldState = level.m_8055_(pos);
        BlockState finalState = HexereiUtil.getBlockStateWithExistingProperties(oldState, newState);
        level.m_7260_(pos, oldState, finalState, flags);
        level.m_7731_(pos, finalState, flags);
        return finalState;
    }

    public static <T extends Comparable<T>> BlockState newStateWithOldProperty(BlockState oldState, BlockState newState, Property<T> property) {
        return (BlockState)newState.m_61124_(property, oldState.m_61143_(property));
    }

    public static <T extends IForgeRegistryEntry<? super T>> RegistryObject<T> acceptOrElse(RegistryObject<T> opt, Consumer<T> consumer, Runnable orElse) {
        if (opt.isPresent()) {
            consumer.accept(opt.get());
        } else {
            orElse.run();
        }
        return opt;
    }

    public static <T> Optional<T> acceptOrElse(Optional<T> opt, Consumer<T> consumer, Runnable orElse) {
        if (opt.isPresent()) {
            consumer.accept(opt.get());
        } else {
            orElse.run();
        }
        return opt;
    }

    public static <T> boolean allMatch(Iterable<T> input, Predicate<T> matcher) {
        Objects.requireNonNull(matcher);
        for (T e : input) {
            if (matcher.test(e)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean anyMatch(Iterable<T> input, Predicate<T> matcher) {
        Objects.requireNonNull(matcher);
        for (T e : input) {
            if (!matcher.test(e)) continue;
            return true;
        }
        return false;
    }

    public static ResourceLocation getRegistryId(Object obj) {
        if (obj instanceof ResourceLocation) {
            return (ResourceLocation)obj;
        }
        if (obj instanceof String) {
            return ResourceLocation.m_135820_((String)((String)obj));
        }
        if (obj instanceof IForgeRegistryEntry) {
            return ((IForgeRegistryEntry)obj).getRegistryName();
        }
        if (obj instanceof IRegistryDelegate) {
            return ((IRegistryDelegate)obj).name();
        }
        if (obj instanceof RegistryObject) {
            return ((RegistryObject)obj).getId();
        }
        return null;
    }
}

