/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.world.structure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.joefoxe.hexerei.config.HexConfig;
import net.joefoxe.hexerei.world.structure.structures.DarkCovenStructure;
import net.joefoxe.hexerei.world.structure.structures.WitchHutStructure;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModStructures {
    public static final DeferredRegister<StructureFeature<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"hexerei");
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> WITCH_HUT = STRUCTURES.register("witch_hut", () -> new WitchHutStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> DARK_COVEN = STRUCTURES.register("dark_coven", () -> new DarkCovenStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));

    private static <T extends StructureFeature<?>> RegistryObject<T> addToStructureMaps(String name, Supplier<T> structure) {
        return STRUCTURES.register(name, structure);
    }

    public static void setupStructures() {
        ModStructures.setupMapSpacingAndLand((StructureFeature)WITCH_HUT.get(), new StructureFeatureConfiguration(((Integer)HexConfig.WITCH_HUT_SPACING.get()).intValue(), ((Integer)HexConfig.WITCH_HUT_SEPARATION.get()).intValue(), 1234567890), false);
        ModStructures.setupMapSpacingAndLand((StructureFeature)DARK_COVEN.get(), new StructureFeatureConfiguration(((Integer)HexConfig.DARK_COVEN_SPACING.get()).intValue(), ((Integer)HexConfig.DARK_COVEN_SEPARATION.get()).intValue(), 1418987890), false);
    }

    public static <F extends StructureFeature<?>> void setupMapSpacingAndLand(F structure, StructureFeatureConfiguration structureSeparationSettings, boolean transformSurroundingLand) {
        StructureFeature.f_67012_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            StructureFeature.f_67031_ = ImmutableList.builder().addAll((Iterable)StructureFeature.f_67031_).add(structure).build();
        }
        StructureSettings.f_64580_ = ImmutableMap.builder().putAll((Map)StructureSettings.f_64580_).put(structure, (Object)structureSeparationSettings).build();
        BuiltinRegistries.f_123866_.m_6579_().forEach(settings -> {
            Map structureMap = ((NoiseGeneratorSettings)settings.getValue()).m_64457_().f_64582_;
            if (structureMap instanceof ImmutableMap) {
                HashMap<StructureFeature, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(structureMap);
                tempMap.put(structure, structureSeparationSettings);
                ((NoiseGeneratorSettings)settings.getValue()).m_64457_().m_64590_();
            } else {
                structureMap.put(structure, structureSeparationSettings);
            }
        });
    }

    public static void register(IEventBus eventBus) {
        STRUCTURES.register(eventBus);
    }
}

