/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.world.structure.structures;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.joefoxe.hexerei.world.structure.structures.AbstractBaseStructure;
import net.joefoxe.hexerei.world.structure.structures.GenericJigsawStructureCodeConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;

public class GenericJigsawStructure
extends AbstractBaseStructure<NoneFeatureConfiguration> {
    public GenericJigsawStructure(Predicate<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>> locationCheckPredicate, Function<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>, Optional<PieceGenerator<NoneFeatureConfiguration>>> pieceCreationPredicate) {
        super(NoneFeatureConfiguration.f_67815_, locationCheckPredicate, pieceCreationPredicate);
    }

    protected boolean isFeatureChunk(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, GenericJigsawStructureCodeConfig config) {
        ChunkPos chunkPos = context.f_197355_();
        if (!(context.f_197353_() instanceof CheckerboardColumnBiomeSource)) {
            for (int curChunkX = chunkPos.f_45578_ - config.biomeRange; curChunkX <= chunkPos.f_45578_ + config.biomeRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.f_45579_ - config.biomeRange; curChunkZ <= chunkPos.f_45579_ + config.biomeRange; ++curChunkZ) {
                    int yValue = config.useHeightmap ? config.fixedYSpawn + context.f_197352_().m_156174_(curChunkX << 4, curChunkZ << 4, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_()) : config.fixedYSpawn;
                    Biome biome = context.f_197353_().m_183546_(curChunkX << 2, yValue >> 2, curChunkZ << 2, context.f_197352_().m_183403_());
                    if (context.f_197358_().test(biome)) continue;
                    return false;
                }
            }
        }
        if (config.allowTerrainHeightRange != -1) {
            int maxTerrainHeight = Integer.MIN_VALUE;
            int minTerrainHeight = Integer.MAX_VALUE;
            for (int curChunkX = chunkPos.f_45578_ - config.terrainHeightRadius; curChunkX <= chunkPos.f_45578_ + config.terrainHeightRadius; ++curChunkX) {
                for (int curChunkZ = chunkPos.f_45579_ - config.terrainHeightRadius; curChunkZ <= chunkPos.f_45579_ + config.terrainHeightRadius; ++curChunkZ) {
                    int height = context.f_197352_().m_142647_((curChunkX << 4) + 7, (curChunkZ << 4) + 7, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
                    maxTerrainHeight = Math.max(maxTerrainHeight, height);
                    if ((minTerrainHeight = Math.min(minTerrainHeight, height)) >= config.minHeightLimit) continue;
                    return false;
                }
            }
            return maxTerrainHeight - minTerrainHeight <= config.allowTerrainHeightRange;
        }
        if (config.cannotSpawnInWater) {
            BlockPos centerOfChunk = chunkPos.m_151394_(0);
            int landHeight = context.f_197352_().m_156179_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
            NoiseColumn columnOfBlocks = context.f_197352_().m_141914_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), context.f_197357_());
            BlockState topBlock = columnOfBlocks.m_183556_(centerOfChunk.m_123342_() + landHeight);
            return topBlock.m_60819_().m_76178_();
        }
        return true;
    }
}

