/*
 * Decompiled with CFR 0.152.
 */
package snownee.lightingwand;

import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.loader.event.ClientInitEvent;
import snownee.kiwi.loader.event.InitEvent;
import snownee.lightingwand.CommonConfig;
import snownee.lightingwand.client.EmptyEntityRenderer;
import snownee.lightingwand.common.LightBlock;
import snownee.lightingwand.common.LightEntity;
import snownee.lightingwand.common.RepairRecipe;
import snownee.lightingwand.common.RepairRecipeCondition;
import snownee.lightingwand.common.WandItem;

@KiwiModule
@KiwiModule.Subscriber(value=KiwiModule.Subscriber.Bus.MOD)
public class CoreModule
extends AbstractModule {
    @KiwiModule.NoItem
    public static Block LIGHT = new LightBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50016_).m_60953_(state -> (Integer)state.m_61143_((Property)LightBlock.LIGHT)).m_60918_(SoundType.f_56750_));
    @KiwiModule.Name(value="light")
    public static EntityType<LightEntity> PROJECTILE = EntityType.Builder.m_20704_(LightEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory((spawnEntity, world) -> new LightEntity((Level)world)).m_20699_(1.0E-4f, 1.0E-4f).m_20719_().setTrackingRange(64).setUpdateInterval(20).setShouldReceiveVelocityUpdates(true).m_20712_("lightingwand.light");
    public static Item WAND = new WandItem(CoreModule.itemProp().m_41491_(CreativeModeTab.f_40756_).setNoRepair().m_41503_(CommonConfig.wandDurability));
    public static RecipeSerializer<?> REPAIR = new RepairRecipe.Serializer();
    public static boolean psiCompat = Platform.isModLoaded((String)"psi");

    protected void init(InitEvent event) {
        CraftingHelper.register((IConditionSerializer)new RepairRecipeCondition.Serializer());
        if (CommonConfig.shootProjectile) {
            DispenserBlock.m_52672_((ItemLike)WAND, (source, stack) -> {
                ServerLevel world = source.m_7727_();
                if (!world.f_46443_ && WandItem.isUsable(stack)) {
                    Position iposition = DispenserBlock.m_52720_((BlockSource)source);
                    Direction Direction2 = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                    LightEntity entity = new LightEntity((Level)world);
                    entity.m_6034_(iposition.m_7096_(), iposition.m_7098_(), iposition.m_7094_());
                    entity.lightValue = WandItem.getLightValue(stack);
                    entity.m_6686_(Direction2.m_122429_(), (float)Direction2.m_122430_() + 0.1f, Direction2.m_122431_(), 1.3f + world.f_46441_.nextFloat() * 0.4f, 0.0f);
                    Vec3 motion = entity.m_20184_();
                    entity.m_20256_(motion.m_82520_(world.f_46441_.nextGaussian() * 0.1, 0.0, world.f_46441_.nextGaussian() * 0.1));
                    world.m_7967_((Entity)entity);
                    stack.m_41629_(1, world.f_46441_, null);
                }
                return stack;
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void clientInit(ClientInitEvent event) {
        ItemProperties.register((Item)WAND, (ResourceLocation)new ResourceLocation("broken"), (stack, worldIn, entityIn, seed) -> (float)(!WandItem.isUsable(stack) ? 1 : 0));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void entityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(PROJECTILE, EmptyEntityRenderer::new);
    }
}

