/*
 * Decompiled with CFR 0.152.
 */
package snownee.lightingwand.common;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import snownee.lightingwand.CoreModule;
import snownee.lightingwand.common.LightBlock;

public class LightEntity
extends ThrowableProjectile {
    public int lightValue = 15;

    public LightEntity(EntityType<?> type, Level levelIn) {
        this(levelIn);
    }

    public LightEntity(Level levelIn) {
        super(CoreModule.PROJECTILE, levelIn);
    }

    public LightEntity(Level levelIn, LivingEntity owner) {
        super(CoreModule.PROJECTILE, owner, levelIn);
    }

    protected float m_7139_() {
        return 0.01f;
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        float f = Mth.m_14116_((float)((float)(x * x + y * y + z * z)));
        this.m_20334_(x / (double)f * (double)velocity, y / (double)f * (double)velocity, z / (double)f * (double)velocity);
    }

    protected void m_6532_(HitResult result) {
        if (!this.f_19853_.f_46443_ && result != null) {
            this.m_146870_();
            BlockPos pos = null;
            switch (result.m_6662_()) {
                case MISS: {
                    return;
                }
                case ENTITY: {
                    pos = new BlockPos(result.m_82450_());
                    break;
                }
                case BLOCK: {
                    pos = ((BlockHitResult)result).m_82425_().m_142300_(((BlockHitResult)result).m_82434_());
                }
            }
            if (this.f_19853_.m_8055_(pos).m_60767_().m_76336_()) {
                FluidState fluidstate = this.f_19853_.m_6425_(pos);
                if (this.f_19853_.m_7731_(pos, (BlockState)((BlockState)CoreModule.LIGHT.m_49966_().m_61124_((Property)LightBlock.LIGHT, (Comparable)Integer.valueOf(Mth.m_14045_((int)this.lightValue, (int)1, (int)15)))).m_61124_((Property)LightBlock.WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76153_((Tag)FluidTags.f_13131_) && fluidstate.m_76186_() == 8)), 11)) {
                    this.f_19853_.m_5594_(null, pos, SoundEvents.f_12392_, SoundSource.BLOCKS, 1.0f, this.f_19853_.f_46441_.nextFloat() * 0.4f + 0.8f);
                }
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_ && !this.f_19861_) {
            Vec3 motion = this.m_20184_();
            for (int k = 0; k < 2; ++k) {
                this.f_19853_.m_7106_((ParticleOptions)new DustParticleOptions(LightBlock.COLOR_VEC, 1.0f), this.m_20185_() + motion.f_82479_ * (double)k / 2.0, this.m_20186_() + motion.f_82480_ * (double)k / 2.0, this.m_20189_() + motion.f_82481_ * (double)k / 2.0, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void m_8097_() {
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.lightValue = compound.m_128451_("Light");
        if (this.lightValue == 0) {
            this.lightValue = 15;
        }
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Light", this.lightValue);
    }
}

