/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core;

import com.supermartijn642.core.ClientUtils;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.client.resources.language.LanguageManager;

public class EnergyFormat {
    private static EnergyType type = EnergyType.RF;

    public static void cycleEnergyType(boolean forward) {
        type = EnergyType.values()[(type.ordinal() + (forward ? 1 : EnergyType.values().length - 1)) % EnergyType.values().length];
    }

    public static String formatEnergy(int energy) {
        return type.convertEnergy(energy);
    }

    public static String formatUnit() {
        return type.getUnit();
    }

    public static String formatUnitPerTick() {
        return EnergyFormat.type.unit + "/t";
    }

    private static enum EnergyType {
        FE("FE"),
        RF("RF");

        private final String unit;

        private EnergyType(String unit) {
            this.unit = unit;
        }

        public String getUnit() {
            return this.unit;
        }

        public String convertEnergy(int energy) {
            LanguageManager manager = ClientUtils.getMinecraft().m_91102_();
            Locale locale = manager == null || manager.m_118983_() == null ? Locale.getDefault() : manager.m_118983_().getJavaLocale();
            return NumberFormat.getNumberInstance(locale).format(energy);
        }
    }
}

