/*
 * Decompiled with CFR 0.152.
 */
package vazkii.akashictome.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import vazkii.akashictome.AkashicTome;
import vazkii.akashictome.MorphingHandler;
import vazkii.akashictome.network.MessageMorphTome;
import vazkii.arl.util.ItemNBTHelper;

public class TomeScreen
extends Screen {
    private static final ResourceLocation BOOK_TEXTURE = new ResourceLocation("akashictome:textures/models/book.png");
    private final BookModel BOOK_MODEL;
    final ItemStack tome;
    String definedMod;

    public TomeScreen(ItemStack tome) {
        super((Component)new TextComponent(""));
        this.tome = tome;
        this.BOOK_MODEL = new BookModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171271_));
    }

    public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (p_mouseClicked_5_ == 0 && this.definedMod != null) {
            AkashicTome.sendToServer(new MessageMorphTome(this.definedMod));
            this.f_96541_.m_91152_(null);
            return true;
        }
        return super.m_6375_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.definedMod = null;
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (this.tome.m_41782_()) {
            CompoundTag data = this.tome.m_41783_().m_128469_("akashictome:data");
            ArrayList keys = Lists.newArrayList((Iterable)data.m_128431_());
            Collections.sort(keys);
            for (String s : keys) {
                CompoundTag cmp = data.m_128469_(s);
                if (cmp == null) continue;
                ItemStack modStack = ItemStack.m_41712_((CompoundTag)cmp);
                stacks.add(modStack);
            }
        }
        Window window = this.f_96541_.m_91268_();
        int centerX = window.m_85445_() / 2;
        int centerY = window.m_85446_() / 2;
        int amountPerRow = 6;
        int rows = stacks.size() / amountPerRow + 1;
        int iconSize = 20;
        int startX = centerX - amountPerRow * iconSize / 2;
        int startY = centerY - rows * iconSize + 45;
        int padding = 4;
        int extra = 2;
        TomeScreen.m_93172_((PoseStack)matrixStack, (int)(startX - padding), (int)(startY - padding), (int)(startX + iconSize * amountPerRow + padding), (int)(startY + iconSize * rows + padding), (int)0x22000000);
        TomeScreen.m_93172_((PoseStack)matrixStack, (int)(startX - padding - extra), (int)(startY - padding - extra), (int)(startX + iconSize * amountPerRow + padding + extra), (int)(startY + iconSize * rows + padding + extra), (int)0x22000000);
        ItemStack tooltipStack = ItemStack.f_41583_;
        if (!stacks.isEmpty()) {
            for (int i = 0; i < stacks.size(); ++i) {
                int x = startX + i % amountPerRow * iconSize;
                int y = startY + i / amountPerRow * iconSize;
                ItemStack stack = (ItemStack)stacks.get(i);
                if (mouseX > x && mouseY > y && mouseX <= x + 16 && mouseY <= y + 16) {
                    tooltipStack = stack;
                    y -= 2;
                }
                this.f_96541_.m_91291_().m_115203_(stack, x, y);
            }
        }
        if (!tooltipStack.m_41619_()) {
            CompoundTag name = ItemNBTHelper.getCompound((ItemStack)tooltipStack, (String)"akashictome:displayName", (boolean)false);
            String tempDefinedMod = MorphingHandler.getModFromStack(tooltipStack);
            String mod = ChatFormatting.GRAY + MorphingHandler.getModNameForId(tempDefinedMod);
            tempDefinedMod = ItemNBTHelper.getString((ItemStack)tooltipStack, (String)"akashictome:definedMod", (String)tempDefinedMod);
            String trueName = name.m_128461_("text");
            List tooltipList = Arrays.stream(new String[]{trueName, mod}).map(TextComponent::new).collect(Collectors.toList());
            this.renderComponentTooltip(matrixStack, tooltipList, mouseX, mouseY, this.f_96547_);
            this.definedMod = tempDefinedMod;
        }
        Lighting.m_84930_();
        int guiScale = (int)this.f_96541_.m_91268_().m_85449_();
        int viewportWidth = 320;
        int viewportHeight = 240;
        RenderSystem.m_69949_((int)((this.f_96543_ - viewportWidth) / 2 * guiScale), (int)((this.f_96544_ - viewportHeight) / 2 * guiScale), (int)(viewportWidth * guiScale), (int)(viewportHeight * guiScale));
        Matrix4f projMat = Matrix4f.m_27653_((float)-0.34f, (float)0.23f, (float)0.0f);
        projMat.m_27644_(Matrix4f.m_27625_((double)90.0, (float)1.3333334f, (float)9.0f, (float)80.0f));
        RenderSystem.m_157183_();
        RenderSystem.m_157425_((Matrix4f)projMat);
        matrixStack.m_85836_();
        PoseStack.Pose pose = matrixStack.m_85850_();
        pose.m_85861_().m_27624_();
        pose.m_85864_().m_8180_();
        matrixStack.m_85837_(6.3, (double)3.3f, 1984.0);
        float scale = 15.0f;
        matrixStack.m_85841_(scale, scale, scale);
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(20.0f));
        float f1 = 1.0f;
        matrixStack.m_85837_((double)((1.0f - f1) * 0.2f), (double)((1.0f - f1) * 0.1f), (double)((1.0f - f1) * 0.25f));
        float f2 = -(1.0f - f1) * 90.0f - 90.0f;
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(f2));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        float f3 = 0.25f;
        float f4 = 0.75f;
        f3 = (f3 - (float)Mth.m_14080_((double)f3)) * 1.6f - 0.3f;
        f4 = (f4 - (float)Mth.m_14080_((double)f4)) * 1.6f - 0.3f;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        this.BOOK_MODEL.m_102292_(0.0f, f3, f4, f1);
        MultiBufferSource.BufferSource buffers = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        VertexConsumer buffer = buffers.m_6299_(this.BOOK_MODEL.m_103119_(BOOK_TEXTURE));
        this.BOOK_MODEL.m_7695_(matrixStack, buffer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        buffers.m_109911_();
        matrixStack.m_85849_();
        RenderSystem.m_69949_((int)0, (int)0, (int)this.f_96541_.m_91268_().m_85441_(), (int)this.f_96541_.m_91268_().m_85442_());
        RenderSystem.m_157424_();
        Lighting.m_84931_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

