/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.jei;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IIngredientVisibility;
import net.mehvahdjukaar.jeed.jei.JEIPlugin;
import net.mehvahdjukaar.jeed.recipes.EffectProviderRecipe;
import net.mehvahdjukaar.jeed.recipes.PotionProviderRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;

public class EffectInfoRecipe {
    private static final Lazy<Map<MobEffect, List<ItemStack>>> EFFECT_PROVIDERS_CACHE = Lazy.of(EffectInfoRecipe::buildEffectProviderCache);
    private static final int lineSpacing = 2;
    private final List<FormattedText> description;
    private final MobEffectInstance effect;
    private final IIngredientType<MobEffectInstance> effectIngredientType;
    private final List<ItemStack> inputItems;

    private EffectInfoRecipe(MobEffectInstance effectInstance, IIngredientType<MobEffectInstance> ingredientType, List<FormattedText> description) {
        this.description = description;
        this.effect = effectInstance;
        this.effectIngredientType = ingredientType;
        this.inputItems = EffectInfoRecipe.getEffectProviders(effectInstance.m_19544_());
    }

    private static Map<MobEffect, List<ItemStack>> buildEffectProviderCache() {
        HashMap<MobEffect, List<ItemStack>> effectProvidingItems = new HashMap<MobEffect, List<ItemStack>>();
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            List<EffectProviderRecipe> recipes = EffectInfoRecipe.getRecipesOfType((Level)world, r -> r instanceof EffectProviderRecipe ? (EffectProviderRecipe)r : null);
            for (EffectProviderRecipe p : recipes) {
                p.getEffects().forEach(e -> effectProvidingItems.computeIfAbsent((MobEffect)e, i -> new ItemStackList()).addAll(p.getProviders()));
            }
            List<PotionProviderRecipe> potionRecipes = EffectInfoRecipe.getRecipesOfType((Level)world, r -> r instanceof PotionProviderRecipe ? (PotionProviderRecipe)r : null);
            for (PotionProviderRecipe p : potionRecipes) {
                for (ItemStack stack : p.getProviders()) {
                    Collection<Object> acceptablePotions = p.getPotions();
                    if (acceptablePotions.isEmpty()) {
                        acceptablePotions = ForgeRegistries.POTIONS.getValues();
                    }
                    for (Potion potion : acceptablePotions) {
                        ItemStack copy = stack.m_41777_();
                        PotionUtils.m_43549_((ItemStack)copy, (Potion)potion);
                        for (MobEffectInstance effect : potion.m_43488_()) {
                            effectProvidingItems.computeIfAbsent(effect.m_19544_(), i -> new ItemStackList()).add(copy);
                        }
                    }
                }
            }
            for (Block b : ForgeRegistries.BLOCKS) {
                if (!(b instanceof FlowerBlock)) continue;
                FlowerBlock flowerblock = (FlowerBlock)b;
                ItemStack stew = new ItemStack((ItemLike)Items.f_42718_);
                MobEffect effect = flowerblock.m_53521_();
                SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)effect, (int)200);
                effectProvidingItems.computeIfAbsent(effect, i -> new ItemStackList()).add(stew);
            }
            for (Item i2 : ForgeRegistries.ITEMS) {
                FoodProperties food = i2.m_41473_();
                if (food == null) continue;
                ItemStack foodItem = new ItemStack((ItemLike)i2);
                for (Pair pair : food.m_38749_()) {
                    effectProvidingItems.computeIfAbsent(((MobEffectInstance)pair.getFirst()).m_19544_(), s -> new ItemStackList()).add(foodItem);
                }
            }
            for (MobEffect[] array : BeaconBlockEntity.f_58646_) {
                for (MobEffect e2 : array) {
                    effectProvidingItems.computeIfAbsent(e2, s -> new ItemStackList()).add(Items.f_42065_.m_7968_());
                }
            }
        }
        return effectProvidingItems;
    }

    private static <T> List<T> getRecipesOfType(Level world, Function<Recipe<?>, T> function) {
        return world.m_7465_().m_44051_().stream().map(function).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<ItemStack> getInputItems() {
        IIngredientVisibility ingredientVisibility = JEIPlugin.JEI_INGREDIENT_VISIBILITY;
        return this.inputItems.stream().filter(s -> !s.m_41619_()).filter(s -> ingredientVisibility.isIngredientVisible(VanillaTypes.ITEM, s)).collect(Collectors.toList());
    }

    private static NonNullList<ItemStack> getEffectProviders(MobEffect effect) {
        NonNullList list = NonNullList.m_122779_();
        list.addAll((Collection)((Map)EFFECT_PROVIDERS_CACHE.get()).getOrDefault(effect, new ItemStackList()));
        return list;
    }

    public static List<EffectInfoRecipe> create(MobEffectInstance ingredient, IIngredientType<MobEffectInstance> ingredientType, String descriptionKey) {
        TranslatableComponent text = new TranslatableComponent(descriptionKey);
        if (text.getString().equals(descriptionKey)) {
            text = new TranslatableComponent("jeed.description.missing");
        }
        return EffectInfoRecipe.create(ingredient, ingredientType, (Component)text);
    }

    public static List<EffectInfoRecipe> create(MobEffectInstance ingredient, IIngredientType<MobEffectInstance> ingredientType, Component descriptionComponent) {
        ArrayList<EffectInfoRecipe> recipes = new ArrayList<EffectInfoRecipe>();
        List<FormattedText> descriptionLines = EffectInfoRecipe.expandNewlines(descriptionComponent);
        descriptionLines = EffectInfoRecipe.wrapDescriptionLines(descriptionLines);
        int lineCount = descriptionLines.size();
        Minecraft minecraft = Minecraft.m_91087_();
        Objects.requireNonNull(minecraft.f_91062_);
        int maxLinesPerPage = 45 / (9 + 2);
        int pageCount = EffectInfoRecipe.divideCeil(lineCount, maxLinesPerPage);
        for (int i = 0; i < pageCount; ++i) {
            int startLine = i * maxLinesPerPage;
            int endLine = Math.min((i + 1) * maxLinesPerPage, lineCount);
            List<FormattedText> description = descriptionLines.subList(startLine, endLine);
            EffectInfoRecipe recipe = new EffectInfoRecipe(ingredient, ingredientType, description);
            recipes.add(recipe);
        }
        return recipes;
    }

    public static int divideCeil(int numerator, int denominator) {
        return (int)Math.ceil((float)numerator / (float)denominator);
    }

    private static List<FormattedText> expandNewlines(Component ... descriptionComponents) {
        ArrayList<FormattedText> descriptionLinesExpanded = new ArrayList<FormattedText>();
        for (Component descriptionLine : descriptionComponents) {
            ExpandNewLineTextAcceptor newLineTextAcceptor = new ExpandNewLineTextAcceptor();
            descriptionLine.m_7451_((FormattedText.StyledContentConsumer)newLineTextAcceptor, Style.f_131099_);
            newLineTextAcceptor.addLinesTo(descriptionLinesExpanded);
        }
        return descriptionLinesExpanded;
    }

    private static List<FormattedText> wrapDescriptionLines(List<FormattedText> descriptionLines) {
        Minecraft minecraft = Minecraft.m_91087_();
        ArrayList<FormattedText> descriptionLinesWrapped = new ArrayList<FormattedText>();
        for (FormattedText descriptionLine : descriptionLines) {
            List textLines = minecraft.f_91062_.m_92865_().m_92414_(descriptionLine, 160, Style.f_131099_);
            descriptionLinesWrapped.addAll(textLines);
        }
        return descriptionLinesWrapped;
    }

    public List<FormattedText> getDescription() {
        return this.description;
    }

    public IIngredientType<MobEffectInstance> getEffectIngredientType() {
        return this.effectIngredientType;
    }

    public MobEffectInstance getEffect() {
        return this.effect;
    }

    private static class ItemStackList
    extends ArrayList<ItemStack> {
        public ItemStackList() {
        }

        public ItemStackList(MobEffect ignored) {
        }

        @Override
        public boolean add(ItemStack stack) {
            if (stack.m_41619_()) {
                return false;
            }
            for (ItemStack thisStack : this) {
                if (!ItemStack.m_41728_((ItemStack)thisStack, (ItemStack)stack)) continue;
                return false;
            }
            return super.add(stack);
        }
    }

    private static class ExpandNewLineTextAcceptor
    implements FormattedText.StyledContentConsumer<Void> {
        private final List<FormattedText> lines = new ArrayList<FormattedText>();
        @Nullable
        private MutableComponent lastComponent;

        private ExpandNewLineTextAcceptor() {
        }

        public Optional<Void> m_7164_(Style style, String line) {
            String[] descriptionLineExpanded = line.split("\\\\n");
            for (int i = 0; i < descriptionLineExpanded.length; ++i) {
                String s = descriptionLineExpanded[i];
                if (s.isEmpty()) {
                    if (i == 0 && this.lastComponent != null) {
                        this.lines.add((FormattedText)this.lastComponent);
                        this.lastComponent = null;
                        continue;
                    }
                    this.lines.add((FormattedText)TextComponent.f_131282_);
                    continue;
                }
                TextComponent textComponent = new TextComponent(s);
                textComponent.m_6270_(style);
                if (this.lastComponent != null) {
                    if (i == 0) {
                        if (!this.lastComponent.m_7383_().m_131179_() && !this.lastComponent.m_7383_().equals((Object)style)) {
                            this.lastComponent = new TextComponent("").m_7220_((Component)this.lastComponent);
                        }
                        this.lastComponent.m_7220_((Component)textComponent);
                        continue;
                    }
                    this.lines.add((FormattedText)this.lastComponent);
                    this.lastComponent = null;
                }
                if (i == descriptionLineExpanded.length - 1) {
                    this.lastComponent = textComponent;
                    continue;
                }
                this.lines.add((FormattedText)textComponent);
            }
            return Optional.empty();
        }

        public void addLinesTo(List<FormattedText> descriptionLinesExpanded) {
            descriptionLinesExpanded.addAll(this.lines);
            if (this.lastComponent != null) {
                descriptionLinesExpanded.add((FormattedText)this.lastComponent);
            }
        }
    }
}

